/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.conversion.ConversionTime;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogSpeedNew
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspList = null;
    private JList listeJour = null;
    private JFreeChart jfcVitesse = null;
    private TimeSeriesCollection tscVitesse = null;
    private TimeSeries tsVitesse = null;
    private ChartPanel cpVitesse = null;
    private TreeMap<String, Hashtable<Integer, String>> vitesse = null;
    private DefaultListModel model = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogSpeedNew.dispose()#");
        super.dispose();
    }

    public DialogSpeedNew(Frame owner, TreeMap<String, Hashtable<Integer, String>> vitesse) {
        super(owner);
        TimsLogger.verbose("#DialogSpeedNew()#");
        this.vitesse = vitesse;
        this.initialize();
        this.load(null);
        this.setVisible(true);
    }

    private void initialize() {
        this.setModal(true);
        this.setSize(750, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("generics.speed"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.15;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspList(), gridBagConstraints);
            this.jContentPane.add((Component)this.getCpVitesse(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getListeJour());
        }
        return this.jspList;
    }

    private JList getListeJour() {
        if (this.listeJour == null) {
            this.listeJour = new JList();
            this.model = new DefaultListModel();
            this.listeJour.setModel(this.model);
            this.listeJour.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        DialogSpeedNew.this.load(DialogSpeedNew.this.getListeJour().getSelectedValue().toString());
                    }
                }
            });
        }
        return this.listeJour;
    }

    private JFreeChart getJfcVitesse() {
        if (this.jfcVitesse == null) {
            this.jfcVitesse = ChartFactory.createTimeSeriesChart((String)"", (String)LanguageTranslator.getString("generics.hour"), (String)LanguageTranslator.getString("generics.speed"), (XYDataset)this.getTscVitesse(), (boolean)false, (boolean)true, (boolean)false);
        }
        return this.jfcVitesse;
    }

    private TimeSeriesCollection getTscVitesse() {
        if (this.tscVitesse == null) {
            this.tscVitesse = new TimeSeriesCollection(this.getTsVitesse());
        }
        return this.tscVitesse;
    }

    private TimeSeries getTsVitesse() {
        if (this.tsVitesse == null) {
            this.tsVitesse = new TimeSeries((Comparable)((Object)LanguageTranslator.getString("generics.speed")), Second.class);
        }
        return this.tsVitesse;
    }

    private ChartPanel getCpVitesse() {
        if (this.cpVitesse == null) {
            this.cpVitesse = new ChartPanel(this.getJfcVitesse(), true);
            this.cpVitesse.setDismissDelay(10000);
            this.cpVitesse.setInitialDelay(10);
            this.cpVitesse.setReshowDelay(10);
            this.cpVitesse.setRangeZoomable(false);
            this.cpVitesse.setFillZoomRectangle(true);
        }
        return this.cpVitesse;
    }

    private void load(String day) {
        if (day == null) {
            Set<String> listeJour = this.vitesse.keySet();
            for (String element : listeJour) {
                this.model.addElement(element);
            }
        } else {
            Hashtable<Integer, String> detailVitesse = this.vitesse.get(day);
            if (detailVitesse == null) {
                return;
            }
            this.getTsVitesse().clear();
            Day dateJour = new Day(ConversionTime.stringToDate(day, "dd/MM/yyyy"));
            int i = 0;
            while (i < 1440) {
                String tmp = detailVitesse.get(i);
                if (tmp != null) {
                    String[] tabVitesse = tmp.split(";");
                    int x = 0;
                    while (x < tabVitesse.length) {
                        this.getTsVitesse().add((RegularTimePeriod)new Second(x, new Minute(i - i / 60 * 60, new Hour(i / 60, dateJour))), (double)Integer.parseInt(tabVitesse[x]));
                        x += Transport.debug >= 1 ? 1 : 2;
                    }
                }
                ++i;
            }
        }
    }
}

