/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMVehicle;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogSupprimerVehicule
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JComboBox cbAgence = null;
    private JList listeVehicule = null;
    private JPanel pnlBtn = null;
    private JButton btnSupprimer = null;
    private JButton btnQuitter = null;
    private JScrollPane jspListe = null;
    private LMVehicle listModelVehicle = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogSupprimerVehicule.dispose()#");
        super.dispose();
    }

    public DialogSupprimerVehicule(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogSupprimerVehicule()#");
        this.initialize();
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 350, 400));
        this.setTitle(LanguageTranslator.getString("vehicle.delete"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints2.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getCbAgence(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
            this.cbAgence.setEditable(true);
            this.cbAgence.setModel(tmp);
            this.cbAgence.setSelectedItem("");
            this.cbAgence.setPreferredSize(new Dimension(150, 25));
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogSupprimerVehicule.this.majListe();
                }
            });
        }
        return this.cbAgence;
    }

    public void majListe() {
        int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        this.listModelVehicle = new LMVehicle(Vehicule.loadList(cleAgence));
        this.getListeVehicule().setModel(this.listModelVehicle);
    }

    private JList getListeVehicule() {
        if (this.listeVehicule == null) {
            this.listeVehicule = new JList();
            this.listeVehicule.setSize(new Dimension(0, 0));
            this.listeVehicule.setModel(this.getModeleVehicule());
            this.listeVehicule.setAutoscrolls(true);
        }
        return this.listeVehicule;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.setPreferredSize(new Dimension(167, 50));
            this.pnlBtn.add((Component)this.getBtnSupprimer(), gridBagConstraints);
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints1);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSupprimer() {
        if (this.btnSupprimer == null) {
            this.btnSupprimer = new JButton();
            this.btnSupprimer.setText(LanguageTranslator.getString("button.delete"));
            this.btnSupprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSupprimerVehicule.this.supprimerVehicule();
                }
            });
        }
        return this.btnSupprimer;
    }

    public void supprimerVehicule() {
        int confirm = JOptionPane.showConfirmDialog(this.getParent(), LanguageTranslator.getString("vehicle.warning.delete", this.getListeVehicule().getSelectedValue().toString()), LanguageTranslator.getString("message.confirm"), 0);
        if (confirm == 0) {
            int index = this.getListeVehicule().getSelectedIndex();
            Vehicule toDel = (Vehicule)this.getModeleVehicule().get(index);
            toDel.delete();
            this.getModeleVehicule().remove(index);
            JOptionPane.showMessageDialog(this.getParent(), LanguageTranslator.getString("message.deleteSucceed"), LanguageTranslator.getString("message.done"), 0);
        }
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSupprimerVehicule.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setPreferredSize(new Dimension(200, 200));
            this.jspListe.setViewportView(this.getListeVehicule());
            this.jspListe.setVerticalScrollBarPolicy(22);
        }
        return this.jspListe;
    }

    private LMVehicle getModeleVehicule() {
        if (this.listModelVehicle == null) {
            int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
            this.listModelVehicle = new LMVehicle(Vehicule.loadList(cleAgence));
        }
        return this.listModelVehicle;
    }
}

