/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DriverActivitySelection
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private Conducteur selected = null;
    private JPanel jContentPane = null;
    private JLabel lblAgence = null;
    private JLabel lblNom = null;
    private JComboBox cbAgence = null;
    private JComboBox cbConducteur = null;
    private JPanel pnlBtn = null;
    private JButton btnAnnuler = null;
    private JButton btnEnregistrer = null;
    public int cleConducteurSelectionne = 0;
    public boolean enregistrer = false;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DriverActivitySelection.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.lblNom.setText(LanguageTranslator.getString("generics.driver"));
        this.lblAgence.setText(LanguageTranslator.getString("generics.agency"));
        this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
        this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
        this.setTitle(LanguageTranslator.getString("card.affect"));
    }

    public DriverActivitySelection(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DriverActivitySelection()#");
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        this.setSize(400, 150);
        this.setModal(true);
        this.setTitle(LanguageTranslator.getString("card.affect"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.updateDriver();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(0, 20, 0, 20);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(0, 20, 0, 20);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            this.lblNom = new JLabel();
            this.lblNom.setText(LanguageTranslator.getString("generics.driver"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.lblAgence = new JLabel();
            this.lblAgence.setText(LanguageTranslator.getString("generics.agency"));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.lblAgence, gridBagConstraints);
            this.jContentPane.add((Component)this.lblNom, gridBagConstraints1);
            this.jContentPane.add((Component)this.getCbAgence(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getCbConducteur(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    public Conducteur getSelected() {
        return this.selected;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.setModel(new ComboBoxModel(Agence.getList(), false, null));
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DriverActivitySelection.this.updateDriver();
                }
            });
        }
        return this.cbAgence;
    }

    private JComboBox getCbConducteur() {
        if (this.cbConducteur == null) {
            this.cbConducteur = new JComboBox();
            this.cbConducteur.setModel(new ComboBoxModel(null, false, null));
        }
        return this.cbConducteur;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnAnnuler(), gridBagConstraints5);
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints6);
        }
        return this.pnlBtn;
    }

    private JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton();
            this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverActivitySelection.this.enregistrer = false;
                    DriverActivitySelection.this.dispose();
                }
            });
        }
        return this.btnAnnuler;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DriverActivitySelection.this.getCbConducteur().getSelectedIndex() != -1) {
                        DriverActivitySelection.this.enregistrer = true;
                        DriverActivitySelection.this.cleConducteurSelectionne = ((ComboBoxModel)DriverActivitySelection.this.getCbConducteur().getModel()).getSelectedCle();
                        DriverActivitySelection.this.affecter();
                        DriverActivitySelection.this.dispose();
                    } else {
                        DriverActivitySelection.this.erreurSelection();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void affecter() {
        this.selected = new Conducteur(this.cleConducteurSelectionne);
    }

    public void erreurSelection() {
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("card.affect.error"), LanguageTranslator.getString("message.inputError"), 0);
    }

    private void updateDriver() {
        int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        ((ComboBoxModel)this.getCbConducteur().getModel()).updateList(Conducteur.loadList(cleAgence), false, null);
    }
}

