/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.VehicleUsed;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class GrapheUEV
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    String[] dateJour = new String[7];
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private int pasV;
    private int pasH;
    Vector<UevActivity>[] a = new Vector[7];
    Vector<VehicleUsed>[] i = new Vector[7];
    private static int pasIO = 17;
    private static int hauteurIO = 4;
    private boolean afficheI0 = true;

    public GrapheUEV() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        int hauteur;
        int fin;
        int debut;
        Vector<VehicleUsed> ioVector;
        boolean toolTipAdded = false;
        int mouseX = arg0.getX();
        int mouseY = arg0.getY();
        int width = this.pasV * 24;
        float echel = (float)width / 1440.0f;
        this.setToolTipText(null);
        Vector<UevActivity> activity = this.a == null || mouseY / this.pasH >= 7 ? null : this.a[mouseY / this.pasH];
        int jour = mouseY / this.pasH + 1;
        Vector<VehicleUsed> vector = ioVector = this.i == null || mouseY / this.pasH >= 7 ? null : this.i[mouseY / this.pasH];
        if (activity != null) {
            if (activity.size() == 0) {
                this.setToolTipText(null);
            } else {
                for (UevActivity elt1 : activity) {
                    debut = (int)((float)elt1.getHeureDebut() * echel);
                    fin = (int)((float)elt1.getHeureFin() * echel);
                    hauteur = this.hauteur(elt1.getCleType());
                    if (mouseX < debut || mouseX > fin || mouseY > this.getY(mouseY, 0) || mouseY < this.getY(mouseY, 0) - hauteur) continue;
                    this.setToolTipText(LanguageTranslator.getString("graphic.activity.toolTip", ConversionTime.heureIntToString(elt1.getHeureDebut(), "h"), ConversionTime.heureIntToString(elt1.getHeureFin(), "h"), ConversionTime.heureIntToString(elt1.getDuree(), "h"), elt1.getDescription()));
                    toolTipAdded = true;
                }
                if (!toolTipAdded) {
                    this.setToolTipText(null);
                }
            }
        }
        if (ioVector != null && ioVector.size() != 0 && !toolTipAdded) {
            for (VehicleUsed ins : ioVector) {
                debut = 0;
                fin = (int)(1440.0f * echel);
                if (ConversionTime.dateToStringFr(ins.getDateDebut()).equals(this.dateJour[jour - 1])) {
                    debut = (int)((float)ConversionTime.getMinut(ins.getDateDebut()) * echel);
                }
                if (ConversionTime.dateToStringFr(ins.getDateFin()).equals(this.dateJour[jour - 1])) {
                    fin = (int)((float)ConversionTime.getMinut(ins.getDateFin()) * echel);
                }
                hauteur = hauteurIO;
                if (mouseX < debut || mouseX > fin || mouseY > this.getY(mouseY, pasIO + ins.getLecteur() * 5) || mouseY < this.getY(mouseY, pasIO + ins.getLecteur() * 5) - hauteur) continue;
                this.setToolTipText("<html>Conducteur : " + ins.getNom() + " " + ins.getPrenom() + " <br >" + "Insertion : " + ConversionTime.dateToString(ins.getDateDebut(), "dd/MM/yyyy HH:mm") + "<br>" + "Retrait : " + ConversionTime.dateToString(ins.getDateFin(), "dd/MM/yyyy HH:mm") + "<br>" + "Km : " + ins.getKmEffectue() + "</html>");
                toolTipAdded = true;
            }
        }
    }

    public int getY(int Y, int decalage) {
        int coef = Y / this.pasH + 1;
        return coef * this.pasH - decalage;
    }

    public Vector<UevActivity> getActivityAt(int indexVector) {
        return this.a[indexVector];
    }

    public Vector<VehicleUsed> getIOAt(int indexVector) {
        return this.i[indexVector];
    }

    public void setAfficheInfraction(boolean affiche) {
        this.afficheI0 = affiche;
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.pasV = this.getWidth() / 24;
        this.pasH = (this.getHeight() - 15) / 7;
        g.setColor(Color.black);
        g.drawString("0", 0, 10);
        g.drawLine(0, 15, 0, 7 * this.pasH);
        int i = 1;
        while (i < 24) {
            g.drawString(String.valueOf(i), i * this.pasV - 4, 10);
            g.drawLine(i * this.pasV, 15, i * this.pasV, 7 * this.pasH);
            ++i;
        }
        g.drawString("24", 24 * this.pasV - 12, 10);
        g.drawLine(24 * this.pasV, 15, 24 * this.pasV, 7 * this.pasH);
        i = 1;
        while (i <= 7) {
            g.setColor(Color.BLACK);
            g.drawLine(0, i * this.pasH, 24 * this.pasV, i * this.pasH);
            ++i;
        }
        int x = 0;
        while (x < 7) {
            this.affichage(this.a == null ? null : this.a[x], this.i == null ? null : this.i[x], g, (x + 1) * this.pasH, x + 1);
            ++x;
        }
    }

    void affichage(Vector<UevActivity> data, Vector<VehicleUsed> io, Graphics g, int PosY, int jour) {
        int width = this.pasV * 24;
        float echel = (float)width / 1440.0f;
        if (data == null) {
            return;
        }
        if (data.size() != 0) {
            for (UevActivity elt1 : data) {
                g.setColor(new Color(Integer.parseInt(elt1.getCouleur())));
                int duree = elt1.getHeureFin() - elt1.getHeureDebut();
                if ((float)duree * echel == 0.0f) {
                    g.fillRect((int)((float)elt1.getHeureDebut() * echel), PosY - this.hauteur(elt1.getCleType()), 1, this.hauteur(elt1.getCleType()));
                    continue;
                }
                g.fillRect((int)((float)elt1.getHeureDebut() * echel), PosY - this.hauteur(elt1.getCleType()), (int)((float)duree * echel), this.hauteur(elt1.getCleType()));
            }
        }
        if (io != null && io.size() != 0 && this.afficheI0) {
            for (VehicleUsed inf : io) {
                g.setColor(Color.DARK_GRAY);
                if (inf.getLecteur() == 1) {
                    g.setColor(Color.GRAY);
                }
                boolean debutAvant = false;
                boolean finApres = false;
                int debut = 0;
                int fin = (int)(1440.0f * echel);
                if (ConversionTime.dateToStringFr(inf.getDateDebut()).equals(this.dateJour[jour - 1])) {
                    debut = (int)((float)ConversionTime.getMinut(inf.getDateDebut()) * echel);
                } else {
                    debutAvant = true;
                }
                if (ConversionTime.dateToStringFr(inf.getDateFin()).equals(this.dateJour[jour - 1])) {
                    fin = (int)((float)ConversionTime.getMinut(inf.getDateFin()) * echel);
                } else {
                    finApres = true;
                }
                int val1 = debut + 1;
                int val2 = fin - debut;
                int val3 = hauteurIO;
                int y = PosY - pasIO - hauteurIO - inf.getLecteur() * 5;
                g.fillRoundRect(val1, y, val2, val3, 3, 3);
                if (debutAvant) {
                    g.fillRect(0, y, 5, hauteurIO);
                }
                if (fin != 1440) continue;
                g.fillRect(1435, y, 5, hauteurIO);
            }
        }
    }

    int hauteur(int activite) {
        if (activite == 1) {
            return 15;
        }
        if (activite == 2) {
            return 10;
        }
        if (activite == 3) {
            return 5;
        }
        if (activite == 4) {
            return 3;
        }
        if (activite == 5) {
            return 5;
        }
        if (activite == 6) {
            return 10;
        }
        if (activite == 7) {
            return 3;
        }
        return 0;
    }

    public void initialiser(Vector<UevActivity>[] a, Vector<VehicleUsed>[] i, Date dateInitialiser) {
        this.a = a;
        this.i = i;
        GregorianCalendar calendrierGraphe = new GregorianCalendar();
        calendrierGraphe.setTime(dateInitialiser);
        int x = 0;
        while (x < 7) {
            this.dateJour[x] = this.dateFormat.format(calendrierGraphe.getTime());
            calendrierGraphe.add(5, 1);
            ++x;
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int mouseX = e.getX();
        int finalWidth = 0;
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            finalWidth = this.getWidth() * 2;
        } else if (e.getButton() == 3 && e.getClickCount() == 2) {
            finalWidth = this.getWidth() / 2;
        } else {
            return;
        }
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int notches = arg0.getWheelRotation();
        int ratio = -notches * 100;
        int finalWidth = this.getWidth() + ratio;
        int mouseX = arg0.getX();
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }
}

