/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.UevCalibration;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class PnlEtalonnage
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private Vehicule current = null;
    private int numeroEtalonnage = 0;
    private Vector<UevCalibration> listeEtalonnage = null;
    private JButton btnPrecedent = null;
    private JButton btnSuivant = null;
    private JLabel lblNumeroEtalonnage = null;
    private JPanel pnlEtalonnage = null;
    private JPanel pnlType = null;
    private JLabel lblType = null;
    private JTextField txtTypeEtalonnage = null;
    private JPanel pnlEtalonneur = null;
    private JLabel lblNom = null;
    private JTextField txtNom = null;
    private JLabel lblAdresse = null;
    private JTextField txtAdresse = null;
    private JPanel pnlCarte = null;
    private JPanel pnlVehicule = null;
    private JPanel pnlDetail = null;
    private JLabel lblIdentification = null;
    private JTextField txtIdentification = null;
    private JLabel lblEtat = null;
    private JTextField txtEtat = null;
    private JLabel lblTaillPneu = null;
    private JTextField txtPneu = null;
    private JLabel lblRegistration = null;
    private JTextField txtRegistration = null;
    private JLabel lblVitesse = null;
    private JTextField txtVitesse = null;
    private JLabel lblTypeCarte = null;
    private JTextField txtTypeCarte = null;
    private JLabel lblNumeroCarte = null;
    private JTextField txtNumeroCarte = null;
    private JLabel lblPaysCarte = null;
    private JTextField txtPaysCarte = null;
    private JLabel lblExpirationCarte = null;
    private JTextField txtExpirationCarte = null;
    private JPanel pnlNouveauAncien = null;
    private JTextField txtNouveauKM = null;
    private JLabel lblNouveauKM = null;
    private JTextField txtAncienKM = null;
    private JLabel lblAncienKM = null;
    private JLabel lblAncienneDate = null;
    private JTextField txtAncienneDate = null;
    private JLabel lblNouvelleDate = null;
    private JTextField txtNouvelleDate = null;
    private JPanel pnlProchain = null;
    private JLabel lblProchain = null;
    private JTextField txtProchain = null;

    public PnlEtalonnage() {
        this.initialize();
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.reload();
            this.load = true;
        }
    }

    public void setVehicle(Vehicule current) {
        this.current = current;
        this.load = false;
    }

    private void reload() {
        this.listeEtalonnage = Transport.bdd.getEtalonnage(this.current.getCleVehicule());
        if (this.listeEtalonnage.size() != 0) {
            this.numeroEtalonnage = 1;
            this.setEtalonnage(this.listeEtalonnage.get(this.numeroEtalonnage - 1));
        } else {
            this.numeroEtalonnage = 0;
            this.setEtalonnage(null);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.gridy = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(15, 0, 15, 0);
        gridBagConstraints2.gridy = 0;
        this.lblNumeroEtalonnage = new JLabel();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.insets = new Insets(15, 0, 15, 0);
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setLocation(new Point(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
        this.setSize(new Dimension(650, 500));
        this.add((Component)this.getBtnPrecedent(), gridBagConstraints);
        this.add((Component)this.getBtnSuivant(), gridBagConstraints1);
        this.add((Component)this.lblNumeroEtalonnage, gridBagConstraints2);
        this.add((Component)this.getPnlEtalonnage(), gridBagConstraints3);
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return null;
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("vehicle.calibration");
    }

    @Override
    public void refresh() {
    }

    private JButton getBtnPrecedent() {
        if (this.btnPrecedent == null) {
            this.btnPrecedent = new JButton();
            this.btnPrecedent.setText("<");
            this.btnPrecedent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlEtalonnage pnlEtalonnage = PnlEtalonnage.this;
                    pnlEtalonnage.numeroEtalonnage = pnlEtalonnage.numeroEtalonnage - 1;
                    PnlEtalonnage.this.setEtalonnage((UevCalibration)PnlEtalonnage.this.listeEtalonnage.get(PnlEtalonnage.this.numeroEtalonnage - 1));
                }
            });
        }
        return this.btnPrecedent;
    }

    private JButton getBtnSuivant() {
        if (this.btnSuivant == null) {
            this.btnSuivant = new JButton();
            this.btnSuivant.setText(">");
            this.btnSuivant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlEtalonnage pnlEtalonnage = PnlEtalonnage.this;
                    pnlEtalonnage.numeroEtalonnage = pnlEtalonnage.numeroEtalonnage + 1;
                    PnlEtalonnage.this.setEtalonnage((UevCalibration)PnlEtalonnage.this.listeEtalonnage.get(PnlEtalonnage.this.numeroEtalonnage - 1));
                }
            });
        }
        return this.btnSuivant;
    }

    private JPanel getPnlEtalonnage() {
        if (this.pnlEtalonnage == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.insets = new Insets(0, 10, 5, 10);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints4.gridy = 0;
            this.pnlEtalonnage = new JPanel();
            this.pnlEtalonnage.setLayout(new GridBagLayout());
            this.pnlEtalonnage.setPreferredSize(new Dimension(600, 400));
            this.pnlEtalonnage.add((Component)this.getPnlType(), gridBagConstraints4);
            this.pnlEtalonnage.add((Component)this.getPnlEtalonneur(), gridBagConstraints7);
        }
        return this.pnlEtalonnage;
    }

    private JPanel getPnlType() {
        if (this.pnlType == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            this.lblType = new JLabel();
            this.lblType.setText(LanguageTranslator.getString("vehicle.calibration.type"));
            this.pnlType = new JPanel();
            this.pnlType.setLayout(new GridBagLayout());
            this.pnlType.add((Component)this.lblType, gridBagConstraints5);
            this.pnlType.add((Component)this.getTxtTypeEtalonnage(), gridBagConstraints6);
        }
        return this.pnlType;
    }

    private JTextField getTxtTypeEtalonnage() {
        if (this.txtTypeEtalonnage == null) {
            this.txtTypeEtalonnage = new JTextField();
        }
        return this.txtTypeEtalonnage;
    }

    private JPanel getPnlEtalonneur() {
        if (this.pnlEtalonneur == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridwidth = 4;
            gridBagConstraints14.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints14.gridy = 3;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridwidth = 4;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints13.gridy = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridwidth = 4;
            gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints12.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridx = 3;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints10.gridy = 0;
            this.lblAdresse = new JLabel();
            this.lblAdresse.setText(LanguageTranslator.getString("generics.address"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints8.gridy = 0;
            this.lblNom = new JLabel();
            this.lblNom.setText(LanguageTranslator.getString("generics.name"));
            this.pnlEtalonneur = new JPanel();
            this.pnlEtalonneur.setLayout(new GridBagLayout());
            this.pnlEtalonneur.setPreferredSize(new Dimension(500, 350));
            this.pnlEtalonneur.add((Component)this.lblNom, gridBagConstraints8);
            this.pnlEtalonneur.add((Component)this.getTxtNom(), gridBagConstraints9);
            this.pnlEtalonneur.add((Component)this.lblAdresse, gridBagConstraints10);
            this.pnlEtalonneur.add((Component)this.getTxtAdresse(), gridBagConstraints11);
            this.pnlEtalonneur.add((Component)this.getPnlCarte(), gridBagConstraints12);
            this.pnlEtalonneur.add((Component)this.getPnlVehicule(), gridBagConstraints13);
            this.pnlEtalonneur.add((Component)this.getPnlDetail(), gridBagConstraints14);
        }
        return this.pnlEtalonneur;
    }

    private JTextField getTxtNom() {
        if (this.txtNom == null) {
            this.txtNom = new JTextField();
        }
        return this.txtNom;
    }

    private JTextField getTxtAdresse() {
        if (this.txtAdresse == null) {
            this.txtAdresse = new JTextField();
        }
        return this.txtAdresse;
    }

    private JPanel getPnlCarte() {
        if (this.pnlCarte == null) {
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 2;
            gridBagConstraints24.gridy = 2;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.gridx = 1;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.weightx = 0.2;
            gridBagConstraints23.gridy = 2;
            this.lblVitesse = new JLabel();
            this.lblVitesse.setText(LanguageTranslator.getString("vehicle.authorizedSpeed"));
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 2;
            gridBagConstraints22.gridy = 1;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.weightx = 0.2;
            gridBagConstraints21.gridy = 1;
            this.lblRegistration = new JLabel();
            this.lblRegistration.setText(LanguageTranslator.getString("vehicle.enreg."));
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridy = 1;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.gridx = 3;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 2;
            gridBagConstraints19.weightx = 0.2;
            gridBagConstraints19.gridy = 1;
            this.lblTaillPneu = new JLabel();
            this.lblTaillPneu.setText(LanguageTranslator.getString("vehicle.tyre"));
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 2;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.gridx = 3;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 2;
            gridBagConstraints17.weightx = 0.2;
            gridBagConstraints17.gridy = 0;
            this.lblEtat = new JLabel();
            this.lblEtat.setText(LanguageTranslator.getString("generics.country"));
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.weightx = 0.2;
            gridBagConstraints15.gridy = 0;
            this.lblIdentification = new JLabel();
            this.lblIdentification.setText(LanguageTranslator.getString("vehicle.identification"));
            this.pnlCarte = new JPanel();
            this.pnlCarte.setLayout(new GridBagLayout());
            this.pnlCarte.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("vehicle.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlCarte.add((Component)this.lblIdentification, gridBagConstraints15);
            this.pnlCarte.add((Component)this.getTxtIdentification(), gridBagConstraints16);
            this.pnlCarte.add((Component)this.lblEtat, gridBagConstraints17);
            this.pnlCarte.add((Component)this.getTxtEtat(), gridBagConstraints18);
            this.pnlCarte.add((Component)this.lblTaillPneu, gridBagConstraints19);
            this.pnlCarte.add((Component)this.getTxtPneu(), gridBagConstraints20);
            this.pnlCarte.add((Component)this.lblRegistration, gridBagConstraints21);
            this.pnlCarte.add((Component)this.getTxtRegistration(), gridBagConstraints22);
            this.pnlCarte.add((Component)this.lblVitesse, gridBagConstraints23);
            this.pnlCarte.add((Component)this.getTxtVitesse(), gridBagConstraints24);
        }
        return this.pnlCarte;
    }

    private JPanel getPnlVehicule() {
        if (this.pnlVehicule == null) {
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.fill = 2;
            gridBagConstraints32.gridy = 1;
            gridBagConstraints32.weightx = 1.0;
            gridBagConstraints32.gridx = 3;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 2;
            gridBagConstraints31.weightx = 0.2;
            gridBagConstraints31.gridy = 1;
            this.lblExpirationCarte = new JLabel();
            this.lblExpirationCarte.setText(LanguageTranslator.getString("generics.expiry"));
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.fill = 2;
            gridBagConstraints30.gridy = 1;
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.weighty = 0.0;
            gridBagConstraints30.gridx = 1;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.weightx = 0.2;
            gridBagConstraints29.gridy = 1;
            this.lblPaysCarte = new JLabel();
            this.lblPaysCarte.setText(LanguageTranslator.getString("generics.country"));
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.fill = 2;
            gridBagConstraints28.gridy = 0;
            gridBagConstraints28.weightx = 1.0;
            gridBagConstraints28.gridx = 3;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 2;
            gridBagConstraints27.weightx = 0.2;
            gridBagConstraints27.gridy = 0;
            this.lblNumeroCarte = new JLabel();
            this.lblNumeroCarte.setText(LanguageTranslator.getString("generics.cardNumber"));
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 2;
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.weighty = 0.0;
            gridBagConstraints26.gridx = 1;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.weightx = 0.2;
            gridBagConstraints25.gridy = 0;
            this.lblTypeCarte = new JLabel();
            this.lblTypeCarte.setText(LanguageTranslator.getString("card.type"));
            this.pnlVehicule = new JPanel();
            this.pnlVehicule.setLayout(new GridBagLayout());
            this.pnlVehicule.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("vehicle.card.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlVehicule.add((Component)this.lblTypeCarte, gridBagConstraints25);
            this.pnlVehicule.add((Component)this.getTxtTypeCarte(), gridBagConstraints26);
            this.pnlVehicule.add((Component)this.lblNumeroCarte, gridBagConstraints27);
            this.pnlVehicule.add((Component)this.getTxtNumeroCarte(), gridBagConstraints28);
            this.pnlVehicule.add((Component)this.lblPaysCarte, gridBagConstraints29);
            this.pnlVehicule.add((Component)this.getTxtPaysCarte(), gridBagConstraints30);
            this.pnlVehicule.add((Component)this.lblExpirationCarte, gridBagConstraints31);
            this.pnlVehicule.add((Component)this.getTxtExpirationCarte(), gridBagConstraints32);
        }
        return this.pnlVehicule;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.weighty = 1.0;
            gridBagConstraints42.weightx = 1.0;
            gridBagConstraints42.fill = 1;
            gridBagConstraints42.gridy = 1;
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.fill = 1;
            gridBagConstraints33.weightx = 1.0;
            gridBagConstraints33.weighty = 1.0;
            gridBagConstraints33.gridy = 0;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("vehicle.calibration.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlDetail.add((Component)this.getPnlNouveauAncien(), gridBagConstraints33);
            this.pnlDetail.add((Component)this.getPnlProchain(), gridBagConstraints42);
        }
        return this.pnlDetail;
    }

    private JTextField getTxtIdentification() {
        if (this.txtIdentification == null) {
            this.txtIdentification = new JTextField();
        }
        return this.txtIdentification;
    }

    private JTextField getTxtEtat() {
        if (this.txtEtat == null) {
            this.txtEtat = new JTextField();
        }
        return this.txtEtat;
    }

    private JTextField getTxtPneu() {
        if (this.txtPneu == null) {
            this.txtPneu = new JTextField();
        }
        return this.txtPneu;
    }

    private JTextField getTxtRegistration() {
        if (this.txtRegistration == null) {
            this.txtRegistration = new JTextField();
        }
        return this.txtRegistration;
    }

    private JTextField getTxtVitesse() {
        if (this.txtVitesse == null) {
            this.txtVitesse = new JTextField();
        }
        return this.txtVitesse;
    }

    private JTextField getTxtTypeCarte() {
        if (this.txtTypeCarte == null) {
            this.txtTypeCarte = new JTextField();
        }
        return this.txtTypeCarte;
    }

    private JTextField getTxtNumeroCarte() {
        if (this.txtNumeroCarte == null) {
            this.txtNumeroCarte = new JTextField();
        }
        return this.txtNumeroCarte;
    }

    private JTextField getTxtPaysCarte() {
        if (this.txtPaysCarte == null) {
            this.txtPaysCarte = new JTextField();
        }
        return this.txtPaysCarte;
    }

    private JTextField getTxtExpirationCarte() {
        if (this.txtExpirationCarte == null) {
            this.txtExpirationCarte = new JTextField();
        }
        return this.txtExpirationCarte;
    }

    private JPanel getPnlNouveauAncien() {
        if (this.pnlNouveauAncien == null) {
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.gridy = 1;
            gridBagConstraints41.weightx = 1.0;
            gridBagConstraints41.gridx = 3;
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.gridx = 2;
            gridBagConstraints40.gridy = 1;
            this.lblNouvelleDate = new JLabel();
            this.lblNouvelleDate.setText(LanguageTranslator.getString("vehicle.calibration.newDate"));
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.fill = 2;
            gridBagConstraints39.gridy = 1;
            gridBagConstraints39.weightx = 1.0;
            gridBagConstraints39.gridx = 1;
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.gridy = 1;
            this.lblAncienneDate = new JLabel();
            this.lblAncienneDate.setText(LanguageTranslator.getString("vehicle.calibration.oldDate"));
            GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
            gridBagConstraints38.gridx = 0;
            gridBagConstraints38.gridy = 0;
            this.lblAncienKM = new JLabel();
            this.lblAncienKM.setText(LanguageTranslator.getString("vehicle.calibration.oldKm"));
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.fill = 2;
            gridBagConstraints37.gridy = 0;
            gridBagConstraints37.weightx = 1.0;
            gridBagConstraints37.gridx = 1;
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 2;
            gridBagConstraints36.gridy = 0;
            this.lblNouveauKM = new JLabel();
            this.lblNouveauKM.setText(LanguageTranslator.getString("vehicle.calibration.newKm"));
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.fill = 1;
            gridBagConstraints34.weighty = 0.0;
            gridBagConstraints34.gridx = 3;
            gridBagConstraints34.weightx = 1.0;
            this.pnlNouveauAncien = new JPanel();
            this.pnlNouveauAncien.setLayout(new GridBagLayout());
            this.pnlNouveauAncien.add((Component)this.getTxtNouveauKM(), gridBagConstraints34);
            this.pnlNouveauAncien.add((Component)this.lblNouveauKM, gridBagConstraints36);
            this.pnlNouveauAncien.add((Component)this.getTxtAncienKM(), gridBagConstraints37);
            this.pnlNouveauAncien.add((Component)this.lblAncienKM, gridBagConstraints38);
            this.pnlNouveauAncien.add((Component)this.lblAncienneDate, gridBagConstraints35);
            this.pnlNouveauAncien.add((Component)this.getTxtAncienneDate(), gridBagConstraints39);
            this.pnlNouveauAncien.add((Component)this.lblNouvelleDate, gridBagConstraints40);
            this.pnlNouveauAncien.add((Component)this.getTxtNouvelleDate(), gridBagConstraints41);
        }
        return this.pnlNouveauAncien;
    }

    private JTextField getTxtNouveauKM() {
        if (this.txtNouveauKM == null) {
            this.txtNouveauKM = new JTextField();
        }
        return this.txtNouveauKM;
    }

    private JTextField getTxtAncienKM() {
        if (this.txtAncienKM == null) {
            this.txtAncienKM = new JTextField();
        }
        return this.txtAncienKM;
    }

    private JTextField getTxtAncienneDate() {
        if (this.txtAncienneDate == null) {
            this.txtAncienneDate = new JTextField();
        }
        return this.txtAncienneDate;
    }

    private JTextField getTxtNouvelleDate() {
        if (this.txtNouvelleDate == null) {
            this.txtNouvelleDate = new JTextField();
        }
        return this.txtNouvelleDate;
    }

    private JPanel getPnlProchain() {
        if (this.pnlProchain == null) {
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.fill = 2;
            gridBagConstraints44.gridy = 0;
            gridBagConstraints44.weightx = 1.0;
            gridBagConstraints44.weighty = 1.0;
            gridBagConstraints44.gridx = 1;
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
            gridBagConstraints43.gridx = 0;
            gridBagConstraints43.weighty = 0.0;
            gridBagConstraints43.weightx = 1.0;
            gridBagConstraints43.fill = 0;
            gridBagConstraints43.gridy = 0;
            this.lblProchain = new JLabel();
            this.lblProchain.setText(LanguageTranslator.getString("vehicle.calibration.nextCalibration"));
            this.pnlProchain = new JPanel();
            this.pnlProchain.setLayout(new GridBagLayout());
            this.pnlProchain.add((Component)this.lblProchain, gridBagConstraints43);
            this.pnlProchain.add((Component)this.getTxtProchain(), gridBagConstraints44);
        }
        return this.pnlProchain;
    }

    private JTextField getTxtProchain() {
        if (this.txtProchain == null) {
            this.txtProchain = new JTextField();
        }
        return this.txtProchain;
    }

    private void setEtalonnage(UevCalibration current) {
        if (this.numeroEtalonnage >= this.listeEtalonnage.size()) {
            this.getBtnSuivant().setEnabled(false);
        } else {
            this.getBtnSuivant().setEnabled(true);
        }
        if (this.numeroEtalonnage <= 1) {
            this.getBtnPrecedent().setEnabled(false);
        } else {
            this.getBtnPrecedent().setEnabled(true);
        }
        this.lblNumeroEtalonnage.setText(String.valueOf(this.numeroEtalonnage) + " " + LanguageTranslator.getString("generics.of") + " " + this.listeEtalonnage.size());
        if (this.numeroEtalonnage == this.listeEtalonnage.size()) {
            this.btnSuivant.setEnabled(false);
        }
        this.getTxtTypeEtalonnage().setText(current == null ? "" : UevCalibration.LIBELLE_TYPE[current.getTypeEtalonnage()]);
        this.getTxtNom().setText(current == null ? "" : current.getNom());
        this.getTxtAdresse().setText(current == null ? "" : current.getAdresse());
        this.getTxtIdentification().setText(current == null ? "" : current.getIdentificationVehicule());
        this.getTxtEtat().setText(current == null ? "" : String.valueOf(Pays.LIBELLE[current.getClePays()][1]) + " (" + current.getClePays() + ")");
        this.getTxtRegistration().setText(current == null ? "" : current.getEnregistrementVehicule());
        this.getTxtPneu().setText(current == null ? "" : current.getTyreSize());
        this.getTxtVitesse().setText(current == null ? "" : String.valueOf(current.getAuthorizedSpeed()));
        this.getTxtTypeCarte().setText(current == null ? "" : UevCalibration.LIBELLE_TYPE_EQUIPEMENT[current.getTypeCarte()]);
        this.getTxtNumeroCarte().setText(current == null ? "" : current.getNumeroCarte());
        this.getTxtPaysCarte().setText(current == null ? "" : String.valueOf(Pays.LIBELLE[current.getClePays()][1]) + " (" + current.getClePays() + ")");
        this.getTxtExpirationCarte().setText(current == null ? "" : current.getExpirationCarte());
        this.getTxtNouveauKM().setText(current == null ? "" : String.valueOf(current.getNouveauKM()));
        this.getTxtAncienKM().setText(current == null ? "" : String.valueOf(current.getAncienKM()));
        this.getTxtNouvelleDate().setText(current == null ? "" : ConversionTime.dateFromBDDToFrance(current.getNouvelleDate(), false, false));
        this.getTxtAncienneDate().setText(current == null ? "" : ConversionTime.dateFromBDDToFrance(current.getAncienneDate(), false, false));
        this.getTxtProchain().setText(current == null ? "" : ConversionTime.dateFromBDDToFrance(current.getProchainEtalonnage(), false, false));
    }
}

