/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMEventsFaultsUev;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlEventsFaultsUev
extends ViewPanel {
    ArrayList<UevEventsFaults> data = null;
    TMEventsFaultsUev model = null;
    Vehicule vehicle = null;
    private JTable tbl = null;
    private JScrollPane jspTbl = null;
    private JPanel pnlFilter = null;
    private JTextField txtBegin = null;
    private JTextField txtEnd = null;
    private JComboBox cbPurpose = null;
    private JComboBox cbDetail = null;
    private JComboBox cbDriverCardBegin = null;
    private JComboBox cbDriverCardEnd = null;
    private JComboBox cbCodriverCardBegin = null;
    private JComboBox cbCodriverCardEnd = null;
    private JComboBox cbDriver = null;

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("vehicle.eventsFaults");
    }

    @Override
    public void refresh() {
        this.loadTbl();
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    public PnlEventsFaultsUev() {
        this.initialize();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(400, 300));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJspTbl(), gridBagConstraints);
        this.add((Component)this.getPnlFilter(), gridBagConstraints1);
    }

    public JScrollPane getJspTbl() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
            this.jspTbl.setViewportView(this.getTbl());
        }
        return this.jspTbl;
    }

    public JTable getTbl() {
        if (this.tbl == null) {
            this.tbl = new JTable();
            this.tbl.setSelectionMode(0);
            this.tbl.setRowHeight(21);
            this.tbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (PnlEventsFaultsUev.this.model != null && PnlEventsFaultsUev.this.tbl.getSelectedColumn() < 4) {
                        String selectedDate = PnlEventsFaultsUev.this.model.getValueAt(PnlEventsFaultsUev.this.tbl.getSelectedRow(), 0).toString();
                        MainFrameTransport.getInstance().setActiviteVehicule(selectedDate);
                    }
                }
            });
        }
        return this.tbl;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.loadTbl();
            this.load = true;
        }
    }

    public void setVehicle(Vehicule current) {
        this.vehicle = current;
        this.load = false;
    }

    public void loadTbl() {
        if (this.vehicle == null) {
            return;
        }
        String begin = this.getTxtBegin().getText().equals("") ? "" : ConversionTime.dateFromFranceToBDD(this.getTxtBegin().getText(), false);
        String end = this.getTxtEnd().getText().equals("") ? "" : ConversionTime.dateFromFranceToBDD(this.getTxtEnd().getText(), false);
        this.data = UevEventsFaults.load(this.vehicle.getCleVehicule(), begin, end);
        this.model = new TMEventsFaultsUev(this.data);
        this.getTbl().setModel(this.model);
        this.cbModificationEditor(this.tbl.getColumnModel().getColumn(5));
    }

    private void cbModificationEditor(TableColumn col) {
        col.setCellEditor(new DefaultCellEditor(this.getCbDriver()){

            @Override
            public Object getCellEditorValue() {
                ComboBoxModel cbModel = (ComboBoxModel)((JComboBox)this.editorComponent).getModel();
                return cbModel.getObjectAt(PnlEventsFaultsUev.this.getCbDriver().getSelectedIndex());
            }
        });
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Selection");
        col.setCellRenderer(renderer);
    }

    private JComboBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = Fonctions.getCustomizedCB();
            this.cbDriver.setModel(new ComboBoxModel(Conducteur.getList(), true, LanguageTranslator.getString("generics.none")));
        }
        return this.cbDriver;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints9.gridx = 7;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints8.gridx = 6;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints7.gridx = 5;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints6.gridx = 4;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints5.gridx = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints4.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints2.gridx = 0;
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)this.getTxtBegin(), gridBagConstraints2);
            this.pnlFilter.add((Component)this.getTxtEnd(), gridBagConstraints3);
            this.pnlFilter.add((Component)this.getCbPurpose(), gridBagConstraints4);
            this.pnlFilter.add((Component)this.getCbDetail(), gridBagConstraints5);
            this.pnlFilter.add((Component)this.getCbDriverCardBegin(), gridBagConstraints6);
            this.pnlFilter.add((Component)this.getCbDriverCardEnd(), gridBagConstraints7);
            this.pnlFilter.add((Component)this.getCbCodriverCardBegin(), gridBagConstraints8);
            this.pnlFilter.add((Component)this.getCbCodriverCardEnd(), gridBagConstraints9);
        }
        return this.pnlFilter;
    }

    private JTextField getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextField();
            this.txtBegin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlEventsFaultsUev.this.getTxtBegin())) {
                        PnlEventsFaultsUev.this.refresh();
                    }
                }
            });
        }
        return this.txtBegin;
    }

    private JTextField getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextField();
            this.txtEnd.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlEventsFaultsUev.this.getTxtEnd())) {
                        PnlEventsFaultsUev.this.refresh();
                    }
                }
            });
        }
        return this.txtEnd;
    }

    private JComboBox getCbPurpose() {
        if (this.cbPurpose == null) {
            this.cbPurpose = new JComboBox();
        }
        return this.cbPurpose;
    }

    private JComboBox getCbDetail() {
        if (this.cbDetail == null) {
            this.cbDetail = new JComboBox();
        }
        return this.cbDetail;
    }

    private JComboBox getCbDriverCardBegin() {
        if (this.cbDriverCardBegin == null) {
            this.cbDriverCardBegin = new JComboBox();
        }
        return this.cbDriverCardBegin;
    }

    private JComboBox getCbDriverCardEnd() {
        if (this.cbDriverCardEnd == null) {
            this.cbDriverCardEnd = new JComboBox();
        }
        return this.cbDriverCardEnd;
    }

    private JComboBox getCbCodriverCardBegin() {
        if (this.cbCodriverCardBegin == null) {
            this.cbCodriverCardBegin = new JComboBox();
        }
        return this.cbCodriverCardBegin;
    }

    private JComboBox getCbCodriverCardEnd() {
        if (this.cbCodriverCardEnd == null) {
            this.cbCodriverCardEnd = new JComboBox();
        }
        return this.cbCodriverCardEnd;
    }
}

