/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.widget;

import fr.pgh.component.JPanelButton;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogTelechargementDonneesConducteur;
import transpo.system.ui.views.widget.TimsWidget;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;

public class DriverDownloadWidget
extends TimsWidget
implements DataListener {
    private static final long serialVersionUID = -4875064886154105474L;
    private static String STRING_NO_DL = "1970-01-01 00:00:00.0";
    private JScrollPane jspOrange = null;
    private JScrollPane jspRed = null;
    private JList<String> listOrange = null;
    private JList<String> listRed = null;
    private JButton btnDriverDl = null;
    private JButton btnPrint = null;
    private JPanelButton pnlBtn = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        TimsLogger.debug("DriverDownloadWidget # reload from " + dataEvent.getTable());
        dataEvent.getTable().equals("t_conducteur");
    }

    @Override
    public TimsWidget build() {
        this.initialize();
        BddTransport.getInstance().addDataListener(this);
        this.load();
        return this;
    }

    @Override
    public void print() {
        ArrayList drivers = new ArrayList();
        Vector<Conducteur> list = new Vector<Conducteur>();
        list.addAll(((LMDriver)this.getListOrange().getModel()).getDrivers());
        list.addAll(((LMDriver)this.getListRed().getModel()).getDrivers());
        for (Conducteur driver : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            Agence agency = Agence.find(null, driver.getCleAgence());
            map.put(LanguageTranslator.getString("generics.agency"), agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription());
            map.put(LanguageTranslator.getString("user.firstName"), driver.getPrenom());
            map.put(LanguageTranslator.getString("user.lastName"), driver.getNom());
            map.put(LanguageTranslator.getString("user.registration"), driver.getMatricule());
            map.put(LanguageTranslator.getString("generics.cardNumber"), driver.getNumeroCarte());
            map.put(LanguageTranslator.getString("generics.last.download"), ConversionTime.dateFromBDDToFrance(driver.getDernierChangement(), false, false));
            drivers.add(map);
        }
        Fonctions.tblToReport(CustomReportFactory.getDriversDownloadReport(), null, drivers, "\u00e9cran");
    }

    private void initialize() {
        this.setBorder(this.getBorder("dashboard.driverDownload"));
        this.setLayout(new GridBagLayout());
        JLabel lblOrange = new JLabel(LanguageTranslator.getString("dashboard.driverAlert1", System.getProperty("driver.orange.threshold", String.valueOf(15))));
        JLabel lblRed = new JLabel(LanguageTranslator.getString("dashboard.driverAlert2", System.getProperty("driver.red.threshold", String.valueOf(25))));
        lblOrange.setHorizontalAlignment(0);
        lblRed.setHorizontalAlignment(0);
        this.add((Component)lblOrange, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, null));
        this.add((Component)this.getJspOrange(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, null));
        this.add((Component)lblRed, Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, -1, null));
        this.add((Component)this.getJspRed(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 1, -1, null));
        this.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 2, -1, null));
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnDriverDl(), this.getBtnPrint());
        }
        return this.pnlBtn;
    }

    private JScrollPane getJspOrange() {
        if (this.jspOrange == null) {
            this.jspOrange = new JScrollPane();
            this.jspOrange.setPreferredSize(new Dimension(0, 0));
            this.jspOrange.setViewportView(this.getListOrange());
        }
        return this.jspOrange;
    }

    private JScrollPane getJspRed() {
        if (this.jspRed == null) {
            this.jspRed = new JScrollPane();
            this.jspRed.setPreferredSize(new Dimension(0, 0));
            this.jspRed.setViewportView(this.getListRed());
        }
        return this.jspRed;
    }

    private JList<String> getListOrange() {
        if (this.listOrange == null) {
            this.listOrange = new JList();
            this.listOrange.setMaximumSize(new Dimension(50, 50));
            this.listOrange.setAutoscrolls(true);
            this.listOrange.setEnabled(false);
        }
        return this.listOrange;
    }

    private JList<String> getListRed() {
        if (this.listRed == null) {
            this.listRed = new JList();
            this.listRed.setAutoscrolls(true);
            this.listRed.setEnabled(false);
        }
        return this.listRed;
    }

    private JButton getBtnDriverDl() {
        if (this.btnDriverDl == null) {
            this.btnDriverDl = new JButton();
            this.btnDriverDl.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe"))));
            this.btnDriverDl.setPreferredSize(new Dimension(35, 35));
            this.btnDriverDl.setToolTipText(LanguageTranslator.getString("dashboard.driverDownloadMonitoring"));
            this.btnDriverDl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new DialogTelechargementDonneesConducteur(MainFrameTransport.getInstance()).setVisible(true);
                }
            });
        }
        return this.btnDriverDl;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton();
            this.btnPrint.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_print"))));
            this.btnPrint.setPreferredSize(new Dimension(35, 35));
            this.btnPrint.setToolTipText(LanguageTranslator.getString("button.driver.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverDownloadWidget.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    @Override
    public void load() {
        this.getListRed().setModel(new LMDriver(Transport.bdd.getConducteurRougeList()));
        this.getListOrange().setModel(new LMDriver(Transport.bdd.getConducteurOrangeList()));
    }

    class LMDriver
    extends AbstractListModel<String> {
        private static final long serialVersionUID = 1L;
        private Vector<Conducteur> list = null;

        public LMDriver(Vector<Conducteur> list) {
            this.list = list;
        }

        @Override
        public String getElementAt(int index) {
            String time = "";
            Conducteur driver = this.list.get(index);
            time = driver.getDernierChangement().equals(STRING_NO_DL) ? "aucun" : ConversionTime.dateFromBDDToFrance(driver.getDernierChangement(), false, false);
            return String.valueOf(driver.getNom()) + "  " + driver.getPrenom() + " (" + time + ")";
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public Vector<Conducteur> getDrivers() {
            return this.list;
        }
    }
}

