/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.widget;

import fr.pgh.component.JPanelButton;
import fr.pgh.component.TableSorter;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.TMWidgetDriverExpiration;
import transpo.system.ui.renderer.WidgetDriverExpirationRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.widget.TimsWidget;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGeneratorWithDateStyle;

public class DriverExpirationWidget
extends TimsWidget
implements DataListener {
    private static final long serialVersionUID = -4875064886154105474L;
    private static String STRING_NO_DL = "1970-01-01 00:00:00.0";
    private JScrollPane jspDriver = null;
    private JTable tblDriver = null;
    private JButton btnPrint = null;
    private JButton btnExport = null;
    private JPanelButton pnlBtn = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        TimsLogger.debug("DriverValidityStateWidget # reload from " + dataEvent.getTable());
        dataEvent.getTable().equals("t_conducteur");
    }

    @Override
    public TimsWidget build() {
        this.initialize();
        BddTransport.getInstance().addDataListener(this);
        this.load();
        return this;
    }

    @Override
    public void print() {
        this.export("\u00e9cran");
    }

    private void export(String out) {
        Vector<Color> conditionalColors = new Vector<Color>();
        Vector<Integer> conditionalThresholds = new Vector<Integer>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalThresholds.add(-100000);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("driver_error", "10")));
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("driver_warning", "60")));
        conditionalThresholds.add(-100000);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.driverState"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultDriverExpirationStateColumn(true, true, true, true, true, true);
        cr.setColumn(columns);
        Fonctions.tblToReport(cr, new DJGeneratorWithDateStyle(conditionalColors, conditionalThresholds), ((TableSorter)this.getTblDriver().getModel()).getData(), out);
    }

    private void initialize() {
        this.setBorder(this.getBorder("dashboard.driverExpiration"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJspDriver(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
        this.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, -1, null));
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnExport(), this.getBtnPrint());
        }
        return this.pnlBtn;
    }

    private JScrollPane getJspDriver() {
        if (this.jspDriver == null) {
            this.jspDriver = new JScrollPane();
            this.jspDriver.setViewportView(this.getTblDriver());
        }
        return this.jspDriver;
    }

    private JTable getTblDriver() {
        if (this.tblDriver == null) {
            this.tblDriver = new JTable();
        }
        return this.tblDriver;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_xls"))));
            this.btnExport.setPreferredSize(new Dimension(35, 35));
            this.btnExport.setToolTipText(LanguageTranslator.getString("button.driver.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverExpirationWidget.this.export("xls");
                }
            });
        }
        return this.btnExport;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton();
            this.btnPrint.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_print"))));
            this.btnPrint.setPreferredSize(new Dimension(35, 35));
            this.btnPrint.setToolTipText(LanguageTranslator.getString("button.driver.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverExpirationWidget.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    @Override
    public void load() {
        Vector<Conducteur> toSort = Conducteur.loadList(new Integer[0]);
        Vector finalList = (Vector)toSort.clone();
        for (Conducteur tmp : toSort) {
            Date caces;
            Date adr;
            Date vmDl;
            Date cardExpiration;
            Date fimo = ConversionTime.addDay(ConversionTime.stringToDate2(tmp.getFimoFco(), "yyyy-MM-dd"), Integer.parseInt(System.getProperty("fco_expiration", "1826")));
            if (fimo != null && ConversionTime.getDaysBetween(fimo, new Date()) > -20 && ConversionTime.getDaysBetween(fimo, new Date()) < 30 || (cardExpiration = ConversionTime.stringToDate2(tmp.getDateFinValiditeCarte(), "yyyy-MM-dd")) != null && ConversionTime.getDaysBetween(cardExpiration, new Date()) > -20 && ConversionTime.getDaysBetween(cardExpiration, new Date()) < 30) continue;
            Date vm = ConversionTime.addDay(ConversionTime.stringToDate2(tmp.getDateVisite(), "yyyy-MM-dd"), tmp.isNightWorker() ? Integer.parseInt(System.getProperty("medical_visit_night_expiration", "200")) : Integer.parseInt(System.getProperty("medical_visit_expiration", "1826")));
            if (!(vm != null && ConversionTime.getDaysBetween(vm, new Date()) > -20 && ConversionTime.getDaysBetween(vm, new Date()) < 30 || (vmDl = ConversionTime.addDay(ConversionTime.stringToDate2(tmp.getDateVisitePermis(), "yyyy-MM-dd"), Integer.parseInt(System.getProperty("medical_visit_driving_expiration", "1826")))) != null && ConversionTime.getDaysBetween(vmDl, new Date()) > -20 && ConversionTime.getDaysBetween(vmDl, new Date()) < 30 || (adr = ConversionTime.addDay(ConversionTime.stringToDate2(tmp.getAdr(), "yyyy-MM-dd"), Integer.parseInt(System.getProperty("adr_expiration", "1826")))) != null && ConversionTime.getDaysBetween(adr, new Date()) > -20 && ConversionTime.getDaysBetween(adr, new Date()) < 30 || (caces = ConversionTime.addDay(ConversionTime.stringToDate2(tmp.getCaces(), "yyyy-MM-dd"), Integer.parseInt(System.getProperty("caces_expiration", "1826")))) == null || ConversionTime.getDaysBetween(caces, new Date()) <= -20) && ConversionTime.getDaysBetween(caces, new Date()) >= 30) continue;
        }
        TableSorter sorter = new TableSorter(new TMWidgetDriverExpiration(finalList));
        this.getTblDriver().setModel(sorter);
        sorter.setTableHeader(this.getTblDriver().getTableHeader());
        WidgetDriverExpirationRenderer.initialize(this.getTblDriver());
    }
}

