/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.widget;

import fr.pgh.component.JPanelButton;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.widget.TimsWidget;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;
import transpo.system.util.HourCalculator;
import transport.report.MasterReport;

public class DriverHourWidget
extends TimsWidget
implements DataListener {
    private static final String HN_SERIES = "Heure normale";
    private static final String HNG_SERIES = "Heure normale (garantie)";
    private static final String H25_SERIES = "HS 25%";
    private static final String H25G_SERIES = "HS 25% (garantie)";
    private static final String H50_SERIES = "HS 50%";
    private static final String H50G_SERIES = "HS 50% (garantie)";
    private static final int HN_SERIES_INDEX = 0;
    private static final int HNG_SERIES_INDEX = 1;
    private static final int H25_SERIES_INDEX = 2;
    private static final int H25G_SERIES_INDEX = 3;
    private static final int H50_SERIES_INDEX = 4;
    private static final int H50G_SERIES_INDEX = 5;
    private static final Color HN_COLOR = new Color(0, 153, 0);
    private static final Color HNG_COLOR = new Color(210, 255, 205);
    private static final Color H25_COLOR = new Color(245, 180, 51);
    private static final Color H25G_COLOR = new Color(255, 222, 155);
    private static final Color H50_COLOR = new Color(180, 0, 0);
    private static final Color H50G_COLOR = new Color(241, 188, 177);
    private JButton btnPrint = null;
    private JPanelButton pnlBtn = null;
    private CategoryPlot plot;
    int HNC = 0;
    int HM125C = 0;
    int HS125C = 0;
    int HS150C = 0;
    int HNHC = 0;
    int HM125HC = 0;
    int HS125HC = 0;
    int HS150HC = 0;
    int hnG = 0;
    int he125G = 0;
    int hs125G = 0;
    int hs150G = 0;
    int hnC = 0;
    int he125C = 0;
    int hs125C = 0;
    int hs150C = 0;
    private JScrollPane jsp = null;

    @Override
    public void changeUpdate(DataEvent e) {
        if (e.getTable().equals("t_conducteur") && e.getAction() == Constants.ACTION_TYPE.CREATE) {
            e.getAction();
        }
    }

    @Override
    public TimsWidget build() {
        this.initialize();
        BddTransport.getInstance().addDataListener(this);
        this.load();
        return this;
    }

    private void initialize() {
        this.setBorder(this.getBorder("dashboard.driverHour"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJsp(), Fonctions.getGridBagConstraints(0, 0));
        this.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, -1, null));
    }

    private JScrollPane getJsp() {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
        }
        return this.jsp;
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnPrint());
        }
        return this.pnlBtn;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton();
            this.btnPrint.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_print"))));
            this.btnPrint.setPreferredSize(new Dimension(35, 35));
            this.btnPrint.setToolTipText(LanguageTranslator.getString("button.driver.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverHourWidget.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    @Override
    public void load() {
        TimsLogger.debug("#DriverHourWidget.load# load widget data");
        HashMap<Conducteur, ArrayList<Integer>> data = this.loadData();
        CategoryDataset dataset = this.createDataset(data);
        JFreeChart chart = this.createChart(dataset);
        chart.setPadding(new RectangleInsets(2.0, 0.0, 2.0, 0.0));
        ChartPanel chartPanel = new ChartPanel(chart);
        TimsLogger.debug("#DriverHourWidget.load#" + data.size());
        chartPanel.setMaximumDrawHeight(Math.max(480, data.size() * 40));
        chartPanel.setMinimumDrawHeight(data.size() * 25);
        chartPanel.setPreferredSize(new Dimension(200, data.size() * 25));
        this.getJsp().setViewportView((Component)chartPanel);
    }

    @Override
    public void print() {
        Date firstDay = ConversionTime.getFirstDayOfMonth(null);
        Date lastDay = ConversionTime.getLastDayOfMonth(null);
        Report offenceReport = new Report();
        offenceReport.loadByTranslationId("sh");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (System.getProperty("URL") != null) {
                params.put("SERVEUR", System.getProperty("HOME_PATH"));
            } else {
                params.put("SERVEUR", "");
            }
            params.put("DATE_DEBUT", ConversionTime.dateToString(firstDay, "dd/MM/yyyy"));
            params.put("DATE_FIN", ConversionTime.dateToString(lastDay, "dd/MM/yyyy"));
            params.put("NOM_SOC", null);
            params.put("BEGIN", firstDay);
            params.put("END", lastDay);
            params.put("RESOLUTION", 1);
            params.put("DETAIL", true);
            params.put("BRUTE", "1");
            params.put("OUT", "imprimer");
            MasterReport mr = null;
            if (!offenceReport.getClassToLoad().equals("NONE")) {
                Class<?> c = Class.forName(offenceReport.getClassToLoad());
                mr = (MasterReport)c.newInstance();
            } else {
                mr = new MasterReport();
            }
            mr.setValues(null, offenceReport, Agence.loadList(null, 0), Conducteur.loadList(new Integer[0]), null, params);
            mr.process();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            TimsLogger.warn("#ARUevOffence.printTbl()# error during report process");
            ex.printStackTrace();
        }
    }

    private HashMap<Conducteur, ArrayList<Integer>> loadData() {
        Date begin = ConversionTime.dateTruncate(ConversionTime.getFirstDayOfPreviousMonth(new Date()));
        Date end = ConversionTime.dateTruncate(ConversionTime.getLastDayOfPreviousMonth(new Date()));
        HourCalculator hours = new HourCalculator(begin, end);
        return hours.getData();
    }

    private CategoryDataset createDataset(HashMap<Conducteur, ArrayList<Integer>> data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        Set<Conducteur> d = data.keySet();
        for (Conducteur key : d) {
            ArrayList<Integer> values = data.get(key);
            String driver = String.valueOf(key.getNom()) + " - " + key.getPrenom();
            if (values.get(0) == 0) {
                TimsLogger.debug("#DHW.createDataset# No data for " + driver);
                continue;
            }
            TimsLogger.debug("#DHW.createDataset# add data for " + driver);
            result.addValue((double)((float)values.get(0).intValue() / 60.0f), (Comparable)((Object)HN_SERIES), (Comparable)((Object)driver));
            result.addValue((double)((float)values.get(1).intValue() / 60.0f), (Comparable)((Object)HNG_SERIES), (Comparable)((Object)driver));
            result.addValue((double)((float)values.get(2).intValue() / 60.0f), (Comparable)((Object)H25_SERIES), (Comparable)((Object)driver));
            result.addValue((double)((float)values.get(3).intValue() / 60.0f), (Comparable)((Object)H25G_SERIES), (Comparable)((Object)driver));
            result.addValue((double)((float)values.get(4).intValue() / 60.0f), (Comparable)((Object)H50_SERIES), (Comparable)((Object)driver));
            result.addValue((double)((float)values.get(5).intValue() / 60.0f), (Comparable)((Object)H50G_SERIES), (Comparable)((Object)driver));
            TimsLogger.debug(String.valueOf(key.getNom()) + " => " + data.get(key));
        }
        return result;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        this.plot = new CategoryPlot();
        this.plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        this.plot.setOrientation(PlotOrientation.HORIZONTAL);
        StackedBarRenderer rend = new StackedBarRenderer();
        rend.setSeriesPaint(0, (Paint)HN_COLOR);
        rend.setSeriesPaint(1, (Paint)HNG_COLOR);
        rend.setSeriesPaint(2, (Paint)H25_COLOR);
        rend.setSeriesPaint(3, (Paint)H25G_COLOR);
        rend.setSeriesPaint(4, (Paint)H50_COLOR);
        rend.setSeriesPaint(5, (Paint)H50G_COLOR);
        NumberFormat nf = NumberFormat.getInstance(Locale.FRENCH);
        nf.setMaximumFractionDigits(2);
        rend.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", nf));
        rend.setBaseItemLabelsVisible(true);
        rend.setBaseItemLabelFont(new Font("Arial", 1, 10));
        CategoryAxis catAxis = new CategoryAxis();
        catAxis.setUpperMargin(0.01);
        catAxis.setLowerMargin(0.01);
        catAxis.setCategoryMargin(0.3);
        NumberAxis na = new NumberAxis();
        na.setRange(0.0, 250.0);
        this.plot.setDataset(dataset);
        this.plot.setDomainAxis(catAxis);
        this.plot.setRangeAxis((ValueAxis)na);
        this.plot.setRenderer((CategoryItemRenderer)rend);
        this.plot.getDomainAxis().setTickMarksVisible(true);
        JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        BarRenderer br = (BarRenderer)categoryPlot.getRenderer();
        br.setMaximumBarWidth(0.15);
        return chart;
    }
}

