/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;

public class CopyOfCopyFileServeur2
extends Thread {
    private static CopyOfCopyFileServeur2 instance = null;
    private JDialog dialog = null;
    private JLabel name = null;
    private JLabel status = null;
    private Vector<FileToTransfer> waitingFiles = new Vector();

    public static CopyOfCopyFileServeur2 getInstance() {
        if (instance == null) {
            instance = new CopyOfCopyFileServeur2();
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        TimsLogger.verbose("#run : " + SwingUtilities.isEventDispatchThread());
        this.getDialog().setVisible(false);
    }

    private JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(MainFrameTransport.getInstance());
            this.dialog.setUndecorated(true);
            this.dialog.setPreferredSize(new Dimension(100, 25));
            this.dialog.setLocation(0, 0);
            this.dialog.getContentPane().add(this.getLblStatus());
            this.dialog.getContentPane().add(this.getLblName());
            this.dialog.setVisible(false);
        }
        return this.dialog;
    }

    private JLabel getLblName() {
        if (this.name == null) {
            this.name = new JLabel("...");
            this.name.setPreferredSize(new Dimension(75, 25));
        }
        return this.name;
    }

    private JLabel getLblStatus() {
        if (this.status == null) {
            this.status = new JLabel("W");
            this.status.setPreferredSize(new Dimension(25, 25));
        }
        return this.status;
    }

    public void setPercent(int percentage) {
    }

    public void add(File file, String uploadURL, boolean delete) {
        this.add(new FileToTransfer(file, uploadURL, delete));
    }

    public void add(FileToTransfer file) {
        boolean shouldWakeUp = false;
        if (this.waitingFiles.size() == 0) {
            shouldWakeUp = true;
        }
        this.waitingFiles.add(file);
        if (shouldWakeUp) {
            this.wakeUp();
        }
    }

    private void wakeUp() {
        TimsLogger.verbose("#wakeUp : " + SwingUtilities.isEventDispatchThread());
        this.restart();
    }

    public void restart() {
        this.getDialog().setVisible(true);
        while (this.waitingFiles.size() != 0) {
            FileToTransfer toTransfer = this.waitingFiles.get(0);
            this.getLblStatus().setText("T");
            this.getLblName().setText(toTransfer.getFile().getName());
            if (!this.fileTransfer(toTransfer)) continue;
            try {
                this.getLblStatus().setText("O");
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.waitingFiles.remove(0);
            this.getLblStatus().setText("W");
            this.getLblName().setText("...");
        }
        this.getDialog().setVisible(false);
    }

    private boolean fileTransfer(FileToTransfer toTransfer) {
        block5: {
            TimsLogger.debug("Transferring " + toTransfer.getFile().getName());
            long start = Transport.ps.startAbsoluteTime();
            try {
                String line;
                StringBuffer random = this.getRandomString();
                URL u = new URL(toTransfer.getUploadURL());
                URLConnection c = u.openConnection();
                c.setDoOutput(true);
                c.setDoInput(true);
                c.setUseCaches(false);
                c.setRequestProperty("Connection", "Keep-Alive");
                c.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + random);
                DataOutputStream toServer = new DataOutputStream(c.getOutputStream());
                toServer.writeBytes("--" + random + "\r\n");
                toServer.writeBytes(this.getHead(toTransfer.getFile().getName()));
                this.uploadFileStream(toTransfer.getFile(), toServer);
                toServer.writeBytes("\r\n--" + random + "--\r\n\r\n");
                toServer.flush();
                toServer.close();
                TimsLogger.verbose("6Transferring " + toTransfer.getFile().getName());
                BufferedReader fromServer = new BufferedReader(new InputStreamReader(c.getInputStream()));
                TimsLogger.verbose("7Transferring " + toTransfer.getFile().getName());
                String lastLine = "";
                while ((line = fromServer.readLine()) != null) {
                    lastLine = line;
                    TimsLogger.verbose(String.valueOf(line) + "\n");
                }
                if (!lastLine.startsWith("ok")) break block5;
                TimsLogger.info("Le script PHP \u00e0 l'adresse " + toTransfer.getUploadURL() + " s'est execut\u00e9 avec succ\u00e8s");
                if (toTransfer.isDelete()) {
                    TimsLogger.debug("On supprime le fichier " + toTransfer.getFile().getAbsolutePath());
                    toTransfer.getFile().delete();
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                Transport.ps.endAbsoluteTime(PerformanceScanner.PROCESS, "download done", start);
                return false;
            }
        }
        TimsLogger.warn("Le script PHP \u00e0 l'adresse " + toTransfer.getUploadURL() + " a \u00e9chou\u00e9");
        return false;
    }

    private StringBuffer getRandomString() {
        StringBuffer sbRan = new StringBuffer(11);
        StringBuffer alphaNum = new StringBuffer();
        alphaNum.append("1234567890abcdefghijklmnopqrstuvwxyz");
        int i = 0;
        while (i < 11) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.charAt(num));
            ++i;
        }
        return sbRan;
    }

    private void uploadFileStream(File f, DataOutputStream dOut) throws FileNotFoundException, IOException {
        byte[] byteBuff = null;
        FileInputStream fis = null;
        try {
            int numBytes = 0;
            int uploadedLength = 0;
            long fileLength = f.length();
            byteBuff = new byte[1024];
            fis = new FileInputStream(f);
            while (-1 != (numBytes = fis.read(byteBuff))) {
                dOut.write(byteBuff, 0, numBytes);
                TimsLogger.verbose(String.valueOf(uploadedLength += numBytes) + " " + fileLength);
                this.setPercent((int)((long)uploadedLength / fileLength));
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {
                TimsLogger.warn(e.getMessage());
            }
            byteBuff = null;
        }
    }

    private String getHead(String fileName) {
        return "Content-Disposition: form-data; name=\"File\"; filename=\"" + fileName + "\"\r\nContent-Type: application/octet-stream\r\n\r\n";
    }

    class FileToTransfer {
        private File file = null;
        private boolean delete = false;
        private String uploadURL = null;

        public FileToTransfer(File file, String uploadURL, boolean delete) {
            this.file = file;
            this.uploadURL = uploadURL;
            this.delete = delete;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUploadURL() {
            return this.uploadURL;
        }

        public void setUploadURL(String uploadURL) {
            this.uploadURL = uploadURL;
        }

        public boolean isDelete() {
            return this.delete;
        }

        public void setDelete(boolean delete) {
            this.delete = delete;
        }
    }
}

