/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;

public class HtmlBrowser
extends JFrame {
    JPanel JPanel2 = new JPanel();
    JToolBar JToolBar1 = new JToolBar();
    JButton btnPrevious = null;
    JButton btnNext = null;
    JEditorPane htmlPage = null;
    JScrollPane jspPage = null;
    JViewport vpPage = null;
    String currentPage = null;
    Vector<String> oldPages = new Vector();
    int currentPageIdx = 0;
    ClassLoader cl = this.getClass().getClassLoader();
    private static final String KEY_HELP = "aide";
    private static HtmlBrowser browser = null;

    public static HtmlBrowser getInstance() {
        if (browser == null) {
            browser = new HtmlBrowser();
        }
        return browser;
    }

    public static void show(String page) {
        HtmlBrowser.getInstance().setCurrentPage(page);
        HtmlBrowser.getInstance().setVisible(true);
    }

    private HtmlBrowser() {
        super(KEY_HELP);
        this.setSize(600, 600);
        this.setResizable(false);
        this.JPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.JPanel2.setBounds(0, 0, 790, 29);
        this.JToolBar1.setAlignmentY(0.222222f);
        this.JPanel2.add(this.JToolBar1);
        this.JToolBar1.setBounds(0, 0, 410, 29);
        this.JToolBar1.add(this.getBtnPrevious());
        this.JToolBar1.add(this.getBtnNext());
        this.getVpPage().add(this.getHtmlPage());
        this.getContentPane().add((Component)this.JPanel2, "North");
        this.getContentPane().add(this.getJspPage());
        KeyStroke keystr = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(new EscapeAction(), "EchapAide", keystr, 2);
    }

    public JButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new JButton("Page suivante");
            this.btnNext.setFocusPainted(false);
            this.btnNext.setEnabled(false);
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    HtmlBrowser.this.btnNextActionPerformed(event);
                }
            });
        }
        return this.btnNext;
    }

    public JButton getBtnPrevious() {
        if (this.btnPrevious == null) {
            this.btnPrevious = new JButton("Page prec\u00e9dente");
            this.btnPrevious.setFocusPainted(false);
            this.btnPrevious.setEnabled(false);
            this.btnPrevious.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    HtmlBrowser.this.btnPrevActionPerformed(event);
                }
            });
        }
        return this.btnPrevious;
    }

    public JEditorPane getHtmlPage() {
        if (this.htmlPage == null) {
            this.htmlPage = new JEditorPane();
            this.htmlPage.setEditable(false);
            this.htmlPage.addHyperlinkListener(this.createHyperLinkListener());
            this.htmlPage.setBounds(0, 0, 600, 600);
        }
        return this.htmlPage;
    }

    public JScrollPane getJspPage() {
        if (this.jspPage == null) {
            this.jspPage = new JScrollPane();
        }
        return this.jspPage;
    }

    public JViewport getVpPage() {
        if (this.vpPage == null) {
            this.vpPage = this.getJspPage().getViewport();
        }
        return this.vpPage;
    }

    public void escapeActionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    private void btnNextActionPerformed(ActionEvent event) {
        try {
            if (this.currentPageIdx++ < this.oldPages.size()) {
                URL url = Fonctions.getURL(null, this.oldPages.elementAt(this.currentPageIdx));
                this.getHtmlPage().setPage(url);
            }
            this.checkBtn();
        }
        catch (Exception e) {
            TimsLogger.warn(" btnNext_actionPerformed : " + e);
        }
    }

    private void btnPrevActionPerformed(ActionEvent event) {
        try {
            if (this.currentPageIdx > 0 && !this.oldPages.isEmpty()) {
                URL url = Fonctions.getURL(null, this.oldPages.elementAt(--this.currentPageIdx));
                this.getHtmlPage().setPage(url);
            }
            this.checkBtn();
        }
        catch (Exception e) {
            TimsLogger.warn(" btnNext_actionPerformed : " + e);
        }
    }

    private void checkBtn() {
        if (this.oldPages == null || this.oldPages.size() == 0) {
            this.getBtnNext().setEnabled(false);
            this.getBtnPrevious().setEnabled(false);
        } else {
            if (this.currentPageIdx > 0) {
                this.getBtnPrevious().setEnabled(true);
            } else {
                this.getBtnPrevious().setEnabled(false);
            }
            if (this.currentPageIdx + 1 < this.oldPages.size()) {
                this.getBtnNext().setEnabled(true);
            } else {
                this.getBtnNext().setEnabled(false);
            }
        }
    }

    private HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HtmlBrowser.this.getHtmlPage().getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            TimsLogger.debug(e.toString());
                            HtmlBrowser.this.currentPage = e.getURL().getPath();
                            HtmlBrowser.this.getHtmlPage().setPage(e.getURL());
                            HtmlBrowser.this.addHisto(HtmlBrowser.this.currentPage);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        };
    }

    private void addHisto(String path) {
        this.oldPages.add(path);
        this.currentPageIdx = this.oldPages.size() - 1;
        if (this.oldPages.size() > 25) {
            this.oldPages.remove(0);
        }
        this.checkBtn();
    }

    public String getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(String path) {
        try {
            this.currentPage = path;
            URL url = Fonctions.getURL(null, path);
            TimsLogger.debug("#HtmlBrowser.setPath # URL = " + url);
            this.getHtmlPage().setPage(url);
            this.addHisto(path);
            this.setTitle(path);
        }
        catch (MalformedURLException e) {
            TimsLogger.warn("#HtmlBrowser.setPath MalformedURLException# " + e);
            e.printStackTrace();
        }
        catch (Exception e) {
            TimsLogger.warn("#HtmlBrowser.setPath Exception# " + e);
            e.printStackTrace();
        }
    }

    class EscapeAction
    implements ActionListener {
        EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            HtmlBrowser.this.escapeActionPerformed(event);
        }
    }
}

