/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import transpo.system.TimsLogger;

public class MPanelPrinter
implements Printable {
    private JScrollPane panel;
    private boolean showPrintZone;
    private boolean fitWidthIntoPage;
    private boolean fitHeightIntoPage;
    private boolean wrapComponent;
    private PageFormat pageFormat;
    private PrinterJob printJob;
    private Vector<Double> taillePages;
    private String documentTitle = "";
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 0;

    public MPanelPrinter(JScrollPane panel) {
        this.panel = panel;
        this.initPrintablePanel();
    }

    public void initPrintablePanel() {
        this.showPrintZone = false;
        this.fitWidthIntoPage = true;
        this.wrapComponent = true;
        this.printJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printJob.defaultPage();
        this.pageFormat.setOrientation(1);
    }

    public void setOrientation(int orientation) {
        this.pageFormat.setOrientation(orientation);
    }

    public void setPrintZoneVisible(boolean status) {
        this.showPrintZone = status;
    }

    public void setWrapComponent(boolean status) {
        this.wrapComponent = status;
    }

    public void setFitWidthIntoPage(boolean status) {
        this.fitWidthIntoPage = status;
    }

    public int getPageWidth() {
        return (int)this.pageFormat.getImageableWidth();
    }

    public double getMarginTop() {
        return this.pageFormat.getImageableY();
    }

    public double getMarginLeft() {
        return this.pageFormat.getImageableX();
    }

    public void setLRMargins(int margin) {
        Paper paper = this.pageFormat.getPaper();
        paper.setImageableArea(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight());
        this.pageFormat.setPaper(paper);
    }

    public void setTBMargins(int margin) {
        Paper paper = this.pageFormat.getPaper();
        paper.setImageableArea(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight() + (double)(margin / 2));
        this.pageFormat.setPaper(paper);
        TimsLogger.verbose("marge = " + margin);
    }

    public void setDocumentTitle(String title) {
        this.documentTitle = title;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        JViewport view = this.panel.getViewport();
        JViewport rowHeader = this.panel.getRowHeader();
        JViewport columnHeader = this.panel.getColumnHeader();
        Dimension tailleDoc = new Dimension(view.getWidth() + rowHeader.getWidth(), view.getHeight() + columnHeader.getHeight());
        double printViewHeight = tailleDoc.getHeight();
        double pageHeight = pf.getImageableHeight();
        double printViewWidth = tailleDoc.getWidth();
        double pageWidth = pf.getImageableWidth();
        double scaleX = pageWidth / printViewWidth;
        if (scaleX > 1.0) {
            scaleX = 1.0;
        }
        int heightForTable = (int)(pageHeight - (double)columnHeader.getHeight());
        int numberOfLine = (int)((double)heightForTable / (22.0 * scaleX));
        int heightOfVPPaint = (int)((double)numberOfLine * (22.0 * scaleX));
        int totalNumPages = (int)Math.ceil(printViewHeight / (double)heightOfVPPaint);
        if (this.wrapComponent) {
            totalNumPages = this.taillePages.size();
        }
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        if (this.fitWidthIntoPage) {
            double ratio = scaleX;
            g2d.scale(ratio, ratio);
        } else {
            g2d.translate(0.0, (double)(-pageIndex) * pageHeight);
        }
        columnHeader.paint(g2d);
        g2d.translate(-rowHeader.getWidth(), columnHeader.getHeight());
        this.panel.paint(g2d);
        g2d.setColor(Color.BLACK);
        g2d.setFont(new Font("Verdanna", 2, 10));
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String date0 = format.format(new Date());
        g2d.drawString("Date d'impression : " + date0, 0, (int)pf.getImageableHeight() - 5);
        return 0;
    }

    public void print() {
        this.printJob.setPrintable(this, this.pageFormat);
        try {
            if (this.printJob.printDialog()) {
                if (this.wrapComponent) {
                    this.calculatePages();
                }
                Paper paper = this.pageFormat.getPaper();
                Paper save = this.pageFormat.getPaper();
                paper.setImageableArea(paper.getImageableX(), paper.getImageableY(), paper.getWidth() - paper.getImageableX(), paper.getHeight() - paper.getImageableY());
                this.pageFormat.setPaper(paper);
                this.printJob.setPrintable(this, this.pageFormat);
                this.printJob.print();
                this.pageFormat.setPaper(save);
            }
        }
        catch (PrinterException pe) {
            TimsLogger.warn("Erreur lors de l'impression du document: " + this.toString());
        }
    }

    private void calculatePages() {
        this.taillePages = new Vector();
        double hauteurPage = this.pageFormat.getImageableHeight();
        double hauteurTotal = 0.0;
        double hauteurCumul = 0.0;
        int i = 0;
        while (i < this.panel.getComponentCount()) {
            double hauteurComponent;
            int gridBagInsets = 0;
            if (this.panel.getLayout() instanceof GridBagLayout) {
                gridBagInsets = ((GridBagLayout)this.panel.getLayout()).getConstraints((Component)this.panel.getComponent((int)i)).insets.bottom + ((GridBagLayout)this.panel.getLayout()).getConstraints((Component)this.panel.getComponent((int)i)).insets.top;
            }
            if ((hauteurComponent = this.panel.getComponent(i).getSize().getHeight() + (double)gridBagInsets) > hauteurPage) {
                this.wrapComponent = false;
                return;
            }
            if ((hauteurTotal += hauteurComponent) > hauteurPage) {
                this.taillePages.add(new Double(hauteurCumul += (hauteurTotal -= hauteurComponent)));
                hauteurTotal = hauteurComponent;
            }
            ++i;
        }
        this.taillePages.add(new Double(hauteurCumul += hauteurTotal));
    }
}

