/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import transpo.system.TimsLogger;

public class Zip {
    public static final int MODE_CREATE = 0;
    public static final int MODE_READ = 1;
    public static final int MODE_LIST = 2;
    private int mode = 0;
    private String archiveName = "";
    private String restorePath = ".\\";
    private boolean useRep = true;
    private Vector files;
    String comment = null;
    private byte[] buffer = new byte[8092];
    ZipOutputStream archiveIn = null;
    ZipFile archiveOut = null;

    private int readRep(File files) {
        int cpt = 0;
        try {
            if (files.isDirectory()) {
                File[] f = files.listFiles();
                boolean c = false;
                int i = 0;
                while (i < f.length) {
                    File file = f[i];
                    this.readRep(file);
                    ++i;
                }
            } else {
                this.addToVector(files);
            }
        }
        catch (Exception e) {
            TimsLogger.warn(" linesInFiles  eror : " + e);
        }
        return cpt;
    }

    private void addToVector(File file) {
        this.files.add(file);
    }

    public void buildArchive(String path) {
        this.add(path);
        this.buildArchive();
    }

    public void buildArchive() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getArchiveName());
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ZipOutputStream zos = new ZipOutputStream(bos);
            for (File file : this.files) {
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream buf = new BufferedInputStream(fis);
                ZipEntry ze = new ZipEntry(this.getNameEntry(file));
                zos.putNextEntry(ze);
                int n = 0;
                while ((n = buf.read(this.buffer)) > 0) {
                    zos.write(this.buffer, 0, n);
                }
                buf.close();
                zos.closeEntry();
            }
            if (this.comment != null) {
                zos.setComment(this.comment);
            }
            zos.close();
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
        }
    }

    public void openArchive() {
        try {
            if (this.mode == 1) {
                this.archiveOut = new ZipFile(this.getArchiveName());
            } else {
                FileOutputStream fos = new FileOutputStream(this.getArchiveName());
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                this.archiveIn = new ZipOutputStream(bos);
            }
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
        }
    }

    public File extractFile(String name) {
        try {
            return this.extractFile(name, null);
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
            return null;
        }
    }

    public File extractFile(String name, File file) {
        if (this.mode != 1) {
            return null;
        }
        if (this.archiveOut == null) {
            this.openArchive();
        }
        try {
            ZipEntry ze = this.archiveOut.getEntry(name);
            String path = ze.getName();
            if (file == null) {
                if (!this.useRep) {
                    File f = new File(path);
                    path = f.getName();
                }
                if (!(file = new File(String.valueOf(this.restorePath) + path)).getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
            }
            FileOutputStream fos = new FileOutputStream(file);
            InputStream is = this.archiveOut.getInputStream(ze);
            int n = 0;
            while ((n = is.read(this.buffer)) > 0) {
                fos.write(this.buffer, 0, n);
            }
            is.close();
            fos.close();
            return file;
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
            return null;
        }
    }

    public void addFileToArchive(File file, String archivedName) {
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream buf = new BufferedInputStream(fis);
            ZipEntry ze = new ZipEntry(archivedName);
            this.archiveIn.putNextEntry(ze);
            int n = 0;
            while ((n = buf.read(this.buffer)) > 0) {
                this.archiveIn.write(this.buffer, 0, n);
            }
            buf.close();
            this.archiveIn.closeEntry();
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur addFileToArchive: " + e);
            TimsLogger.warn("file = " + file.getPath());
            TimsLogger.warn("achive = " + archivedName);
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void closeArchive() {
        try {
            if (this.comment != null) {
                this.archiveIn.setComment(this.comment);
            }
            this.archiveIn.close();
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur closeArchive : " + e);
        }
    }

    public void setArchiveWithRep(boolean f) {
        this.useRep = f;
    }

    private String getNameEntry(File f) {
        String s = f.getPath();
        s = !this.useRep ? f.getName() : s.substring(s.indexOf(":") + 2);
        return s;
    }

    public void extract() {
        try {
            ZipFile zp = new ZipFile(this.getArchiveName());
            Enumeration<? extends ZipEntry> enu = zp.entries();
            while (enu.hasMoreElements()) {
                File f;
                ZipEntry ze = enu.nextElement();
                String path = ze.getName();
                if (!this.useRep) {
                    f = new File(path);
                    path = f.getName();
                }
                if (!(f = new File(String.valueOf(this.restorePath) + path)).getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(f);
                InputStream is = zp.getInputStream(ze);
                int n = 0;
                while ((n = is.read(this.buffer)) > 0) {
                    fos.write(this.buffer, 0, n);
                }
                is.close();
                fos.close();
            }
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
        }
    }

    public void extract(String path) {
        try {
            ZipFile zp = new ZipFile(this.getArchiveName());
            Enumeration<? extends ZipEntry> enu = zp.entries();
            while (enu.hasMoreElements()) {
                File f;
                ZipEntry ze = enu.nextElement();
                String pathEntry = ze.getName();
                if (!this.useRep) {
                    f = new File(pathEntry);
                    pathEntry = f.getName();
                }
                if (!(f = new File(String.valueOf(path) + pathEntry)).getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(f);
                InputStream is = zp.getInputStream(ze);
                int n = 0;
                while ((n = is.read(this.buffer)) > 0) {
                    fos.write(this.buffer, 0, n);
                }
                is.close();
                fos.close();
            }
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
        }
    }

    public Zip() {
        this.files = new Vector();
    }

    public Zip(String archiveName) {
        this();
        this.setArchiveName(archiveName);
    }

    public Zip(String archiveName, int archiveMode) {
        this(archiveName);
        this.mode = archiveMode;
    }

    public Vector getList() {
        Vector<String> v = new Vector<String>();
        try {
            if (this.mode == 0) {
                Iterator iter = this.files.iterator();
                while (iter.hasNext()) {
                    v.add(((File)iter.next()).getPath());
                }
            } else {
                ZipFile zp = new ZipFile(this.getArchiveName());
                Enumeration<? extends ZipEntry> enu = zp.entries();
                while (enu.hasMoreElements()) {
                    v.add(enu.nextElement().getName());
                }
            }
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
        }
        return v;
    }

    public void addToArchive(String path) {
        this.add(path);
    }

    public void addToArchive(File file) {
        this.readRep(file);
    }

    public void add(String path) {
        try {
            File f = new File(path);
            this.readRep(f);
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur : " + e);
        }
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public int getMode() {
        return this.mode;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
        File f = new File(archiveName);
        this.restorePath = f.isDirectory() ? new String(archiveName) : f.getParent();
        if (!this.restorePath.endsWith("\\")) {
            this.restorePath = String.valueOf(this.restorePath) + "\\";
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public void setRestorePath(String restorePath) {
        this.restorePath = restorePath;
    }
}

