/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util.reader;

import fr.pgh.component.JNotificationFrame;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Societe;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jsmartcard.DriverCardSaving;
import transpo.system.uev.UEVProperty;
import transpo.system.uev.VuProcessingG1;
import transpo.system.uev.VuProcessingG2;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.messaging.StringMessage;
import transpo.system.util.reader.FileReadListener;
import transpo.system.util.reader.FileReadResult;

public class FileReadManager
implements FileReadListener {
    private static FileReadManager singleton = null;
    private static boolean reading = false;
    private EventListenerList listeners = new EventListenerList();
    private JNotificationFrame statusFrame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
    private LinkedBlockingQueue<CompanyFile> queue = null;
    private ArrayList<FileReadResult> reports = null;
    private final Thread thread = new Thread("uploader"){

        @Override
        public void run() {
            FileReadManager.this.launchReader();
        }
    };

    public static FileReadManager getInstance() {
        if (singleton == null) {
            TimsLogger.debug("#FileReadManager.getInstance# create reader");
            singleton = new FileReadManager();
        }
        return singleton;
    }

    private void launchReader() {
        try {
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                CompanyFile file = this.queue.take();
                reading = true;
                FileReadResult report = null;
                try {
                    TimsLogger.debug("#FileManager.launchReader# Start reading " + file.getFile().getAbsolutePath());
                    Transport.bdd.changeDB(file.getCompany().getNomSociete(), false);
                    String fileName = file.getFile().getName().toUpperCase();
                    if (!fileName.endsWith("C1B") && !fileName.endsWith("V1B")) {
                        File converted = Fonctions.convertTo1B(file.getFile());
                        file.setFile(converted);
                        fileName = file.getFile().getName().toUpperCase();
                    }
                    if (fileName.endsWith("C1B")) {
                        DriverCardSaving dcs = new DriverCardSaving(file.getFile());
                        report = dcs.run();
                    } else {
                        report = fileName.endsWith("V1B") ? (UEVProperty.getVuGeneration(file.getFile().getAbsolutePath()) == 2 ? new VuProcessingG2(file.getFile()).run() : new VuProcessingG1(file.getFile()).run()) : new FileReadResult(fileName, 0, null, new StringMessage(LanguageTranslator.getString("generics.unknownFileType")), LanguageTranslator.getString("generics.unknownFileType"));
                    }
                    this.fireFileReadComplete(report);
                }
                catch (Exception ex) {
                    try {
                        TimsLogger.error("#FileReadManager.launchReader# Error on read " + file.getFile().getAbsolutePath());
                        MessageSystemManager.error(null, String.valueOf(file.getFile().getName()) + " " + ex.getMessage(), LanguageTranslator.getString("file.read.error"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ex.printStackTrace();
                }
                boolean bl = reading = this.queue.size() != 0;
            }
        }
        catch (Exception e) {
            TimsLogger.error("#FileReadManager.launchReader# Error on file read manager");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private FileReadManager() {
        this.queue = new LinkedBlockingQueue();
        this.reports = new ArrayList();
        this.addListener(FileReadListener.class, this);
        this.thread.start();
    }

    public void queueCompanyFiles(Collection<CompanyFile> filesToRead) {
        this.queue.addAll(filesToRead);
    }

    public void queueFiles(Collection<File> filesToRead) {
        ArrayList<CompanyFile> toAdd = new ArrayList<CompanyFile>();
        for (File file : filesToRead) {
            toAdd.add(new CompanyFile(file, BddTransport.getInstance().getCompany()));
        }
        if (filesToRead != null) {
            this.queueCompanyFiles(toAdd);
        }
    }

    public void queueFile(CompanyFile fileToRead) {
        this.queue.add(fileToRead);
    }

    public void selectFile() {
        File[] filesToRead = this.getFile();
        if (filesToRead != null) {
            this.queueFiles(Arrays.asList(filesToRead));
        }
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public boolean isReading() {
        if (reading) {
            TimsLogger.debug("FileReadManager.isReading " + this.queue.size() + " files to read");
        }
        return reading;
    }

    private File[] getFile() {
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            JFileChooser choix = new JFileChooser(prefs.node("DIRECTORY").get("UEV", System.getProperty("user.home")));
            choix.setFileSelectionMode(0);
            choix.setMultiSelectionEnabled(true);
            choix.setDialogTitle(LanguageTranslator.getString("message.selectFile"));
            choix.setApproveButtonText(LanguageTranslator.getString("button.valid"));
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                prefs.node("DIRECTORY").put("UEV", choix.getCurrentDirectory().getAbsolutePath());
                return choix.getSelectedFiles();
            }
            return null;
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.system.uev.LectureFichierCap.getFile(  )  : " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    private ImageIcon getStatusIcon(int status) {
        switch (status) {
            case 0: {
                return new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup")));
            }
            case 1: 
            case 3: {
                return new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid")));
            }
        }
        return new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe")));
    }

    public void addFile(File file, Societe company) {
        this.queueFile(new CompanyFile(file, company == null ? Transport.bdd.getCompany() : company));
    }

    public <T extends EventListener> void addListener(Class<T> listenerC, T listener) {
        this.listeners.add(listenerC, listener);
    }

    public <T extends EventListener> void removeListener(Class<T> listenerC, T listener) {
        this.listeners.remove(listenerC, listener);
    }

    public void fireFileReadComplete(FileReadResult result) {
        FileReadListener[] fileReadListenerArray = (FileReadListener[])this.listeners.getListeners(FileReadListener.class);
        int n = fileReadListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileReadListener listener = fileReadListenerArray[n2];
            listener.readed(result);
            ++n2;
        }
    }

    @Override
    public void readed(FileReadResult report) {
        TimsLogger.debug("#FRM.readed# " + report.getFile() + " end");
        if (report != null) {
            if (report.getStatus() == 0) {
                TimsLogger.error("#FileReadManager.run# la lecture a remont\u00e9 une erreur... (" + report.getFile() + ")");
                MessageSystemManager.error((Component)MainFrameTransport.getInstance(), report.getResult(), report.getResume());
            } else if (report.getStatus() == 3) {
                TimsLogger.warn("#FileReadManager.run# la lecture a remont\u00e9 un avertissement... (" + report.getFile() + ")");
                MessageSystemManager.warning((Component)MainFrameTransport.getInstance(), report.getInfo(), report.getResume());
            }
            if (report.getStatus() != 0) {
                this.statusFrame.addMessage(report.getResume(), new JLabel(report.getResult().toString()), this.getStatusIcon(report.getStatus()));
                this.statusFrame.showNotification(6);
            }
            this.reports.add(report);
        }
    }

    @Override
    public void reading(CompanyFile reading) {
    }

    public class CompanyFile {
        public File toRead = null;
        public Societe company = null;

        public CompanyFile(File toRead, Societe company) {
            this.toRead = toRead;
            this.company = company;
        }

        public void setFile(File convertedToRead) {
            this.toRead = convertedToRead;
        }

        public File getFile() {
            return this.toRead;
        }

        public Societe getCompany() {
            return this.company;
        }
    }
}

