/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util.watcher;

import fr.pgh.data.bdd.Societe;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import transpo.system.TimsLogger;
import transpo.system.util.watcher.AbstractResourceWatcher;

public class DirectoryWatcher
extends AbstractResourceWatcher {
    private Map<String, Long> prevFiles = new HashMap<String, Long>();
    private Map<String, Long> currentFiles = new HashMap<String, Long>();
    private ArrayList<String> downloadingFiles = new ArrayList();
    private Societe company;
    private String directory;
    private boolean checkAllAtStart;

    public DirectoryWatcher(Societe company, String directory, int intervalSeconds, boolean checkAllAtStart) throws IllegalArgumentException {
        super(intervalSeconds, String.valueOf(directory) + " interval watcher.");
        File theDirectory = new File(directory);
        if (theDirectory != null && !theDirectory.isDirectory()) {
            String message = "The path " + directory + " does not represent a valid directory.";
            throw new IllegalArgumentException(message);
        }
        this.company = company;
        this.directory = directory;
        this.checkAllAtStart = checkAllAtStart;
    }

    @Override
    public void start() {
        if (!this.checkAllAtStart) {
            this.takeSnapshot();
        }
        super.start();
        File theDirectory = new File(this.directory);
        this.monitoringStarted(theDirectory);
    }

    @Override
    public void stop() {
        super.stop();
        File theDirectory = new File(this.directory);
        this.monitoringStopped(theDirectory);
    }

    private void takeSnapshot() {
        this.prevFiles.clear();
        this.prevFiles.putAll(this.currentFiles);
        this.currentFiles.clear();
        File theDirectory = new File(this.directory);
        if (!theDirectory.exists()) {
            TimsLogger.warn("#DW.takeSnapshot# directory " + this.directory + "doesn't exist anymore, stop watcher");
            this.stop();
            return;
        }
        File[] children = theDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".C1B") || name.toUpperCase().endsWith(".V1B") || name.toUpperCase().endsWith(".DDD");
            }
        });
        int i = 0;
        while (i < children.length) {
            File file = children[i];
            this.currentFiles.put(file.getAbsolutePath(), new Long(file.length()));
            ++i;
        }
    }

    @Override
    protected void doInterval() {
        this.takeSnapshot();
        ArrayList<String> list = new ArrayList<String>(this.currentFiles.keySet());
        Collections.sort(list);
        for (String fileName : list) {
            Long prevModified;
            Long length = this.currentFiles.get(fileName);
            if (!this.prevFiles.containsKey(fileName)) {
                this.prevFiles.put(fileName, 0L);
                this.downloadingFiles.add(fileName);
            }
            if ((prevModified = this.prevFiles.get(fileName)).compareTo(length) != 0 || !this.downloadingFiles.contains(fileName)) continue;
            this.resourceAdded(new File(fileName));
            this.downloadingFiles.remove(fileName);
        }
        for (String fileName : this.prevFiles.keySet()) {
            if (this.currentFiles.containsKey(fileName)) continue;
            this.downloadingFiles.remove(fileName);
            this.resourceDeleted(fileName);
        }
    }
}

