/*
 * Decompiled with CFR 0.152.
 */
package transpo.ui.calendrier;

import fr.pgh.component.JRoundButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.ui.calendrier.Calendrier;

public class CalendrierCadre
extends JDialog {
    public boolean cliq = false;
    private static final String KEY_RIGHT = "icone_right";
    private static final String KEY_LEFT = "icone_left";
    private static final Fmresources res = new Fmresources();
    ClassLoader cl = this.getClass().getClassLoader();
    private JPanel pnlPpl = null;
    Color oldColor = null;
    BoutonJour oldJour = null;
    private ImageIcon left = null;
    private ImageIcon right = null;
    private JLabel lblDay = null;
    private JLabel lblMonth = null;
    private JLabel lblYear = null;
    private BoutonJour[] day = new BoutonJour[42];
    private JButton btnPrevMonth = null;
    private JButton btnNextMonth = null;
    private JButton btnPrevYear = null;
    private JButton btnNextYear = null;
    private String jj;
    private String mm;
    private String aaaa;
    public Calendrier cal = new Calendrier();

    @Override
    public void dispose() {
        TimsLogger.verbose("#CalendrierCadre.dispose()#");
        super.dispose();
    }

    public CalendrierCadre(JFrame f) {
        super(f);
        TimsLogger.verbose("#CalendrierCadre()#");
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ImageIcon getRight() {
        if (this.right == null) {
            this.right = new ImageIcon(this.cl.getResource(res.getResourceString(KEY_RIGHT)));
        }
        return this.right;
    }

    private ImageIcon getLeft() {
        if (this.left == null) {
            this.left = new ImageIcon(this.cl.getResource(res.getResourceString(KEY_LEFT)));
        }
        return this.left;
    }

    private void jbInit() throws Exception {
        this.setModal(true);
        this.setResizable(false);
        this.setBounds(0, 10, 184, 210);
        this.setTitle("Calendrier");
        this.setUndecorated(true);
        this.getContentPane().setBounds(new Rectangle(0, 0, 184, 210));
        this.getContentPane().add(this.getPnlPpl());
    }

    private JPanel getPnlPpl() {
        if (this.pnlPpl == null) {
            TimsLogger.verbose("#CalendrierCadre.getPnlPpl()#");
            this.pnlPpl = new JPanel();
            this.pnlPpl.setBorder(new LineBorder(Color.black));
            this.pnlPpl.setLayout(null);
            this.pnlPpl.setBounds(new Rectangle(0, 0, 184, 210));
            this.lblDay = new JLabel("Lun Mar Mer Jeu Ven Sam Dim");
            this.lblDay.setFont(new Font("Dialog", 1, 12));
            this.lblDay.setBounds(new Rectangle(5, 60, 177, 17));
            this.lblMonth = new JLabel();
            this.lblMonth.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblMonth.setFont(new Font("Dialog", 1, 16));
            if (!System.getProperty("screen.contrast", "0").equals("1")) {
                this.lblMonth.setForeground(SystemColor.inactiveCaption);
            }
            this.lblMonth.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblMonth.setHorizontalAlignment(0);
            this.lblMonth.setHorizontalTextPosition(0);
            this.lblMonth.setBounds(new Rectangle(28, 29, 119, 31));
            this.lblYear = new JLabel();
            this.lblYear.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblYear.setFont(new Font("Dialog", 1, 16));
            if (!System.getProperty("screen.contrast", "0").equals("1")) {
                this.lblYear.setForeground(SystemColor.inactiveCaption);
            }
            this.lblYear.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblYear.setHorizontalAlignment(0);
            this.lblYear.setHorizontalTextPosition(0);
            this.lblYear.setBounds(new Rectangle(51, 2, 75, 23));
            int i = 0;
            while (i < this.day.length) {
                int posy = 79;
                while (posy <= 184) {
                    int posx = 4;
                    while (posx <= 154) {
                        this.day[i] = new BoutonJour(this);
                        this.day[i].setBorder(BorderFactory.createEtchedBorder());
                        this.day[i].setText("");
                        this.day[i].setBounds(new Rectangle(posx, posy, 25, 21));
                        if (i == 40) {
                            this.day[i].setBackground(new Color(255, 255, 155));
                            this.day[i].setText("O");
                        }
                        if (i == 41) {
                            this.day[i].setBackground(new Color(200, 155, 155));
                            this.day[i].setText("X");
                        }
                        ++i;
                        posx += 25;
                    }
                    posy += 21;
                }
            }
            this.updateCalendar();
            i = 0;
            while (i < this.day.length) {
                this.pnlPpl.add((Component)this.day[i], null);
                ++i;
            }
            this.pnlPpl.add((Component)this.lblMonth, null);
            this.pnlPpl.add((Component)this.lblDay, null);
            this.pnlPpl.add((Component)this.lblYear, null);
            this.pnlPpl.add((Component)this.getBtnNextMonth(), null);
            this.pnlPpl.add((Component)this.getBtnPrevMonth(), null);
            this.pnlPpl.add((Component)this.getBtnNextYear(), null);
            this.pnlPpl.add((Component)this.getBtnPrevYear(), null);
        }
        return this.pnlPpl;
    }

    private JButton getBtnPrevMonth() {
        if (this.btnPrevMonth == null) {
            this.btnPrevMonth = new JButton();
            this.btnPrevMonth.setBorder(null);
            this.btnPrevMonth.setToolTipText(LanguageTranslator.getString("calendar.previousMonth"));
            this.btnPrevMonth.setBorderPainted(false);
            this.btnPrevMonth.setContentAreaFilled(false);
            this.btnPrevMonth.setFocusPainted(false);
            this.btnPrevMonth.setHorizontalTextPosition(0);
            this.btnPrevMonth.setIcon(this.getLeft());
            this.btnPrevMonth.setBounds(new Rectangle(1, 33, 25, 27));
            this.btnPrevMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendrierCadre.this.addMonth(-1);
                }
            });
        }
        return this.btnPrevMonth;
    }

    private JButton getBtnNextMonth() {
        if (this.btnNextMonth == null) {
            this.btnNextMonth = new JButton();
            this.btnNextMonth.setBorder(null);
            this.btnNextMonth.setToolTipText(LanguageTranslator.getString("calendar.nextMonth"));
            this.btnNextMonth.setBorderPainted(false);
            this.btnNextMonth.setContentAreaFilled(false);
            this.btnNextMonth.setFocusPainted(false);
            this.btnNextMonth.setHorizontalTextPosition(0);
            this.btnNextMonth.setIcon(this.getRight());
            this.btnNextMonth.setBounds(new Rectangle(151, 33, 25, 27));
            this.btnNextMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendrierCadre.this.addMonth(1);
                }
            });
        }
        return this.btnNextMonth;
    }

    private JButton getBtnPrevYear() {
        if (this.btnPrevYear == null) {
            this.btnPrevYear = new JButton();
            this.btnPrevYear.setBorder(null);
            this.btnPrevYear.setToolTipText(LanguageTranslator.getString("calendar.previousYear"));
            this.btnPrevYear.setBorderPainted(false);
            this.btnPrevYear.setContentAreaFilled(false);
            this.btnPrevYear.setFocusPainted(false);
            this.btnPrevYear.setHorizontalTextPosition(0);
            this.btnPrevYear.setIcon(this.getLeft());
            this.btnPrevYear.setBounds(new Rectangle(25, 2, 25, 27));
            this.btnPrevYear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendrierCadre.this.addMonth(-12);
                }
            });
        }
        return this.btnPrevYear;
    }

    private JButton getBtnNextYear() {
        if (this.btnNextYear == null) {
            this.btnNextYear = new JButton();
            this.btnNextYear.setBorder(null);
            this.btnNextYear.setToolTipText(LanguageTranslator.getString("calendar.nextYear"));
            this.btnNextYear.setBorderPainted(false);
            this.btnNextYear.setContentAreaFilled(false);
            this.btnNextYear.setFocusPainted(false);
            this.btnNextYear.setHorizontalTextPosition(0);
            this.btnNextYear.setIcon(this.getRight());
            this.btnNextYear.setBounds(new Rectangle(129, 2, 25, 27));
            this.btnNextYear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendrierCadre.this.addMonth(12);
                }
            });
        }
        return this.btnNextYear;
    }

    void addMonth(int monthCount) {
        this.cal.addMonth(monthCount);
        this.oldJour = null;
        this.updateCalendar();
    }

    void updateCalendar() {
        boolean isToday = true;
        Date today = new Date();
        GregorianCalendar todayCal = new GregorianCalendar();
        todayCal.setTime(today);
        if (todayCal.get(2) != this.cal.getMonth()) {
            isToday = false;
        } else if (todayCal.get(1) != this.cal.getYear()) {
            isToday = false;
        }
        this.lblMonth.setText(Calendrier.MONTH_NAME[this.cal.getMonth()]);
        this.lblYear.setText(String.valueOf(this.cal.getYear()));
        int pjdm = this.cal.premierJour - 1;
        if (pjdm == 0) {
            pjdm = 7;
        }
        int numJour = 1;
        int a = 1;
        while (a < this.day.length - 1) {
            if (a >= pjdm && numJour < this.cal.nbDayInMonth + 1) {
                this.day[a - 1].setBackground(new Color(236, 233, 216));
                this.day[a - 1].setText(String.valueOf(numJour));
                if (isToday && todayCal.get(5) == numJour) {
                    this.day[a - 1].setBackground(new Color(170, 190, 255));
                }
                ++numJour;
            } else {
                this.day[a - 1].setBackground(new Color(236, 233, 216));
                this.day[a - 1].setText("");
            }
            ++a;
        }
    }

    void selectedOnClic(BoutonJour j) {
        if (j.getText().equals("O")) {
            this.cliq = true;
            this.jj = "";
            this.dispose();
        } else if (j.getText().equals("X")) {
            this.cliq = false;
            this.dispose();
        } else if (!j.getText().equals("")) {
            if (this.oldJour != null) {
                this.oldJour.setBackground(this.oldColor);
            }
            this.oldColor = j.getBackground();
            j.setBackground(new Color(206, 203, 186));
            this.oldJour = j;
            this.cal.setDay(new Integer(j.getText()));
            this.cliq = true;
            this.jj = this.getDay(j.getText());
            this.mm = this.getMonthNumber(this.lblMonth.getText());
            this.aaaa = this.lblYear.getText();
            Preferences.userRoot().node("TIMS").putInt("mois", Integer.parseInt(this.mm) - 1);
            Preferences.userRoot().node("TIMS").putInt("annee", Integer.parseInt(this.aaaa));
            this.dispose();
        }
    }

    String getMonthNumber(String jour) {
        String retour = "";
        int x = 0;
        while (x < Calendrier.MONTH_NAME.length) {
            if (jour.equals(Calendrier.MONTH_NAME[x]) && (retour = String.valueOf(x + 1)).length() == 1) {
                retour = "0" + retour;
            }
            ++x;
        }
        return retour;
    }

    String getDay(String jour) {
        if (jour.length() == 1) {
            jour = "0" + jour;
        }
        return jour;
    }

    public String getSelected() {
        return this.jj.equals("") ? "" : String.valueOf(this.jj) + "/" + this.mm + "/" + this.aaaa;
    }

    public class BoutonJour
    extends JRoundButton {
        public CalendrierCadre pere;

        public BoutonJour(CalendrierCadre pere) {
            this.pere = pere;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BoutonJour.this.affiche();
                }
            });
        }

        public void affiche() {
            this.pere.selectedOnClic(this);
        }
    }
}

