/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.exception.DayException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.offence.MasterOffence;

public class CalculInfractionPrincipal
extends Thread {
    public static final int DAILY_REST_AMOUNT = 420;
    public static final int WEEKLY_REST_AMOUNT = 2700;
    public static final int CUT = 0;
    public static final int DAILY_REST = 1;
    public static final int WEEKLY_REDUCED_REST = 2;
    public static final int WEEKLY_REST = 3;
    private Vector<ActiviteConducteur> calculActivite;
    private Vector<Offence> offences = new Vector();
    public Vector<Conducteur> drivers = null;
    public Vector<Conducteur> errors = null;
    public Conducteur driver = null;
    private String dateDebut = "";
    private Date dateDebutFormatter = null;
    private String dateJour = "";
    private String dateFin = "";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private int brute = 1;
    private ProgressBar pg = null;
    private boolean ui = true;
    private int status = 9;

    public CalculInfractionPrincipal(String dateJour, Vector<Conducteur> drivers, int brute) {
        this.brute = brute;
        this.dateJour = dateJour;
        this.drivers = drivers;
        this.errors = new Vector();
        try {
            this.dateDebutFormatter = this.dateFormat.parse(dateJour);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setUI(boolean ui) {
        this.ui = ui;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void run() {
        this.status = 8;
        if (Transport.apiMode == 0 && this.ui) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalculInfractionPrincipal.this.pg = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("offence.calculation"));
                    CalculInfractionPrincipal.this.pg.setVisible(true);
                    CalculInfractionPrincipal.this.pg.getBar().setMaximum(CalculInfractionPrincipal.this.drivers.size());
                }
            });
        }
        for (final Conducteur cond : this.drivers) {
            if (Transport.apiMode == 0 && this.ui) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalculInfractionPrincipal.this.pg.getBar().setValue(CalculInfractionPrincipal.this.pg.getBar().getValue() + 1);
                        CalculInfractionPrincipal.this.pg.getBar().setString(String.valueOf(cond.getNom()) + " " + cond.getPrenom());
                    }
                });
            }
            try {
                this.dateDebut = this.brute == 1 ? (cond.getDernierCalculBrut() == "" ? "1970-01-01" : cond.getDernierCalculBrut()) : (cond.getDernierCalculModifie() == "" ? "1970-01-01" : cond.getDernierCalculModifie());
                this.driver = cond;
                TimsLogger.debug("#CIP.run# cleConduteur = " + this.driver.getCleConducteur() + ", dateDebut = " + this.dateDebut + " (on part du d\u00e9but de la semaine), date fin = " + this.dateJour);
                this.dateDebutFormatter = ConversionTime.stringToDate(this.dateDebut, "yyyy-MM-dd");
                Transport.ps.startOperation();
                this.initialiseActivite();
                Transport.ps.endOperation(PerformanceScanner.READING, "offence activities");
                if (this.calculActivite.size() == 0) continue;
                Transport.ps.startOperation();
                for (OffenceType offence : OffenceType.getList()) {
                    if (!(offence.getCompanyType() != 0 && Integer.parseInt(System.getProperty("company.type", "1")) != offence.getCompanyType() || offence.getMemberState() != 0 && offence.getMemberState() != cond.getMemberState() && cond.getMemberState() != 0)) {
                        TimsLogger.debug("#CIP.run# driver launch offence calculation :  " + offence.getName() + " (" + offence.getParts().size() + " parts)");
                        Transport.ps.startOperation();
                        Class<?> c = Class.forName(offence.getClassToLoad());
                        MasterOffence mo = (MasterOffence)c.newInstance();
                        mo.setOffence(offence);
                        mo.setDriver(cond);
                        mo.setParent(this);
                        mo.setActivities(this.calculActivite);
                        mo.process();
                        long processLength = Transport.ps.endOperation(PerformanceScanner.PROCESS, String.valueOf(offence.getName()) + " calculation time");
                        TimsLogger.debug("\t#CIP.run#" + offence.getName() + " calculation time = " + processLength);
                        continue;
                    }
                    TimsLogger.debug("#CIP.run# driver did not complete all requested elements to launch offence " + offence.getName());
                }
                long processLength = Transport.ps.endOperation(PerformanceScanner.PROCESS, "total offence calculation time");
                TimsLogger.debug("total offence calculation time = " + processLength);
                Transport.ps.startOperation();
                this.stockInfraction();
                Transport.ps.endOperation(PerformanceScanner.INSERT, "offence");
            }
            catch (DayException ex) {
                this.errors.add(cond);
            }
            catch (Exception ex) {
                this.errors.add(cond);
                ex.printStackTrace();
            }
        }
        if (Transport.apiMode == 0 && this.ui) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalculInfractionPrincipal.this.pg.dispose();
                    if (CalculInfractionPrincipal.this.errors.size() != 0) {
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), CalculInfractionPrincipal.this.getErrorsMessage(CalculInfractionPrincipal.this.errors), LanguageTranslator.getString("offence.title"), 0);
                    } else {
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("offence.calculation.end"), LanguageTranslator.getString("offence.title"), 1);
                    }
                }
            });
        }
        if (this.errors.size() != 0) {
            TimsLogger.info("#CIP.run# liste erreurs ");
            int x = 0;
            while (x < this.errors.size()) {
                this.errors.get(x).affiche();
                ++x;
            }
        }
        this.status = this.errors.size() != 0 ? 2 : 1;
    }

    public Vector<Conducteur> getErrors() {
        return this.errors;
    }

    private Object[] getErrorsMessage(Vector<Conducteur> errors) {
        Object[] message = new Object[]{LanguageTranslator.getString("offence.errors"), new JScrollPane(new JList(new ComboBoxModel((Vector<?>)errors)))};
        return message;
    }

    public void initialiseActivite() throws Exception {
        try {
            this.dateFin = "";
            this.calculActivite = new Vector();
            GregorianCalendar calendrier = new GregorianCalendar();
            calendrier.setTime(ConversionTime.getFirstDayOfPreviousWeek(this.dateFormat.parse(this.dateDebut), 2));
            calendrier.add(5, -1);
            String dateDebutSemaine = this.dateFormat.format(calendrier.getTime());
            Vector<ActiviteConducteur> calculActiviteTmp = null;
            calculActiviteTmp = Transport.bdd.getActivite(this.driver.getCleConducteur(), dateDebutSemaine, this.dateJour, this.brute == 1 ? 1 : -1, 0);
            if (calculActiviteTmp != null && calculActiviteTmp.size() != 0) {
                ActiviteConducteur premiereDate = calculActiviteTmp.get(0);
                calendrier.setTime(this.dateFormat.parse(premiereDate.getDateJour()));
                Date dateCourante = calendrier.getTime();
                ActiviteConducteur act = null;
                int i = 0;
                while (i < calculActiviteTmp.size() - 1) {
                    act = calculActiviteTmp.get(i);
                    while (dateCourante.before(this.dateFormat.parse(act.getDateJour().substring(0, 10)))) {
                        this.calculActivite.add(new ActiviteConducteur(0, this.driver.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, this.dateFormat.format(dateCourante), "", "", "", "", "", 0, 0, 0));
                        calendrier.add(5, 1);
                        dateCourante = calendrier.getTime();
                    }
                    while (this.dateFormat.parse(act.getDateJour().substring(0, 10)).equals(dateCourante) && i < calculActiviteTmp.size() - 1) {
                        this.calculActivite.add(act);
                        act = calculActiviteTmp.get(++i);
                    }
                    calendrier.add(5, 1);
                    dateCourante = calendrier.getTime();
                }
                this.calculActivite.add(act);
                this.dateFin = act.getDateJour().substring(0, 10);
            }
            this.offences.clear();
        }
        catch (Exception ex) {
            TimsLogger.warn("Impossible de r\u00e9cup\u00e9rer les activit\u00e9s conducteurs." + ex);
            ex.printStackTrace();
        }
    }

    public void afficheInfraction() {
        TimsLogger.debug("liste infraction : (" + this.offences.size() + ")");
        for (Offence tmp : this.offences) {
            if (Transport.debug < 1) continue;
            tmp.affiche();
        }
    }

    public void afficheAct() {
        int i = 0;
        Iterator<ActiviteConducteur> iter = this.calculActivite.iterator();
        while (iter.hasNext()) {
            TimsLogger.info("" + ++i);
            iter.next().affiche();
        }
    }

    public void addInfraction(String jour, int heure, int offencePartId, int threshold, int type, int cost) {
        try {
            Date day = this.dateFormat.parse(jour);
            Offence check = new Offence();
            Offence toAdd = new Offence(this.driver.getCleConducteur(), day, heure, offencePartId, threshold, this.brute == 1, type, cost);
            if (!check.loadByOffence(toAdd)) {
                this.offences.add(toAdd);
            } else if (check.getThreshold() != toAdd.getThreshold()) {
                TimsLogger.debug("#CIP.addInfraction# Threeshold changed");
                check.delete();
                this.offences.add(toAdd);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean stockInfraction() {
        boolean toReturn = false;
        try {
            int random = (int)(Math.random() * 1000.0);
            String offFn = String.valueOf(Transport.savePath) + "offence" + random + ".txt";
            while (new File(offFn).exists()) {
                random = (int)(Math.random() * 1000.0);
                offFn = String.valueOf(Transport.savePath) + "offence" + random + ".txt";
            }
            FileWriter fOff = new FileWriter(offFn);
            for (Offence tmp : this.offences) {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    tmp.insert();
                }
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                TimsLogger.debug("sqlInsert " + tmp.getSQLInsert());
                String sql = tmp.getSQLInsert();
                fOff.write(sql);
                fOff.write("\n");
            }
            fOff.close();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                Transport.bdd.loadDriverOffense(offFn);
            }
            Transport.bdd.updateDriverOffenceDate(this.dateFin, 0, this.driver.getCleConducteur(), this.brute == 1);
            new File(offFn).delete();
            toReturn = true;
        }
        catch (IOException e) {
            TimsLogger.warn("erreur dans stock Infraction : " + e);
        }
        return toReturn;
    }
}

