/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class ContinuousDrive
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold serious = null;
    private OffenceThreshold verySerious = null;
    private int interruption = 0;
    private int firstInterruption = 0;
    private int secondInterruption = 0;

    @Override
    public void process() throws Exception {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.minor");
        this.serious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.serious");
        this.verySerious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.verySerious");
        this.interruption = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.interruption").getThreshold();
        this.firstInterruption = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.firstInterruption").getThreshold();
        this.secondInterruption = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.secondInterruption").getThreshold();
        int dureeInterruption = 0;
        int dureeConduite = 0;
        boolean infractionTrouve = false;
        String dateInfraction = null;
        int hour = 0;
        boolean minimum = false;
        boolean pendingPeriod = false;
        int i = this.findFirstInterruptionEnd();
        while (i < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(i);
            if (activite.getDescription().equals("CONDUITE")) {
                pendingPeriod = true;
                if ((dureeConduite += activite.getDuree()) > this.minor.getThreshold() && !infractionTrouve) {
                    infractionTrouve = true;
                    dateInfraction = activite.getDateJour();
                    hour = activite.getHeureFin() - (dureeConduite - this.minor.getThreshold());
                }
                ++i;
                continue;
            }
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int dureeRepos = this.restLength(i);
                i = this.endRestIndex(i);
                if (!pendingPeriod) continue;
                if (!minimum && dureeRepos >= this.firstInterruption) {
                    dureeInterruption += dureeRepos;
                    minimum = true;
                } else if (dureeRepos >= this.secondInterruption) {
                    dureeInterruption += dureeRepos;
                }
                if (dureeInterruption < this.interruption) continue;
                if (infractionTrouve) {
                    int type = 1;
                    int cost = this.minor.getInfrigement();
                    if (dureeConduite > this.verySerious.getThreshold()) {
                        type = 3;
                        cost = this.serious.getInfrigement();
                    } else if (dureeConduite > this.serious.getThreshold()) {
                        type = 2;
                        cost = this.serious.getInfrigement();
                    }
                    TimsLogger.verbose("#ContinuousDrive.checkOffence() add offence => " + dateInfraction + " : " + hour);
                    this.parent.addInfraction(dateInfraction, hour, this.getOffencePart("offence.basic").getId(), dureeConduite, type, cost);
                    this.parent.addInfraction(dateInfraction, hour, this.getOffencePart("offence.basic").getId(), dureeInterruption - dureeRepos, 0, 0);
                }
                dureeConduite = 0;
                dureeInterruption = 0;
                infractionTrouve = false;
                minimum = false;
                pendingPeriod = false;
                continue;
            }
            ++i;
        }
    }

    public int findFirstInterruptionEnd() {
        int dureeInterruption = 0;
        boolean minimum = false;
        int i = 0;
        while (i < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(i);
            try {
                if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                    int dureeRepos = 0;
                    while (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                        dureeRepos += activite.getDuree();
                        if (++i == this.activities.size()) break;
                        activite = (ActiviteConducteur)this.activities.get(i);
                    }
                    if (!minimum && dureeRepos >= this.firstInterruption) {
                        dureeInterruption += dureeRepos;
                        minimum = true;
                    } else if (dureeRepos >= this.secondInterruption) {
                        dureeInterruption += dureeRepos;
                    }
                    if (dureeInterruption < this.interruption) continue;
                    return i;
                }
                ++i;
            }
            catch (Exception ex) {
                System.err.println("#ContinuousDrive.findFirstInterruptionEnd# unable to find TypeActivite " + ((ActiviteConducteur)this.activities.get(i)).getCleType());
                if (Transport.debug < 1) continue;
                ex.printStackTrace();
            }
        }
        return this.activities.size();
    }
}

