/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class ContinuousWork
extends MasterOffence {
    private OffenceThreshold minor1 = null;
    private int interruption1 = 0;
    private OffenceThreshold minor2 = null;
    private int interruption2 = 0;
    private int interruption = 0;
    private int TELimite1 = 0;
    private int ReposMini1 = 0;
    private int TELimite2 = 0;
    private int ReposMini2 = 0;
    private int coupureMiniTE = 0;
    private int indexActiviteCourante = 0;

    @Override
    public void process() {
        this.minor1 = Fonctions.getOffenceThreshold(this.offence, "offence.firstRow", "offence.threshold.minor");
        this.interruption1 = Fonctions.getOffenceThreshold(this.offence, "offence.firstRow", "offence.interruption").getThreshold();
        this.minor2 = Fonctions.getOffenceThreshold(this.offence, "offence.secondRow", "offence.threshold.minor");
        this.interruption2 = Fonctions.getOffenceThreshold(this.offence, "offence.secondRow", "offence.interruption").getThreshold();
        this.interruption = Fonctions.getOffenceThreshold(this.offence, "offence.secondRow", "offence.threshold.firstInterruption").getThreshold();
        this.findFirstRest();
        this.dayProcess();
    }

    public void findFirstRest() {
        while (this.indexActiviteCourante < this.activities.size()) {
            block4: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                TypeActivite act = null;
                try {
                    act = TypeActivite.getActivityType(activite.getCleType());
                }
                catch (Exception ex) {
                    System.err.println("#DailyWork.process# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug >= 1) {
                        ex.printStackTrace();
                    }
                    break block4;
                }
                if (act.isRest() && this.restLength() > DAILY_REST_THRESHOLD) break;
            }
            ++this.indexActiviteCourante;
        }
    }

    public int restLength() {
        int restLength = 0;
        TypeActivite act = null;
        while (this.indexActiviteCourante <= this.activities.size() - 1) {
            try {
                act = TypeActivite.getActivityType(((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getCleType());
            }
            catch (Exception ex) {
                System.err.println("#DailyWork.process# unable to find TypeActivite " + ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getCleType());
                if (Transport.debug < 1) break;
                ex.printStackTrace();
                break;
            }
            if (!act.isRest()) break;
            restLength += ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getDuree();
            ++this.indexActiviteCourante;
        }
        return restLength;
    }

    public void dayProcess() {
        int totalInterruptionTime = 0;
        int totalWorkTime = 0;
        int uninterruptedWorkTime = 0;
        ActiviteConducteur first = null;
        while (this.indexActiviteCourante < this.activities.size()) {
            block18: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                TypeActivite act = null;
                try {
                    act = TypeActivite.getActivityType(activite.getCleType());
                }
                catch (Exception ex) {
                    System.err.println("#DailyWork.process# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug >= 1) {
                        ex.printStackTrace();
                    }
                    break block18;
                }
                if (Fonctions.isActiv(act.getCle())) {
                    if (first == null) {
                        TimsLogger.debug("#ContinuousWork.dayProcess() new at " + activite.getDateJour());
                        first = activite;
                    }
                    TimsLogger.debug("#ContinuousWork.dayProcess() +" + activite.getDuree() + " (" + (totalWorkTime += activite.getDuree()) + " " + (uninterruptedWorkTime += activite.getDuree()) + ")");
                } else if (act.isRest()) {
                    int restTime = this.restLength(this.indexActiviteCourante);
                    while (this.indexActiviteCourante < this.activities.size() && ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).isRest()) {
                        ++this.indexActiviteCourante;
                    }
                    --this.indexActiviteCourante;
                    if (restTime >= this.interruption) {
                        if (restTime >= this.interruption && restTime < DAILY_REST_THRESHOLD) {
                            TimsLogger.debug("#ContinuousWork.dayProcess() RAZ interruption " + restTime);
                            totalInterruptionTime += restTime;
                            if (uninterruptedWorkTime > this.minor1.getThreshold()) {
                                TimsLogger.debug("#ContinuousWork.dayProcess() add continuousWork offence => " + activite.getDateJour() + " : " + (activite.getHeureFin() - (uninterruptedWorkTime - this.minor1.getThreshold())));
                                String date = activite.getDateJour();
                                int exceedingWork = uninterruptedWorkTime - this.minor1.getThreshold();
                                int hour = activite.getHeureDebut() - exceedingWork;
                                if (hour < 0) {
                                    hour += 1440;
                                    date = ConversionTime.addHeureBDD(date, -24);
                                }
                                this.parent.addInfraction(date, hour, this.getOffencePart("offence.firstRow").getId(), uninterruptedWorkTime, 1, this.minor1.getInfrigement());
                            }
                            uninterruptedWorkTime = 0;
                        }
                        if (restTime >= DAILY_REST_THRESHOLD) {
                            TimsLogger.debug("#ContinuousWork.checkOffence() RAZ day : totalWorkTime " + totalWorkTime + " " + totalInterruptionTime);
                            if (totalWorkTime > this.minor2.getThreshold()) {
                                if (totalInterruptionTime < this.interruption2) {
                                    TimsLogger.debug("#ContinuousWork.dayProcess() add totalWork offence 2 (" + this.minor2.getThreshold() + ") => " + first.getDateJour() + " : " + first.getHeureDebut());
                                    this.parent.addInfraction(first.getDateJour(), first.getHeureDebut(), this.getOffencePart("offence.secondRow").getId(), totalWorkTime, 1, this.minor2.getThreshold());
                                    this.parent.addInfraction(first.getDateJour(), first.getHeureDebut(), this.getOffencePart("offence.secondRow").getId(), totalInterruptionTime, 0, 0);
                                }
                            } else if (totalWorkTime > this.minor1.getThreshold() && totalInterruptionTime < this.interruption1) {
                                TimsLogger.debug("#ContinuousWork.dayProcess() add offence 1 (" + this.minor1.getThreshold() + ")  => " + first.getDateJour() + " : " + first.getHeureDebut());
                                this.parent.addInfraction(first.getDateJour(), first.getHeureDebut(), this.getOffencePart("offence.firstRow").getId(), totalWorkTime, 1, this.minor1.getThreshold());
                                this.parent.addInfraction(first.getDateJour(), first.getHeureDebut(), this.getOffencePart("offence.firstRow").getId(), totalInterruptionTime, 0, 0);
                            }
                            totalInterruptionTime = 0;
                            totalWorkTime = 0;
                            uninterruptedWorkTime = 0;
                            first = null;
                        }
                    }
                }
            }
            ++this.indexActiviteCourante;
        }
    }
}

