/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.GNSSPlace;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class DailyDrive
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold serious = null;
    private OffenceThreshold verySerious = null;
    private OffenceThreshold tolerateMinor = null;
    private OffenceThreshold tolerateSerious = null;
    private OffenceThreshold tolerateVerySerious = null;
    private int tolerateDayCount = 0;
    private int indexActiviteCourante = 0;
    Vector<Integer> driving = null;
    Vector<String> date = null;
    Vector<Integer> hours = null;
    Vector<Integer> rest = null;

    @Override
    public void process() throws Exception {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.dd.unextended", "offence.threshold.minor");
        this.serious = Fonctions.getOffenceThreshold(this.offence, "offence.dd.unextended", "offence.threshold.serious");
        this.verySerious = Fonctions.getOffenceThreshold(this.offence, "offence.dd.unextended", "offence.threshold.verySerious");
        this.tolerateMinor = Fonctions.getOffenceThreshold(this.offence, "offence.dd.extended", "offence.threshold.minor");
        this.tolerateSerious = Fonctions.getOffenceThreshold(this.offence, "offence.dd.extended", "offence.threshold.serious");
        this.tolerateVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.dd.extended", "offence.threshold.verySerious");
        this.tolerateDayCount = Fonctions.getOffenceThreshold(this.offence, "offence.dd.extended", "offence.threshold.dayCount").getThreshold();
        this.findFirstRest();
        this.dayProcess();
        this.checkOffence();
    }

    public void findFirstRest() throws Exception {
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int rest = this.restLength(this.indexActiviteCourante);
                this.indexActiviteCourante = this.endRestIndex(this.indexActiviteCourante);
                if (rest > DAILY_REST_THRESHOLD) break;
            }
            ++this.indexActiviteCourante;
        }
    }

    public void dayProcess() throws Exception {
        this.driving = new Vector();
        this.date = new Vector();
        this.hours = new Vector();
        this.rest = new Vector();
        String sJour = "";
        String sHeure = "";
        int dureeConduite = 0;
        int hour = 0;
        boolean initialized = false;
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if (activite.getDescription().equals("CONDUITE")) {
                if (!initialized) {
                    sJour = activite.getDateJour();
                    hour = activite.getHeureDebut();
                    initialized = true;
                }
                dureeConduite += activite.getDuree();
            }
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int repos = this.restLength(this.indexActiviteCourante);
                this.indexActiviteCourante = this.endRestIndex(this.indexActiviteCourante) - 1;
                if (repos >= DAILY_REST_THRESHOLD || this.indexActiviteCourante == this.activities.size() - 1) {
                    this.driving.add(dureeConduite);
                    this.date.add(sJour);
                    this.hours.add(hour);
                    this.rest.add(repos);
                    dureeConduite = 0;
                    initialized = false;
                }
            }
            ++this.indexActiviteCourante;
        }
    }

    public void checkOffence() throws Exception {
        int nbJoursTolere = 0;
        int semaineEnCours = 0;
        int i = 0;
        while (i < this.driving.size()) {
            String day = this.date.get(i);
            int tempsTotalConduite = this.driving.get(i);
            int hour = this.hours.get(i);
            TimsLogger.verbose("#DailyDrive.checkOffence() => #" + day + " " + hour + "==> C = " + tempsTotalConduite);
            int semaine = ConversionTime.getWeek(day, "yyyy-MM-dd");
            if (semaine != semaineEnCours) {
                semaineEnCours = semaine;
                nbJoursTolere = 0;
            }
            if (tempsTotalConduite > this.minor.getThreshold()) {
                if (tempsTotalConduite < this.minor.getThreshold() + 60 && this.rest.get(i) > 1440) {
                    Agence agency = Agence.find(null, this.parent.driver.getCleAgence());
                    if (agency != null) {
                        float lat = agency.getLatitude();
                        float lon = agency.getLatitude();
                        Date dDay = ConversionTime.stringToDateDb(String.valueOf(day) + " HH:mm:ss");
                        ArrayList<GNSSPlace> places = GNSSPlace.getGnssDriverPlaces(this.parent.driver.getCle(), dDay, dDay);
                        if (places.size() == 0) {
                            TimsLogger.debug("unable to find location");
                        } else {
                            GNSSPlace toCompare = places.get(places.size() - 1);
                            float lastLat = toCompare.getLatitude();
                            float lastLon = toCompare.getLongitude();
                            int distance = Fonctions.getDistanceBetweenGnssPosition(lat, lon, lastLat, lastLon);
                            TimsLogger.debug("#DailyDrive.compare#(" + lat + "," + lon + ") to (" + lastLat + "," + lastLon + ") =>" + distance);
                        }
                    } else {
                        TimsLogger.warn("#DailyDriver.checkOffence# Agency not found " + this.parent.driver.getCleAgence());
                    }
                }
                if (tempsTotalConduite < this.tolerateMinor.getThreshold() || nbJoursTolere >= this.tolerateDayCount) {
                    TimsLogger.verbose("#DailyDrive.checkOffence() => #" + nbJoursTolere + " : " + this.tolerateDayCount);
                    if (++nbJoursTolere >= this.tolerateDayCount + 1) {
                        int type = 1;
                        int cost = 0;
                        if (tempsTotalConduite > this.verySerious.getThreshold()) {
                            cost = this.verySerious.getInfrigement();
                            type = 3;
                        } else if (tempsTotalConduite > this.serious.getThreshold()) {
                            cost = this.serious.getInfrigement();
                            type = 2;
                        } else {
                            cost = this.minor.getInfrigement();
                        }
                        TimsLogger.verbose("#DailyDrive.checkOffence() add offence => " + day + " : " + hour);
                        this.parent.addInfraction(day, hour, this.getOffencePart("offence.dd.unextended").getId(), tempsTotalConduite, type, cost);
                    }
                } else {
                    ++nbJoursTolere;
                    int type = 1;
                    int cost = 0;
                    if (tempsTotalConduite > this.tolerateVerySerious.getThreshold()) {
                        cost = this.tolerateVerySerious.getInfrigement();
                        type = 3;
                    } else if (tempsTotalConduite > this.tolerateSerious.getThreshold()) {
                        cost = this.tolerateSerious.getInfrigement();
                        type = 2;
                    } else {
                        cost = this.tolerateMinor.getInfrigement();
                    }
                    TimsLogger.verbose("#DailyDrive.checkOffence() add offence => " + day + " : " + hour);
                    this.parent.addInfraction(day, hour, this.getOffencePart("offence.dd.extended").getId(), tempsTotalConduite, type, cost);
                }
            }
            ++i;
        }
    }
}

