/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import java.util.Hashtable;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transport.offence.CalculInfractionPrincipal;

public class ReposHebdomadaire {
    private int fullRH = 0;
    private int reduceRH = 0;
    private int nbAct;
    private Vector<ActiviteConducteur> calculActivite;
    private Hashtable<String, String[]> tableauJour;
    private CalculInfractionPrincipal pere = null;

    public ReposHebdomadaire(CalculInfractionPrincipal source) {
        this.recupererSeuil();
        this.pere = source;
    }

    public ReposHebdomadaire(Vector<ActiviteConducteur> act, CalculInfractionPrincipal source) {
        this.recupererSeuil();
        this.pere = source;
        this.calculActivite = act;
        this.nbAct = this.calculActivite.size();
        this.tableauJour = new Hashtable();
    }

    public void setActiviteConducteur(Vector<ActiviteConducteur> act) {
        this.calculActivite = act;
        this.nbAct = this.calculActivite.size();
        this.tableauJour = new Hashtable();
    }

    public void recupererSeuil() {
        try {
            Vector<Integer> seuils = Transport.bdd.getSeuilReposHebdomadaire();
            this.fullRH = seuils.get(0);
            this.reduceRH = seuils.get(1);
        }
        catch (Exception ex) {
            TimsLogger.warn("Impossible de r\u00e9cup\u00e9rer les seuils de l'infraction (Repos hebdomadaire).");
        }
    }

    public int endRestIndex(int offsetRestBegin) {
        while (offsetRestBegin < this.nbAct && (this.calculActivite.get(offsetRestBegin).getDescription().equals("REPOS") || this.calculActivite.get(offsetRestBegin).getDescription().equals("INCONNU"))) {
            ++offsetRestBegin;
        }
        return offsetRestBegin;
    }

    public int restLength(int offsetWeeklyRestBegin) {
        int toReturn = 0;
        ActiviteConducteur activite = this.calculActivite.get(offsetWeeklyRestBegin);
        try {
            while (offsetWeeklyRestBegin < this.nbAct - 1 && (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU"))) {
                toReturn += activite.getDuree();
                activite = this.calculActivite.get(++offsetWeeklyRestBegin);
            }
            if (offsetWeeklyRestBegin == this.nbAct && (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU"))) {
                toReturn += activite.getDuree();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public void start() throws Exception {
        int x = 0;
        while (x < this.nbAct) {
            ActiviteConducteur activite = this.calculActivite.get(x);
            if (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) {
                if (this.getRestType(this.restLength(x)) == 3) break;
                x = this.endRestIndex(x);
            }
            ++x;
        }
        if (x >= this.nbAct - 1) {
            TimsLogger.debug("Aucune p\u00e9riode de repos hebdomadaire n'a \u00e9t\u00e9 trouv\u00e9");
        } else {
            TimsLogger.debug("#RH# start at " + this.calculActivite.get(x).getDateJour() + " " + this.calculActivite.get(x).getHeureDebut());
            this.checkOffence(x);
        }
    }

    public void checkOffence(int offsetWeeklyRestBegin) throws Exception {
        boolean isReduct = false;
        int weeklyRest = this.restLength(offsetWeeklyRestBegin);
        TimsLogger.debug("#RH.checkOffense()# new RH at " + this.calculActivite.get(offsetWeeklyRestBegin).getDateJour() + " " + this.calculActivite.get(offsetWeeklyRestBegin).getHeureDebut() + " (" + offsetWeeklyRestBegin + ") = " + weeklyRest);
        offsetWeeklyRestBegin = this.endRestIndex(offsetWeeklyRestBegin);
        ActiviteConducteur activite = this.calculActivite.get(offsetWeeklyRestBegin);
        String dateDebut = activite.getDateJour();
        String dateLimite = ConversionTime.addDay(activite.getDateJour(), "yyyy-MM-dd", 6);
        int heureLimite = activite.getHeureDebut();
        activite = this.calculActivite.get(offsetWeeklyRestBegin);
        if (weeklyRest < this.fullRH) {
            TimsLogger.debug("#RH.checkOffense()# Repos r\u00e9duit");
            isReduct = true;
        }
        int maxWeeklyRest = 0;
        int offsetMaxWeeklyRest = 0;
        TimsLogger.debug("#RH.checkOffense()# On calcul le prochain RH \u00e0 partir de (" + offsetWeeklyRestBegin + ") " + this.calculActivite.get(offsetWeeklyRestBegin).getDateJour() + " " + this.calculActivite.get(offsetWeeklyRestBegin).getHeureDebut());
        while (offsetWeeklyRestBegin < this.nbAct - 1) {
            try {
                if (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) {
                    int rest = this.restLength(offsetWeeklyRestBegin);
                    TimsLogger.debug("#RH.checkOffense()# Rest detected on " + activite.getDateJour() + " " + activite.getHeureDebut() + " length = " + rest + ". Replace ? " + (rest > maxWeeklyRest) + " || " + (this.getRestType(rest) >= 2) + " && " + (this.getRestType(rest) == maxWeeklyRest));
                    if (rest > maxWeeklyRest || this.getRestType(rest) >= 2 && this.getRestType(rest) == this.getRestType(maxWeeklyRest)) {
                        maxWeeklyRest = rest;
                        offsetMaxWeeklyRest = offsetWeeklyRestBegin;
                    }
                    offsetWeeklyRestBegin = this.endRestIndex(offsetWeeklyRestBegin);
                } else {
                    ++offsetWeeklyRestBegin;
                }
                if (offsetWeeklyRestBegin >= this.nbAct - 1) {
                    TimsLogger.debug("#RH.checkOffense()# Last activity reached. stop. Calculation");
                    return;
                }
                activite = this.calculActivite.get(offsetWeeklyRestBegin);
                if (activite.getDateJour().substring(0, 10).compareTo(dateLimite) < 0 || activite.getHeureFin() < heureLimite && activite.getDateJour().substring(0, 10).compareTo(dateLimite) <= 0) continue;
                TimsLogger.debug("#RH.checkOffense()# End period : on est au " + activite.getDateJour() + " " + activite.getHeureDebut() + " maxRest = " + maxWeeklyRest + " since " + this.calculActivite.get(offsetMaxWeeklyRest).getDateJour() + " " + this.calculActivite.get(offsetMaxWeeklyRest).getHeureDebut());
                TimsLogger.debug("#RH.checkOffense()# End period : offsetWeeklyRestBegin = " + offsetWeeklyRestBegin + " of " + this.nbAct);
                if (this.getRestType(maxWeeklyRest) != 3 && this.getRestType(maxWeeklyRest) != 2) {
                    TimsLogger.debug("#RH.checkOffense()# NO RH FOUND. GENERATING INFRACTION");
                    offsetMaxWeeklyRest = this.findNextWeeklyRest(offsetWeeklyRestBegin);
                } else if (isReduct && this.getRestType(maxWeeklyRest) == 2) {
                    TimsLogger.debug("#RH.checkOffense()# 2 REDUCED RH FOUND. GENERATING INFRACTION");
                }
                TimsLogger.debug("#RH.checkOffense()# on lance un nouveau calcul \u00e0 l'offset " + offsetMaxWeeklyRest);
                this.checkOffence(offsetMaxWeeklyRest);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getRestType(int length) {
        if (length > 420 && length <= this.reduceRH) {
            return 1;
        }
        if (length > this.reduceRH) {
            if (length < this.fullRH) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public int findNextWeeklyRest(int offsetSearchBegin) throws Exception {
        while (offsetSearchBegin < this.nbAct) {
            ActiviteConducteur activite = this.calculActivite.get(offsetSearchBegin);
            if ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.getRestType(this.restLength(offsetSearchBegin)) == 3) break;
            ++offsetSearchBegin;
        }
        return offsetSearchBegin;
    }
}

