/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class WeeklyDrive
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold serious = null;
    private OffenceThreshold verySerious = null;
    private OffenceThreshold biMinor = null;
    private OffenceThreshold biSerious = null;
    private OffenceThreshold biVerySerious = null;
    private Vector<Integer> weeklyDrive;
    private Vector<String> jour;

    @Override
    public void process() throws Exception {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.minor");
        this.serious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.serious");
        this.verySerious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.verySerious");
        this.biMinor = Fonctions.getOffenceThreshold(this.offence, "offence.double", "offence.threshold.minor");
        this.biSerious = Fonctions.getOffenceThreshold(this.offence, "offence.double", "offence.threshold.serious");
        this.biVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.double", "offence.threshold.verySerious");
        int beginOffset = this.findFirstFullWeek();
        int driveTmp = 0;
        if (beginOffset == 0) {
            TimsLogger.debug("#WeeklyDriving.process()# no full week found");
        }
        this.weeklyDrive = new Vector();
        this.jour = new Vector();
        int currentWeek = ConversionTime.getWeek(((ActiviteConducteur)this.activities.get(beginOffset)).getDateJour(), "yyyy-MM-dd");
        this.jour.add(((ActiviteConducteur)this.activities.get(beginOffset)).getDateJour());
        int x = beginOffset;
        while (x < this.activities.size()) {
            ActiviteConducteur activity = (ActiviteConducteur)this.activities.get(x);
            int activityWeek = ConversionTime.getWeek(activity.getDateJour(), "yyyy-MM-dd");
            if (activityWeek != currentWeek) {
                this.weeklyDrive.add(driveTmp);
                driveTmp = 0;
                this.jour.add(activity.getDateJour());
                currentWeek = activityWeek;
            }
            if (TypeActivite.getActivityType(activity.getCleType()).getName().equals("CONDUITE")) {
                driveTmp += activity.getDuree();
            }
            ++x;
        }
        this.weeklyDrive.add(driveTmp);
        this.checkOffence();
    }

    public int findFirstFullWeek() {
        int x = 0;
        while (x < this.activities.size()) {
            if (ConversionTime.getDayOfWeek(((ActiviteConducteur)this.activities.get(x)).getDate(), false) == 2) {
                return x;
            }
            ++x;
        }
        return 0;
    }

    public void checkOffence() {
        int x = 0;
        while (x < this.jour.size()) {
            int cost;
            int type;
            if (this.weeklyDrive.get(x) > this.minor.getThreshold()) {
                type = 1;
                cost = this.minor.getInfrigement();
                if (this.weeklyDrive.get(x) > this.verySerious.getThreshold()) {
                    cost = this.verySerious.getInfrigement();
                    type = 3;
                } else if (this.weeklyDrive.get(x) > this.serious.getThreshold()) {
                    cost = this.serious.getInfrigement();
                    type = 2;
                }
                TimsLogger.verbose("#WeeklyDrive.checkOffence() add offence => " + this.jour.get(x) + " : 0");
                this.parent.addInfraction(this.jour.get(x), 0, this.getOffencePart("offence.basic").getId(), this.weeklyDrive.get(x), type, cost);
            }
            if (x != 0 && this.weeklyDrive.get(x) + this.weeklyDrive.get(x - 1) > this.biMinor.getThreshold()) {
                type = 1;
                cost = this.biMinor.getInfrigement();
                if (this.weeklyDrive.get(x) + this.weeklyDrive.get(x - 1) > this.biVerySerious.getThreshold()) {
                    cost = this.biVerySerious.getInfrigement();
                    type = 3;
                } else if (this.weeklyDrive.get(x) + this.weeklyDrive.get(x - 1) > this.biSerious.getThreshold()) {
                    cost = this.biSerious.getInfrigement();
                    type = 2;
                }
                int day = 8 - ConversionTime.getDayOfWeek(this.jour.get(x), "yyyy-MM-dd", false);
                String sDay = ConversionTime.addDay(this.jour.get(x), "yyyy-MM-dd", day);
                TimsLogger.verbose("#WeeklyDrive.checkOffence() add offence => " + sDay + " : 0");
                this.parent.addInfraction(sDay, 0, this.getOffencePart("offence.double").getId(), this.weeklyDrive.get(x) + this.weeklyDrive.get(x - 1), type, cost);
            }
            ++x;
        }
    }
}

