/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.jfree.data.category.DefaultCategoryDataset;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.DynamicGeneric;

public class AccidentGraphic
extends DynamicGeneric {
    private Collection<Map<String, ?>> data = null;
    private boolean cost = false;

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (report.getTranslationId().equals("accident-cost-graphic")) {
            this.userParameters.put("GRAPH_TITLE", LanguageTranslator.getString("accident.graphByCost"));
            this.userParameters.put("COST", 1);
            this.cost = true;
        } else {
            this.userParameters.put("GRAPH_TITLE", LanguageTranslator.getString("accident.graphByResponsability"));
            this.userParameters.put("COST", 0);
        }
    }

    @Override
    public void process() {
        this.data = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM yy");
        Vector<Accident> tmp = Accident.loadList(this.agencies.size() == 1 ? (Agence)this.agencies.get(0) : null, this.begin, this.end);
        this.userParameters.put("AGENCY", this.agencies.size() == 1 ? ((Agence)this.agencies.get(0)).getDescription() : LanguageTranslator.getString("generics.all"));
        this.userParameters.put("COMPANY", BddTransport.getInstance().getCompany().getNomSociete());
        TimsLogger.info("#AccidentGraphic# traitements de " + tmp.size() + " accidents");
        int count0 = 0;
        int count50 = 0;
        int count100 = 0;
        float cost = 0.0f;
        float insCost = 0.0f;
        String curMonth = null;
        DefaultCategoryDataset chartData = new DefaultCategoryDataset();
        for (Accident toAdd : tmp) {
            String accMonth = sdf.format(toAdd.getDay());
            if (!accMonth.equals(curMonth)) {
                if (curMonth != null) {
                    this.data.add(this.fillMap(curMonth, count0, count50, count100, cost, insCost));
                    if (!this.cost) {
                        chartData.addValue((double)count0, (Comparable)((Object)"0 %"), (Comparable)((Object)curMonth));
                        chartData.addValue((double)count50, (Comparable)((Object)"50 %"), (Comparable)((Object)curMonth));
                        chartData.addValue((double)count100, (Comparable)((Object)"100 %"), (Comparable)((Object)curMonth));
                    } else {
                        chartData.addValue((double)cost, (Comparable)((Object)LanguageTranslator.getString("generics.cost")), (Comparable)((Object)curMonth));
                        chartData.addValue((double)insCost, (Comparable)((Object)LanguageTranslator.getString("accident.totalInsurance")), (Comparable)((Object)curMonth));
                    }
                }
                curMonth = accMonth;
                count100 = 0;
                count50 = 0;
                count0 = 0;
                insCost = 0.0f;
                cost = 0.0f;
            }
            if (toAdd.getResponsability() == 0) {
                ++count0;
            } else if (toAdd.getResponsability() == 1) {
                ++count50;
            } else if (toAdd.getResponsability() == 2) {
                ++count100;
            }
            cost += toAdd.getTotalCost();
            insCost += toAdd.getTotalInsurance();
        }
        this.data.add(this.fillMap(curMonth, count0, count50, count100, cost, insCost));
        try {
            this.load(new JRMapCollectionDataSource(this.data), LanguageTranslator.getString("report.accident"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    private Map<String, ?> fillMap(String curMonth, int count0, int count50, int count100, float cost, float insCost) {
        HashMap<String, Object> accidentHM = new HashMap<String, Object>();
        accidentHM.put("MONTH", curMonth);
        accidentHM.put("0", count0);
        accidentHM.put("50", count50);
        accidentHM.put("100", count100);
        TimsLogger.debug("curMonth = " + curMonth + " count0 = " + count0 + " count50 = " + count50 + " count100 = " + count100 + " cost=" + cost + " insCost=" + insCost);
        accidentHM.put("COST", Float.valueOf(cost));
        accidentHM.put("INS_COST", Float.valueOf(insCost));
        return accidentHM;
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

