/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transport.report.MasterReport;

public class ActivityReport
extends MasterReport {
    private Collection<Map<String, ?>> data = null;

    public void retrieveData() {
        Vector<Conducteur> driverList = Conducteur.loadList(this.agencies.size() != 1 ? ((Agence)this.agencies.get(0)).getCleAgence() : 0);
        Vector<Service> tmpS = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        Conducteur currentDriver = null;
        for (Service s : tmpS) {
            if (currentDriver != null && s.getDriverId() == currentDriver.getCleConducteur()) continue;
            try {
                if (currentDriver != null) {
                    this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
                }
                this.data = new ArrayList();
                currentDriver = this.getDriver(driverList, s.getDriverId());
            }
            catch (DriverNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.data.add(this.fillMap(s));
        }
        this.generate();
    }

    public Map fillMap(Service s) {
        if (s == null) {
            return null;
        }
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Date debut = ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd HH:mm");
        tmp.put("DATE_DEBUT", debut);
        tmp.put("DATE_FIN", ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd HH:mm"));
        tmp.put("SEMAINE", ConversionTime.dateToString(debut, "w"));
        tmp.put("CONDUITE", s.getDriving());
        tmp.put("TRAVAIL", s.getWork());
        tmp.put("DISPO", s.getAvailability());
        tmp.put("DOUBLE_EQUIPAGE", s.getCrew());
        tmp.put("REPOS", s.getRest());
        tmp.put("INCONNU", s.getUnk());
        tmp.put("SERVICE", s.getService());
        tmp.put("AMPLITUDE", s.getAmplitude());
        tmp.put("DISTANCE", s.getDistance());
        tmp.put("HEURE_NUIT", s.getNight());
        return tmp;
    }

    public Conducteur getDriver(Vector driverList, int driverId) throws DriverNotFoundException {
        for (Conducteur tmp : driverList) {
            if (tmp.getCleConducteur() != driverId) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }
}

