/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.ConsumptionEval;
import fr.pgh.data.bdd.ConsumptionEvalCriteria;
import fr.pgh.data.bdd.ConsumptionMark;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class ConsumptionReport
extends DynamicGeneric {
    boolean alertMode = false;
    int REPORT_TARGET = 1;

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        this.alertMode = "1".equals(this.userParameters.get("ALERT"));
        this.REPORT_TARGET = this.userParameters.get("REPORT_TARGET") == null ? 1 : Integer.parseInt(this.userParameters.get("REPORT_TARGET").toString());
    }

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getConsumptionList(this.alertMode, this.REPORT_TARGET);
        this.customReport.setName(this.report.getCustomizedName());
        if (this.alertMode) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TEMPLATE", DJGenerator.LANDSCAPE_TEMPLATE);
            this.customReport.setProperties(map);
        }
        this.setGenerator(new DJGenerator());
        this.getGenerator().setWithTotal(false);
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        this.data = new ArrayList();
        switch (this.REPORT_TARGET) {
            case 1: {
                this.loadDriverData();
                break;
            }
            case 0: {
                this.loadAgencyData();
                break;
            }
            case 2: {
                this.loadVehicleData();
            }
        }
        try {
            this.print();
            this.load(new JRMapCollectionDataSource((Collection)this.data), LanguageTranslator.getString("report.consumption"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    private void loadVehicleData() {
        String unk = LanguageTranslator.getString("generics.unknown");
        for (Agence agency : this.agencies) {
            Vector<FuelConsumption> list = FuelConsumption.loadTotal(agency.getCleAgence(), 0, 0, this.begin, this.end, 2, -1);
            if (list == null) continue;
            for (FuelConsumption cons : list) {
                try {
                    Vehicule vehicle = Vehicule.getVehicule((Vector<Vehicule>)this.vehicles, cons.getVehicleId());
                    HashMap<String, Object> acc = new HashMap<String, Object>();
                    acc.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
                    acc.put(LanguageTranslator.getString("generics.vehicle"), vehicle == null ? unk : vehicle.getIdentificationNumber());
                    acc.put(LanguageTranslator.getString("generics.consumption"), Float.valueOf(cons.getLiters()));
                    acc.put(LanguageTranslator.getString("fuel.consumptionPer100"), Float.valueOf(cons.getConsumption()));
                    acc.put(LanguageTranslator.getString("generics.km"), Float.valueOf(cons.getKm()));
                    acc.put(LanguageTranslator.getString("generics.length"), cons.getLength());
                    this.data.add(acc);
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#ConsumptionReport.process()# Vehicle has not been found ");
                }
            }
        }
    }

    private void loadAgencyData() {
        String unk = LanguageTranslator.getString("generics.unknown");
        Vector<FuelConsumption> list = FuelConsumption.loadTotal(0, 0, 0, this.begin, this.end, 0, -1);
        if (list != null) {
            for (FuelConsumption cons : list) {
                Agence agency = Agence.find(this.agencies, cons.getAgencyId());
                HashMap<String, Object> acc = new HashMap<String, Object>();
                if (this.alertMode && (!this.alertMode || !(cons.getConsumption() > agency.getTargetConsumption()))) continue;
                acc.put(LanguageTranslator.getString("generics.agency"), agency == null ? unk : agency.getDescription());
                acc.put(LanguageTranslator.getString("generics.consumption"), Float.valueOf(cons.getLiters()));
                acc.put(LanguageTranslator.getString("fuel.consumptionPer100"), Float.valueOf(cons.getConsumption()));
                acc.put(LanguageTranslator.getString("generics.km"), Float.valueOf(cons.getKm()));
                acc.put(LanguageTranslator.getString("generics.length"), cons.getLength());
                this.data.add(acc);
            }
        }
    }

    private void loadDriverData() {
        String unk = LanguageTranslator.getString("generics.unknown");
        for (Agence agency : this.agencies) {
            Vector<FuelConsumption> list = FuelConsumption.loadTotal(agency.getCleAgence(), 0, 0, this.begin, this.end, 1, -1);
            if (list == null) continue;
            for (FuelConsumption cons : list) {
                try {
                    Conducteur driver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, cons.getDriverId());
                    if (this.alertMode && (!this.alertMode || !(cons.getConsumption() > driver.getTargetConsumption()))) continue;
                    HashMap<String, Object> acc = new HashMap<String, Object>();
                    acc.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
                    acc.put(LanguageTranslator.getString("generics.driver"), driver == null ? unk : String.valueOf(driver.getNom()) + " " + driver.getPrenom());
                    acc.put(LanguageTranslator.getString("generics.consumption"), Float.valueOf(cons.getLiters()));
                    acc.put(LanguageTranslator.getString("fuel.consumptionPer100"), Float.valueOf(cons.getConsumption()));
                    acc.put(LanguageTranslator.getString("generics.km"), Float.valueOf(cons.getKm()));
                    acc.put(LanguageTranslator.getString("generics.length"), cons.getLength());
                    if (this.alertMode) {
                        String alertCriteria = "";
                        for (ConsumptionMark tmp : ConsumptionMark.loadList(0, cons.getDriverId())) {
                            try {
                                ConsumptionEval ce = ConsumptionEval.get(null, tmp.getConsumptionEvalId());
                                ConsumptionEvalCriteria criteria = ConsumptionEvalCriteria.get(null, tmp.getCriteriaId());
                                if (ce.getPercentage() >= 40) continue;
                                alertCriteria = String.valueOf(alertCriteria) + ", " + criteria.getName();
                            }
                            catch (DBObjectNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        acc.put(LanguageTranslator.getString("consumption.badEval"), alertCriteria.length() < 2 ? LanguageTranslator.getString("generics.none") : alertCriteria.substring(2));
                    }
                    this.data.add(acc);
                }
                catch (DriverNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# Vehicle or Driver has not been found ");
                }
            }
        }
    }
}

