/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.EmployeeType;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.ContractNotFoundException;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class Controle
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;
    int workday = 0;

    @Override
    public void process() {
        this.workday = ConversionTime.getWorkday(this.begin, this.end);
        Vector<TypeContrat> contractList = TypeContrat.loadList();
        this.data = new ArrayList();
        boolean distribution = true;
        int workedTime = 0;
        int workedDay = 0;
        int firstRule = 0;
        int secondRule = 0;
        int thirdRule = 0;
        int fourstRule = 0;
        int driving = 0;
        int night = 0;
        int rest = 0;
        int coupure = 0;
        int altPaidHour = 0;
        int altGenerateHSHour = 0;
        int altDayCount = 0;
        this.pb.getBar().setMaximum(this.agencies.size() + this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            Vector<String> dayTypeOnly = new Vector<String>();
            this.pb.getBar().setString(currentAgency.getDescription());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            Vector<Service> tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Vector<LienJourConducteur> others = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Vector<GlobalCalendarDay> othersGlobal = null;
            Conducteur currentDriver = null;
            int defaultDayLength = 0;
            String employeeType = LanguageTranslator.getString("generics.unknown");
            TimsLogger.info("#Controle.process()# " + tmpS.size() + " services");
            if (tmpS.size() == 0) continue;
            for (Service s : tmpS) {
                if (currentDriver == null || s.getDriverId() != currentDriver.getCleConducteur()) {
                    if (currentDriver != null) {
                        try {
                            TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                            this.data.add(this.fillMap(currentDriver, contrat, workedDay, workedTime, driving, rest, coupure, night, firstRule, secondRule, thirdRule, fourstRule, altPaidHour, altGenerateHSHour, distribution, employeeType, currentAgency));
                        }
                        catch (ContractNotFoundException ex) {
                            TimsLogger.warn("No contract for " + currentDriver.getCleTypeContrat() + " (" + currentDriver.getNom() + ")");
                        }
                    }
                    workedTime = 0;
                    workedDay = 0;
                    firstRule = 0;
                    secondRule = 0;
                    thirdRule = 0;
                    fourstRule = 0;
                    driving = 0;
                    night = 0;
                    rest = 0;
                    coupure = 0;
                    altPaidHour = 0;
                    altGenerateHSHour = 0;
                    altDayCount = 0;
                    dayTypeOnly.clear();
                    try {
                        currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, s.getDriverId());
                        othersGlobal = currentDriver.getCalendarId() != 0 ? GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end) : null;
                        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                            try {
                                TypeContrat driverContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                                defaultDayLength = driverContract.getDailyValue();
                            }
                            catch (TypeContratNotFoundException ex) {
                                TimsLogger.warn("Contrat " + currentDriver.getCleTypeContrat() + " introuvable pour " + currentDriver.getNom());
                            }
                        }
                        employeeType = LanguageTranslator.getString("generics.unknown");
                        try {
                            employeeType = EmployeeType.get(currentDriver.getCleTypePersonnel()).getName();
                        }
                        catch (DBObjectNotFoundException ex) {
                            TimsLogger.warn("No employee type for " + currentDriver.getCleTypePersonnel() + " (" + currentDriver.getNom() + ")");
                        }
                    }
                    catch (DriverNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    TimsLogger.debug(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getNightDay());
                    this.pb.getBar().setString(String.valueOf(currentAgency.getDescription()) + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    for (LienJourConducteur tmp : others) {
                        int day;
                        JourType dayType = tmp.getDayType();
                        boolean shouldPay = dayType.shouldPay(currentDriver, tmp.getDateJour());
                        if (tmp.getCleConducteur() != currentDriver.getCleConducteur()) continue;
                        if (dayType.isPaid() && shouldPay) {
                            altPaidHour += tmp.getDuree(defaultDayLength);
                        }
                        if (dayType.isGenerateHS() && shouldPay) {
                            altGenerateHSHour += tmp.getDuree(defaultDayLength);
                        }
                        if (tmp.getType() == 2) {
                            day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false);
                            if (day != 7 && day != 1) {
                                ++altDayCount;
                            }
                        } else if (tmp.getType() == 1 && LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() > 1 && (day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false)) != 7 && day != 1) {
                            ++altDayCount;
                        }
                        if (!dayType.isServiceIncluded() || tmp.getType() != 2 && (!System.getProperty("company", "PGH").equals("salvesen") || tmp.getDuree(defaultDayLength) < 420)) continue;
                        TimsLogger.debug("#Distribution.process# no service possible on " + tmp.getDateJour());
                        dayTypeOnly.add(ConversionTime.dateToString(tmp.getDateJour(), "yyyy-MM-dd"));
                    }
                    if (othersGlobal != null) {
                        for (GlobalCalendarDay toAdd : othersGlobal) {
                            int day;
                            LienJourConducteur tmp = new LienJourConducteur();
                            tmp.setValues(-1, currentDriver.getCleConducteur(), toAdd.getDayTypeId(), 0, toAdd.getDate(), 0, 0, 2);
                            JourType dayType = tmp.getDayType();
                            boolean shouldPay = dayType.shouldPay(currentDriver, tmp.getDateJour());
                            if (dayType.isPaid() && shouldPay) {
                                altPaidHour += tmp.getDuree(defaultDayLength);
                            }
                            if (dayType.isGenerateHS() && shouldPay) {
                                altGenerateHSHour += tmp.getDuree(defaultDayLength);
                            }
                            if (tmp.getType() == 2) {
                                day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false);
                                if (day != 7 && day != 1) {
                                    ++altDayCount;
                                }
                            } else if (tmp.getType() == 1 && LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() > 1 && (day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false)) != 7 && day != 1) {
                                ++altDayCount;
                            }
                            if (!dayType.isServiceIncluded() || tmp.getType() != 2 && (!System.getProperty("company", "PGH").equals("salvesen") || tmp.getDuree(defaultDayLength) < 420)) continue;
                            TimsLogger.debug("#Distribution.process# no service possible on " + tmp.getDateJour());
                            dayTypeOnly.add(ConversionTime.dateToString(tmp.getDateJour(), "yyyy-MM-dd"));
                        }
                    }
                }
                if (currentDriver.getNightDay() == 0 && ConversionTime.getNbJourBetween(s.getBeginDate().substring(0, 10), s.getEndDate().substring(0, 10), "yyyy-MM-dd") >= 1 || currentDriver.getNightDay() == 2) {
                    distribution = false;
                }
                if (dayTypeOnly.contains(s.getBeginDate().substring(0, 10))) {
                    TimsLogger.debug("#Distribution.process# Unauthorized service on " + s.getBeginDate());
                    continue;
                }
                rest += s.getRest();
                driving += s.getDriving();
                night += s.getNight();
                coupure += s.getCut();
                workedTime += s.getService();
                ++workedDay;
                workedDay += ConversionTime.getNbJourBetween(s.getBeginDate(), s.getEndDate(), "yyyy-MM-dd HH:mm:ss");
                firstRule += s.getFirstWork();
                secondRule += s.getLastWork();
                thirdRule += s.getFirstWorkAfterRest();
                fourstRule += s.getSecondWorkAfterRest();
            }
            try {
                TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                this.data.add(this.fillMap(currentDriver, contrat, workedDay, workedTime, driving, rest, coupure, night, firstRule, secondRule, thirdRule, fourstRule, altPaidHour, altGenerateHSHour, distribution, employeeType, currentAgency));
            }
            catch (ContractNotFoundException ex) {
                TimsLogger.warn("Contrat non trouv\u00e9 " + currentDriver.getCleTypeContrat());
            }
        }
        try {
            this.load(new JRMapCollectionDataSource(this.data), this.report.getCustomizedName());
            this.data.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Conducteur driver, TypeContrat contract, int workedDay, int workedTime, int driving, int rest, int coupure, int night, int firstRule, int secondRule, int thirdRule, int fourstRule, int altPaidHour, int altGenerateHSHour, boolean distribution, String employeeType, Agence agency) {
        TimsLogger.debug(String.valueOf(driver.getNom()) + " worked day = " + workedDay + ", workedTime=" + workedTime + ", night=" + night + ", altPaidHour=" + altPaidHour + ", altGenerateHSHour=" + altGenerateHSHour + ", firstRule=" + firstRule + ", secondRule=" + secondRule + ", thirdRule=" + thirdRule + ", fourstRule=" + fourstRule);
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        int baseHS = workedTime + altGenerateHSHour;
        int hs25 = 0;
        int hs50 = 0;
        if (baseHS > contract.getSeuilHS25(2)) {
            hs50 = baseHS - contract.getSeuilHS25(2);
            hs25 = contract.getSeuilHS25(2) - contract.getSeuilHN(2);
        } else if (baseHS > contract.getSeuilHN(2)) {
            hs25 = baseHS - contract.getSeuilHN(2);
        }
        tmp.put("AGENCY", agency.getDescription());
        tmp.put("FIRST_NAME", driver.getPrenom());
        tmp.put("LAST_NAME", driver.getNom());
        tmp.put("MATRICULE", driver.getMatricule());
        tmp.put("WORKED_DAY", workedDay);
        tmp.put("DAY_PERIOD", this.workday);
        tmp.put("WORKED_TIME", workedTime);
        tmp.put("PAID_TIME", workedTime + altPaidHour);
        tmp.put("CONTRACT_TIME", contract.getContractHour());
        tmp.put("HS25", hs25);
        tmp.put("HS50", hs50);
        tmp.put("MAXIMUM", workedTime + altPaidHour > contract.getMaximumHour() ? "O" : "N");
        tmp.put("FIRST_RULE", workedDay != 0 ? firstRule / workedDay : 0);
        tmp.put("SECOND_RULE", workedDay != 0 ? secondRule / workedDay : 0);
        tmp.put("THIRD_RULE", workedDay != 0 ? thirdRule / workedDay : 0);
        tmp.put("FOURST_RULE", workedDay != 0 ? fourstRule / workedDay : 0);
        tmp.put("DRIVING", driving);
        tmp.put("COUPURE", workedDay != 0 ? coupure / workedDay : 0);
        tmp.put("REST", rest);
        tmp.put("NIGHT", night);
        tmp.put("TYPE", distribution ? "DISTRIBUTION" : "TRACTION");
        tmp.put("EMPLOYEE_TYPE", employeeType);
        tmp.put("ALT_PAID_HOUR", altPaidHour);
        return tmp;
    }
}

