/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.MasterReport;
import transport.report.generator.DJGenerator;

public class CustomHourExporterC01
extends DynamicGeneric {
    public static final String EXPORT_FILE = "heures.txt";
    private static final int TIME = 0;
    private static final int COUNT = 1;
    private PrintWriter file = null;
    private DecimalFormat df = null;
    private String destinationPath = System.getProperty("export_default_path");
    private Collection<Map<String, ?>> data = null;
    private Vector<Region> regions = null;
    private int avgValue = -1;

    public CustomHourExporterC01() {
        if (this.destinationPath == null || this.destinationPath.equals("") || !new File(this.destinationPath).exists()) {
            MasterReport.GetFile tmp = new MasterReport.GetFile(this, EXPORT_FILE);
            if (SwingUtilities.isEventDispatchThread()) {
                tmp.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(tmp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.destinationPath = tmp.getCheminSave();
        }
        this.df = new DecimalFormat("##0.000");
        DecimalFormatSymbols f = this.df.getDecimalFormatSymbols();
        f.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(f);
        CustomReport cr = this.getCR();
        this.setCustomReport(cr);
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(cr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process() throws Exception {
        this.regions = Region.loadList(0);
        this.userParameters.put("TITLE", this.getCustomReport().getName());
        this.getGenerator().prebuild();
        try {
            this.file = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(this.destinationPath) + "\\" + "heures.txt", false)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            toProcess = this.drivers.size() == 1 ? this.drivers : Conducteur.loadListWithArchive(new Integer[]{currentAgency.getCleAgence()});
            this.data = new ArrayList<Map<String, ?>>();
            tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            tmpL = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            tmpE = DriverExpenses.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            TimsLogger.info("#CustomHourExporter.process()# " + tmpS.size() + " services, " + tmpL.size() + " jours, " + tmpE.size() + " frais, " + this.drivers.size() + " conducteurs (" + toProcess.size() + " avec archive)");
            currentContract = null;
            defaultDayLength = 0;
            x = 0;
            while (x < this.drivers.size()) {
                block63: {
                    block61: {
                        block62: {
                            if (((Conducteur)this.drivers.get(x)).getCleAgence() == currentAgency.getCleAgence()) break block62;
                            while (tmpS.size() != 0 && tmpS.get(0).getDriverId() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpS.remove(0);
                            }
                            while (tmpL.size() != 0 && tmpL.get(0).getCleConducteur() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpL.remove(0);
                            }
                            while (tmpE.size() != 0 && tmpE.get(0).getDriverId() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpE.remove(0);
                            }
                            break block63;
                        }
                        workedTime = 0;
                        workedDay = 0;
                        altPaidHour = 0;
                        altGenerateHSHour = 0;
                        altGenerateRCHour = 0;
                        altDayCount = 0;
                        cumul4Night = 0;
                        driving = 0;
                        availability = false;
                        work = 0;
                        range = 0;
                        guarantedRange = false;
                        cp = false;
                        hs05 = 0;
                        hs08 = 0;
                        cumul7 = 0;
                        jfCount = 0;
                        rcCount = 0;
                        cpCount = 0;
                        ha05 = 0;
                        cumul15 = 0;
                        cumul23 = 0;
                        cumul25 = 0;
                        cumul26 = 0;
                        week = ConversionTime.getWeek(this.begin);
                        this.avgValue = -1;
                        currentDriver = (Conducteur)this.drivers.get(x);
                        requirements = true;
                        try {
                            currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                            if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                                defaultDayLength = currentContract.getDailyValue();
                            }
                        }
                        catch (TypeContratNotFoundException ex) {
                            requirements = false;
                            TimsLogger.error("#CustomHourExporter.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat());
                            if (Transport.debug < 1) break block61;
                            ex.printStackTrace();
                        }
                    }
                    if (currentDriver.getMatricule() == null || currentDriver.getMatricule().equals("")) {
                        requirements = false;
                    }
                    if (!requirements) {
                        this.warningList.add(currentDriver);
                    }
                    this.pb.getBar().setString(currentAgency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    tmpC = null;
                    if (currentDriver.getCalendarId() != 0) {
                        tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
                    }
                    serviceLeft = true;
                    ljcLeft = true;
                    expenseLeft = true;
                    day = this.begin;
                    while (day.compareTo(this.end) <= 0) {
                        block64: {
                            if (serviceLeft && tmpS.size() != 0) {
                                if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                                    serviceLeft = false;
                                } else if (day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                                    workedTime += tmpS.get(0).getService();
                                    driving += tmpS.get(0).getDriving();
                                    work += tmpS.get(0).getWork();
                                    range += tmpS.get(0).getAmplitude();
                                    cumul4Night += tmpS.get(0).getNight();
                                    hs05 += tmpS.get(0).getAvailability();
                                    hs05 += tmpS.get(0).getCrew();
                                    ++workedDay;
                                    tmpS.remove(0);
                                    if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                        System.out.print("#TimeToCcmxCayon.process# 2 services sur le m\u00eame jour ");
                                        tmpS.get(0).affiche();
                                        workedTime += tmpS.get(0).getService();
                                        cumul4Night += tmpS.get(0).getNight();
                                        ++workedDay;
                                        tmpS.remove(0);
                                    }
                                }
                            }
                            if (!ljcLeft || tmpL.size() == 0) break block64;
                            if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl154
                            ljcLeft = false;
                            break block64;
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    jt = JourType.getDayType(tmpL.get(0).getCleJourType());
                                    length = tmpL.get(0).getDuree(defaultDayLength);
                                    if (jt.isAvgValue() && tmpL.get(0).getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                        length = this.getAvgValue(currentDriver);
                                    }
                                    if (ConversionTime.getDayOfWeek(tmpL.get(0).getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                        TimsLogger.debug("#CustomHourExporter.process# CP le samedi, on ignore");
                                    } else {
                                        if (jt.getExport() == 4) {
                                            ++jfCount;
                                            cumul7 += length;
                                        }
                                        if (jt.getExport() == 1) {
                                            ++cpCount;
                                            ha05 += length;
                                        }
                                        if (jt.getExport() == 2) {
                                            hs05 += length;
                                        }
                                        if (jt.getCode().equals("RC")) {
                                            ++rcCount;
                                        }
                                        if (jt.getExport() == 3) {
                                            hs08 += length;
                                        }
                                        if (jt.shouldPay(currentDriver, tmpL.get(0).getDateJour())) {
                                            if (jt.isPaid()) {
                                                altPaidHour += length;
                                            }
                                            if (jt.isGenerateHS()) {
                                                altGenerateHSHour += length;
                                            }
                                            if (jt.isGenerateRC()) {
                                                altGenerateRCHour += length;
                                            }
                                        }
                                        if (tmpL.get(0).getType() == 2) {
                                            ++altDayCount;
                                        }
                                    }
                                }
                                catch (DayTypeNotFoundException ex) {
                                    TimsLogger.debug("type d'absence non trouv\u00e9, on ignore " + tmpL.get(0).getCleJourType());
                                }
                                tmpL.remove(0);
lbl154:
                                // 2 sources

                                ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                            }
                        }
                        if (tmpC != null) {
                            y = 0;
                            while (y < tmpC.size()) {
                                if (day.equals(tmpC.get(y).getDate())) {
                                    toAdd = new LienJourConducteur();
                                    toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                                    try {
                                        jt = JourType.getDayType(toAdd.getCleJourType());
                                        length = toAdd.getDuree(defaultDayLength);
                                        if (jt.isAvgValue() && toAdd.getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                            length = this.getAvgValue(currentDriver);
                                        }
                                        if (ConversionTime.getDayOfWeek(toAdd.getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                            TimsLogger.debug("#CustomHourExporter.process# CP le samedi, on ignore");
                                        } else {
                                            if (jt.shouldPay(currentDriver, toAdd.getDateJour())) {
                                                if (jt.getExport() == 4) {
                                                    ++jfCount;
                                                    cumul7 += length;
                                                }
                                                if (jt.getExport() == 1) {
                                                    ++cpCount;
                                                    ha05 += length;
                                                }
                                                if (jt.getExport() == 2) {
                                                    hs05 += length;
                                                }
                                                if (jt.getCode().equals("RC")) {
                                                    ++rcCount;
                                                }
                                                if (jt.getExport() == 3) {
                                                    hs08 += length;
                                                }
                                                if (jt.isPaid()) {
                                                    altPaidHour += length;
                                                }
                                                if (jt.isGenerateHS()) {
                                                    altGenerateHSHour += length;
                                                }
                                                if (jt.isGenerateRC()) {
                                                    altGenerateRCHour += length;
                                                }
                                            }
                                            if (toAdd.getType() == 2) {
                                                ++altDayCount;
                                            }
                                        }
                                    }
                                    catch (DayTypeNotFoundException ex) {
                                        TimsLogger.warn("type d'absence non trouv\u00e9, on ignore " + toAdd.getCleJourType());
                                    }
                                    tmpC.remove(y);
                                    break;
                                }
                                ++y;
                            }
                        }
                        if (currentContract.getCalculationType() == 1) {
                            ConversionTime.getWeek(ConversionTime.addDay(day, 1));
                        }
                        day = ConversionTime.addDay(day, 1);
                    }
                    while (expenseLeft) {
                        if (tmpE.size() == 0 || tmpE.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                            expenseLeft = false;
                            continue;
                        }
                        type = ExpensesType.getExpenses(tmpE.get(0).getExpensesId());
                        if (type.getExport() == 1) {
                            ++cumul15;
                        }
                        if (type.getExport() == 2) {
                            ++cumul23;
                        }
                        if (type.getExport() == 3) {
                            ++cumul25;
                        }
                        if (type.getExport() == 4) {
                            ++cumul26;
                        }
                        tmpE.remove(0);
                    }
                    TimsLogger.debug("\r\n#CustomHourExporter.process# " + currentDriver.getNom() + " " + currentDriver.getPrenom() + " :" + (requirements != false ? "" : "Matricule ou type de contrat manquants") + " base r\u00e9mun. contrat = " + (float)currentContract.getContractHour() / 60.0f + "HA05 = " + ha05 + "HS03 = " + driving + "HS04 = " + work + "HS05 = " + hs05 + "HS08 = " + hs08 + "CUMUL4 = " + cumul4Night + "CUMUL7 = " + cumul7 + "CP_PRIS = " + cpCount + "REPOS_PRIS = " + rcCount + "CUMUL15 (d\u00e9part dimanche) = " + cumul15 + "CUMUL23 (nb cc) = " + cumul23 + "CUMUL25 (nb midi + soir) = " + cumul25 + "CUMUL26 (nuit) = " + cumul26);
                    if (requirements) {
                        tmp = new HashMap<String, Object>();
                        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                        tmp.put(LanguageTranslator.getString("generics.matricule"), currentDriver.getMatricule());
                        tmp.put("HA05", ha05);
                        tmp.put("HS03", driving);
                        tmp.put("HS04", work);
                        tmp.put("HS05", hs05);
                        tmp.put("HS08", hs08);
                        tmp.put("CUMUL4", cumul4Night);
                        tmp.put("CUMUL7", cumul7);
                        tmp.put("CP_PRIS", cpCount);
                        tmp.put("REPOS_PRIS", rcCount);
                        tmp.put("CUMUL15", cumul15);
                        tmp.put("CUMUL23", cumul23);
                        tmp.put("CUMUL25", cumul25);
                        tmp.put("CUMUL26", cumul26);
                        this.data.add(tmp);
                        this.writeFile(this.file, currentAgency, currentDriver, ha05, driving, work, hs05, hs08, cumul4Night, cumul7, cpCount, rcCount, cumul15, cumul23, cumul25, cumul26);
                    }
                }
                ++x;
            }
            this.afficheData();
            this.loadReport(currentAgency, new JRMapCollectionDataSource(this.data));
            this.data.clear();
        }
        this.generate();
        this.file.close();
        this.pb.dispose();
    }

    public void writeFile(PrintWriter file, Agence agency, Conducteur driver, int ha05, int hs03, int hs04, int hs05, int hs08, int cumul4, int cumul7, int cpCount, int rcCount, int cumul15, int cumul23, int cumul25, int cumul26) {
        String matricule = driver.getMatricule();
        while (matricule.length() < 10) {
            matricule = String.valueOf(matricule) + " ";
        }
        file.write("VB" + matricule + "0" + "                                                " + this.format(0, ha05, 12) + "                                                                                    " + this.format(0, hs03, 12) + this.format(0, hs04, 12) + this.format(0, hs05, 12) + "                        " + this.format(0, hs08, 12) + "                                                                                    " + this.format(0, cumul4, 12) + "                        " + this.format(0, cumul7, 12) + "                                                                                    " + this.format(1, cpCount, 12) + "                          " + "       0.000" + this.format(1, rcCount, 12) + "                                                " + "                                                            " + "                                                            " + "                                                " + this.format(1, cumul15, 12) + "                                                                                    " + this.format(1, cumul23, 12) + "            " + this.format(1, cumul25, 12) + this.format(1, cumul26, 12) + "                                                                        " + ConversionTime.dateToString(this.begin, "dd/MM/yy") + ConversionTime.dateToString(this.end, "dd/MM/yy") + ConversionTime.dateToString(ConversionTime.addDay(this.end, 15), "dd/MM/yy"));
        String end = "";
        int x = 0;
        while (x < 384) {
            end = String.valueOf(end) + " ";
            ++x;
        }
        file.write(String.valueOf(end) + "\r\n");
    }

    private String format(int type, int amount, int length) {
        String toReturn = "";
        if (type == 0) {
            toReturn = this.df.format((float)amount / 60.0f);
        }
        if (type == 1) {
            toReturn = this.df.format(amount);
            TimsLogger.debug("CustomHourExporterC01.format# " + amount + " (count) -> " + toReturn);
        }
        while (toReturn.length() < length) {
            toReturn = " " + toReturn;
        }
        return toReturn;
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\n=> ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "  ");
            }
        }
    }

    private int getAvgValue(Conducteur current) {
        if (this.avgValue == -1) {
            this.avgValue = Fonctions.getAvgValue(current, this.begin, this.end);
        }
        return this.avgValue;
    }

    private CustomReport getCR() {
        CustomReport toReturn = CustomReportFactory.getGeneric("Export heures");
        toReturn.setColumn(this.getColumn());
        return toReturn;
    }

    private Vector<CustomReportColumn> getColumn() {
        Vector<CustomReportColumn> toReturn = new Vector<CustomReportColumn>();
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 12, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "HA05", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "HS03", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "HS04", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "HS05", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "HS08", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CUMUL4", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CUMUL7", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CP_PRIS", Integer.class.getName(), "", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "REPOS_PRIS", Integer.class.getName(), "", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CUMUL15", Integer.class.getName(), "", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CUMUL23", Integer.class.getName(), "", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CUMUL25", Integer.class.getName(), "", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "CUMUL26", Integer.class.getName(), "", 8, toReturn.size() + 1));
        return toReturn;
    }
}

