/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.CustomReportGroup;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.Hardness;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.generator.DJGenerator;
import transport.report.generator.TimeConverterFactory;

public class CustomReportFactory {
    public static CustomReport getDriverKmSynthesis() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "# ###.##", 33, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.workedDay"), Integer.class.getName(), "# ###.##", 33, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.km"), Integer.class.getName(), "# ###.##", 33, column.size() + 1));
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("driver.km"), 0, column, null);
        return cr;
    }

    public static CustomReport getDriverExpensesDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("expenses.report"), 2, null, null);
        cr.setColumn(CustomReportFactory.getDefaultExpensesColumn());
        return cr;
    }

    public static CustomReport getExpenseSynthesisDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("expenses.synthesis"), 2, null, null);
        cr.updateProperty("SHOW_COUNT", "1");
        cr.setColumn(CustomReportFactory.getDefaultExpenseSynthesisColumn());
        return cr;
    }

    public static CustomReport getExpenseCondensedDefault(String name) {
        CustomReport cr = new CustomReport(0, name, 2, null, null);
        cr.updateProperty("SHOW_COUNT", "0");
        cr.updateProperty("SHOW_AMOUNT", "1");
        cr.setColumn(CustomReportFactory.getDefaultExpenseCondensedColumn());
        return cr;
    }

    public static CustomReport getDriverServiceDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.custom.service"), 1, null, null);
        cr.setTimeConverter(TimeConverterFactory.getTimeConverter(1));
        cr.updateProperty("RESOLUTION", String.valueOf(1));
        cr.updateProperty("HS", "0");
        cr.updateProperty("WEEK_SUBTOTAL", "0");
        cr.updateProperty("TEMPLATE", DJGenerator.LANDSCAPE_TEMPLATE);
        boolean voyageur = System.getProperty("company.type", "1").equals("2");
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.begin"), Date.class.getName(), "dd/MM/yyyy HH:mm", 15, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.end"), Date.class.getName(), "dd/MM/yyyy HH:mm", 15, column.size() + 1));
        int columnWidth = 70 / TypeActivite.getList().size() + (voyageur ? 7 : 5);
        for (TypeActivite ta : TypeActivite.getList()) {
            column.add(new CustomReportColumn(0, 0, ta.getName(), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.serviceTotal"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.missing"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.missingTime"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.totalPaid"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.nightTime"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("activity.amplitude"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        if (voyageur) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("activity.amplitudeIndemnisation"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("activity.deIndemnisation"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("activity.jfIndemnisation"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.km"), Integer.class.getName(), "# ###", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.expenses"), Float.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getEmptyDriverExpenses() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("expenses.report"), 2, null, null);
        return cr;
    }

    public static CustomReport getOffenceDefault(ArrayList<String> date) {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.custom.offence"), 3, null, null);
        if (date != null) {
            cr.setColumn(CustomReportFactory.getOffenceSynthesisColumn(date));
        }
        return cr;
    }

    public static CustomReport getAgencySynthesisDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.custom"), 3, null, null);
        cr.updateProperty("SHOW_COUNT", "1");
        cr.updateProperty("TEMPLATE", DJGenerator.LANDSCAPE_TEMPLATE);
        cr.setColumn(CustomReportFactory.getDefaultExpensesColumn());
        return cr;
    }

    public static CustomReport getVehicleOffence() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.custom.offence"), 3, null, null);
        cr.setColumn(CustomReportFactory.getVehicleOffenceColumn());
        return cr;
    }

    public static CustomReport getGeneric(String title) {
        CustomReport cr = new CustomReport(0, title, 0, null, null);
        cr.setTimeConverter(TimeConverterFactory.getTimeConverter(1));
        return cr;
    }

    public static CustomReport getVehicleLocation() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.vehicle.location"), 3, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "# ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.locationLimit"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.locationKm"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.currentKm"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.average"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.dayLeft"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.endLocationKm"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "delta", Integer.class.getName(), "", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getVehicleTIPP() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.vehicle.TIPP"), 3, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.period"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.state"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.beginKm"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.endKm"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.totalKm"), Integer.class.getName(), "# ### ###", 0, column.size() + 1, true));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("fuel.consumption"), Integer.class.getName(), "# ### ###", 0, column.size() + 1, true));
        cr.setColumn(column);
        Vector<CustomReportGroup> groups = new Vector<CustomReportGroup>();
        groups.add(new CustomReportGroup(0, 0, LanguageTranslator.getString("generics.agency"), LanguageTranslator.getString("generics.agency"), String.class.getName()));
        cr.setGroups(groups);
        return cr;
    }

    public static CustomReport getCardRenewalReport() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.cardRenewal"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, "numCarte", String.class.getName(), "# ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "nomConducteur", String.class.getName(), "# ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "permisConducteur", String.class.getName(), "# ###", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getPayCheckingDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.payChecking"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.workedDay"), Integer.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("contract.hour"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("report.pp.service"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("report.pp.hs"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("report.pp.total"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("report.pp.abs"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("report.pp.hsBase"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.nightTime"), Integer.class.getName(), "time", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getRoundAnalysis() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("generics.roundAnalysis"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.round"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("round.beginTimeDiff"), Integer.class.getName(), "signed-time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("round.loadDurationDiff"), Integer.class.getName(), "signed-time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("round.unloadDurationDiff"), Integer.class.getName(), "signed-time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("round.totalTimeDiff"), Integer.class.getName(), "signed-time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("round.avgDeliveryTimeDiff"), Integer.class.getName(), "signed-time", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getAccidentSynthesis() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.responsability"), String.class.getName(), "", 0, column.size() + 1));
        for (VehicleAnalyticCode vac : VehicleAnalyticCode.getList()) {
            TimsLogger.debug("#CRF.getAccidentSynthesisColumn# add " + vac.getCode());
            column.add(new CustomReportColumn(0, 0, vac.getCode(), Integer.class.getName(), "", 0, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.unknown"), Integer.class.getName(), "", 0, column.size() + 1));
        TimsLogger.debug("#CRF.getAccidentSynthesisColumn# nb columns " + column.size());
        return new CustomReport(0, LanguageTranslator.getString("accident.synthesis"), 0, column, null);
    }

    public static CustomReport getAccidentGraphic() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("accident.synthesis"), 0, null, null);
        return cr;
    }

    public static CustomReport getAccidentReportList() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("accident.list"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.analyticCode"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.responsability"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cost"), Float.class.getName(), "# ###.##", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("accident.totalInsurance"), Float.class.getName(), "# ###.##", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getUnfilledAccident() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("accident.unfilled"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 90, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 150, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("accident.identification"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("accident.insuranceNumber"), String.class.getName(), "", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getFaultList() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("fault.list"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 90, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 150, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cardLength"), Integer.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.ieLength"), Integer.class.getName(), "", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getConsumptionList(boolean alertMode, int type) {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("consumption.list"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 80, column.size() + 1));
        if (type == 1) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 140, column.size() + 1));
        }
        if (type == 2) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.vehicle"), String.class.getName(), "", 140, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.consumption"), Float.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("fuel.consumptionPer100"), Float.class.getName(), "# ###.##", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.km"), Float.class.getName(), "# ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.length"), Integer.class.getName(), "time", 0, column.size() + 1));
        if (alertMode) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("consumption.badEval"), String.class.getName(), "", 150, column.size() + 1));
        }
        cr.setColumn(column);
        return cr;
    }

    public static Vector<CustomReportColumn> getDefaultDriverExpirationStateColumn(boolean showFimo, boolean showCard, boolean showLicenseMedical, boolean showMedical, boolean showAdr, boolean showCaces) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 90, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 150, column.size() + 1));
        if (showFimo) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("driver.fimoFco"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        }
        if (showCard) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cardExpiration"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        }
        if (showLicenseMedical) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("driver.licenceMedicalExam"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        }
        if (showMedical) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.medicalExam"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        }
        if (showAdr) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("driver.adr"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        }
        if (showCaces) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("driver.caces"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        }
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultAgencySynthesisColumn(Vector<String> date) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 2 + date.size();
        int columnWidth = 70 / columnCount;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 5, column.size() + 1));
        for (String day : date) {
            column.add(new CustomReportColumn(0, 0, day, Integer.class.getName(), "time", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "time", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultPlanningColumn(Vector<String> date) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 2 + date.size();
        int columnWidth = 70 / columnCount;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 5, column.size() + 1));
        for (String day : date) {
            column.add(new CustomReportColumn(0, 0, day, String.class.getName(), "", columnWidth, column.size() + 1));
        }
        return column;
    }

    public static CustomReport getDefaultHardnessReport() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.hardnessReport"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        Vector<Hardness> hardnesses = Hardness.getList();
        int columnWidth = 80 / (hardnesses.size() + 1);
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 20, column.size() + 1));
        for (Hardness hardness : hardnesses) {
            column.add(new CustomReportColumn(0, 0, hardness.getCode(), Integer.class.getName(), "", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "", columnWidth, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static CustomReport getOffenceChallengeDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.soffence"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 0, column.size() + 1));
        for (OffenceType tmp : OffenceType.getList()) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(tmp.getName()), Integer.class.getName(), "", 0, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static Vector<CustomReportColumn> getDefaultVehicleExpirationStateColumn(Vector<InterventionType> list) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 2 + list.size();
        int columnWidth = 100 / columnCount;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.vehicle"), String.class.getName(), "", columnWidth, column.size() + 1));
        for (InterventionType intType : list) {
            column.add(new CustomReportColumn(0, 0, intType.getName(), Date.class.getName(), "dd/MM/yyyy", columnWidth, column.size() + 1));
        }
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultDriverExpirationStateColumn(Vector<EmployeeObligationType> list) {
        int columnWidth;
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 2 + list.size();
        int agencyWidth = columnWidth = 100 / columnCount;
        int driverWidth = columnWidth;
        if (list.size() > 10) {
            columnWidth = 83 / (list.size() - 2);
            agencyWidth = 7;
            driverWidth = 10;
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", agencyWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", driverWidth, column.size() + 1));
        for (EmployeeObligationType eoType : list) {
            column.add(new CustomReportColumn(0, 0, eoType.getName(), Date.class.getName(), "dd/MM/yyyy", columnWidth, column.size() + 1));
        }
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultCompanyExpirationStateColumn(boolean showCard) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 1 + (showCard ? 1 : 0);
        int columnWidth = 100 / columnCount;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cardNumber"), String.class.getName(), "", columnWidth, column.size() + 1));
        if (showCard) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.expiry"), Date.class.getName(), "dd/MM/yyyy", columnWidth, column.size() + 1));
        }
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultExpensesColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "dd/MM/yyyy", 15, column.size() + 1));
        int columnWidth = 85 / ExpensesType.getList().size();
        for (ExpensesType e : ExpensesType.getList()) {
            column.add(new CustomReportColumn(0, 0, e.getCode(), Integer.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultExpenseSynthesisColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnWidth = 75 / ExpensesType.getList().size();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 25, column.size() + 1));
        for (ExpensesType e : ExpensesType.getList()) {
            column.add(new CustomReportColumn(0, 0, e.getCode(), Integer.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        return column;
    }

    public static CustomReport getAnalyticExpensesDefault() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("expenses.analytic"), 2, null, null);
        cr.updateProperty("SHOW_COUNT", "0");
        cr.updateProperty("SHOW_AMOUNT", "1");
        cr.setColumn(CustomReportFactory.getDefaultAnalyticExpensesColumn());
        return cr;
    }

    public static Vector<CustomReportColumn> getDefaultAnalyticExpensesColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "dd/MM/yyyy", 10, column.size() + 1));
        int columnWidth = 75 / ExpensesType.getList().size();
        for (ExpensesType e : ExpensesType.getList()) {
            column.add(new CustomReportColumn(0, 0, e.getCode(), Integer.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "# ###.##", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultExpenseCondensedColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnWidth = 75 / ExpensesType.getList().size();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 25, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 25, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "###0.00", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getVehicleOffenceColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.begin"), Date.class.getName(), "dd/MM/yyyy HH:mm", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.end"), Date.class.getName(), "dd/MM/yyyy HH:mm", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.length"), Integer.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.threshold"), Integer.class.getName(), "# ### ###", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.type"), String.class.getName(), "", 0, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultOffenceColumn() {
        boolean voyageur = Integer.parseInt(System.getProperty("voyageur", "0")) == 1;
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "dd/MM/yyyy", 15, column.size() + 1));
        int columnWidth = 70 / TypeActivite.getList().size() + (voyageur ? 7 : 5);
        for (OffenceType type : OffenceType.getList()) {
            String translateType = LanguageTranslator.getString(type.getName());
            for (OffencePart part : type.getParts()) {
                String translatePart = LanguageTranslator.getString(part.getName());
                column.add(new CustomReportColumn(0, 0, String.valueOf(translateType) + " (" + translatePart + ")", Integer.class.getName(), "# ###", columnWidth, column.size() + 1));
            }
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "# ###", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getOffenceSynthesisColumn(ArrayList<String> date) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 2 + date.size();
        int columnWidth = 55 / columnCount;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 25, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.type"), String.class.getName(), "", 20, column.size() + 1));
        if (date != null) {
            for (String day : date) {
                column.add(new CustomReportColumn(0, 0, day, Integer.class.getName(), "", columnWidth, column.size() + 1));
            }
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getOffenceSynthesisByGravityColumn(boolean withDriver) {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnCount = 5;
        if (withDriver) {
            ++columnCount;
        }
        int columnWidth = (withDriver ? 50 : 75) / columnCount;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 25, column.size() + 1));
        if (withDriver) {
            column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 25, column.size() + 1));
        }
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.minor"), Integer.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.serious"), Integer.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.verySerious"), Integer.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "", columnWidth, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getAgencySynthesisOffenceColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 60, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.minor"), Integer.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.serious"), Integer.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.verySerious"), Integer.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "", 10, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getAgencyOffenceColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.time"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.designation"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.autorisedThreshold"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.threshold"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.type"), String.class.getName(), "", 0, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getOffenceAlertColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "dd/MM/YYYY", 20, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("offence.threshold"), String.class.getName(), "", 15, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.designation"), String.class.getName(), "", 45, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cost"), Integer.class.getName(), "# ###", 20, column.size() + 1));
        return column;
    }

    public static Vector<CustomReportColumn> getDefaultUserColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        int columnWidth = 9;
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.login"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.lastName"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.firstName"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.company"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("profil"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.restriction.company"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.restriction.agency"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.restriction.driver"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.enable"), String.class.getName(), "", columnWidth, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.lastActivationAction"), Date.class.getName(), "dd/MM/yyyy", columnWidth, column.size() + 1));
        return column;
    }

    public static CustomReport getNDDSServiceSynthesis() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("service.synthesis"), 0, null, null);
        Vector<CustomReportColumn> columns = new Vector<CustomReportColumn>();
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.serviceTotal"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.serviceTotal"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.serviceTotal"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.serviceTotal"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.missing"), String.class.getName(), "", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.missingTime"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.totalPaid"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.nightTime"), Integer.class.getName(), "time", 0, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("activity.amplitude"), Integer.class.getName(), "time", 0, columns.size() + 1));
        cr.setColumn(columns);
        return cr;
    }

    public static CustomReport getServiceMissingDefault(boolean time) {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("globalActivity.synthesis"), 0, null, null);
        Vector<CustomReportColumn> columns = new Vector<CustomReportColumn>();
        int columnWidth = 100 / (JourType.getList().size() + 2);
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), Date.class.getName(), "dd/MM/yyyy", 15, columns.size() + 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.serviceTotal"), Integer.class.getName(), "time", columnWidth, columns.size() + 1));
        for (JourType type : JourType.getList()) {
            columns.add(new CustomReportColumn(0, 0, type.getCode(), Integer.class.getName(), time ? "time" : "# ###", columnWidth, columns.size() + 1));
        }
        cr.setColumn(columns);
        return cr;
    }

    public static CustomReport getVehicleSynthesis() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("report.vehicleSynthesis"), 0, null, null);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.vehicle"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.beginDate"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.begin"), String.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.endDate"), Date.class.getName(), "dd/MM/yyyy", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.end"), String.class.getName(), "time", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.total"), Integer.class.getName(), "", 0, column.size() + 1));
        cr.setColumn(column);
        return cr;
    }

    public static Vector<CustomReportColumn> getDefaultDriverDayDetailColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.begin"), String.class.getName(), "time", 25, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.end"), String.class.getName(), "time", 25, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.activity"), String.class.getName(), "", 30, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.length"), String.class.getName(), "", 20, column.size() + 1));
        return column;
    }

    public static CustomReport getDriversReport() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("driver.list"), 0, null, null);
        cr.setColumn(CustomReportFactory.getDriversColumn());
        return cr;
    }

    public static Vector<CustomReportColumn> getDriversColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.firstName"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.lastName"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cardNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.expiry"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.last.download"), String.class.getName(), "", 0, column.size() + 1));
        return column;
    }

    public static CustomReport getDriversDownloadReport() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("driver.list"), 0, null, null);
        cr.setColumn(CustomReportFactory.getDriversDownloadColumn());
        return cr;
    }

    public static Vector<CustomReportColumn> getDriversDownloadColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.firstName"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.lastName"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("user.registration"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.cardNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.last.download"), String.class.getName(), "", 0, column.size() + 1));
        return column;
    }

    public static CustomReport getVehiclesReport() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("vehicle.list"), 0, null, null);
        cr.setColumn(CustomReportFactory.getVehiclesColumn());
        return cr;
    }

    public static Vector<CustomReportColumn> getVehiclesColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.identificationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.brand"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.designation"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.last.download"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.vuBrand"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.vuVersion"), String.class.getName(), "", 0, column.size() + 1));
        return column;
    }

    public static CustomReport getVehiclesDownloadReport() {
        CustomReport cr = new CustomReport(0, LanguageTranslator.getString("vehicle.list"), 0, null, null);
        cr.setColumn(CustomReportFactory.getVehiclesDownloadColumn());
        return cr;
    }

    public static Vector<CustomReportColumn> getVehiclesDownloadColumn() {
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.agency"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("vehicle.registrationNumber"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.designation"), String.class.getName(), "", 0, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.last.download"), String.class.getName(), "", 0, column.size() + 1));
        return column;
    }
}

