/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transport.report.MasterReport;

public class DailyReport
extends MasterReport {
    private Collection<Map<String, ?>> data = null;

    @Override
    public void process() {
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        if (this.data == null) {
            this.data = new ArrayList();
        }
        for (Conducteur driver : this.drivers) {
            Vector<Jour> tmpJ = BddTransport.getInstance().getJourNew(driver.getCleConducteur(), this.begin, this.end, 1, false);
            this.pb.getBar().setString(String.valueOf(driver.getNom()) + " " + driver.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            for (Jour day : tmpJ) {
                try {
                    for (ActiviteConducteur act : day.getActivity()) {
                        this.data.add(this.fillMap(day, act, driver));
                    }
                }
                catch (Exception ex) {
                    TimsLogger.warn("Erreur sur conducteur " + driver.getCleConducteur() + " on " + day.getDate());
                    ex.printStackTrace();
                }
                try {
                    this.loadReport(driver, new JRMapCollectionDataSource(this.data));
                }
                catch (Exception e) {
                    TimsLogger.warn("G\u00e9n\u00e9ration impossible pour " + driver.getCleConducteur());
                    e.printStackTrace();
                }
                this.data.clear();
            }
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Jour day, ActiviteConducteur act, Conducteur driver) throws ActivityTypeNotFoundException {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("CLE_TYPE_ACTIV", act.getCleType());
        tmp.put("ANNEE_ACTIVITE", ConversionTime.dateToString(act.getDate(), "dd/MM/yyyy"));
        tmp.put("COULEUR", TypeActivite.getActivityType(act.getCleType()).getColor());
        tmp.put("DUREE_EN_MINUTE", act.getDuree());
        tmp.put("HEURE_DEBUT", act.getHeureDebut());
        tmp.put("HEURE_FIN", act.getHeureFin());
        tmp.put("DISPO", day.getAvailability());
        tmp.put("TRAVAIL", day.getWork());
        tmp.put("DOUBLE_EQUIP", day.getCrew());
        tmp.put("AUTRE", day.getOther());
        tmp.put("DISTANCE", String.valueOf(day.getKm()));
        tmp.put("CONDUITE", day.getDriving());
        tmp.put("debut_jour", day.getBeginTime());
        tmp.put("fin_jour", day.getEndTime());
        tmp.put("NOM_CONDUCTEUR", driver.getNom());
        tmp.put("PRENOM_CONDUCTEUR", driver.getPrenom());
        tmp.put("DESIGNATION", act.getDescription());
        return tmp;
    }

    public Conducteur getDriver(Vector<Conducteur> driverList, int driverId) throws DriverNotFoundException {
        for (Conducteur tmp : driverList) {
            if (tmp.getCleConducteur() != driverId) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }
}

