/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.Overviewable;

public class DynamicOffenceSynthesisByGravity
extends DynamicGeneric
implements Overviewable {
    public static final String MONTH_FORMAT = "MMM/yy";
    CustomReport customReport = null;

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicOffenceSynthesisByGravity.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        TimsLogger.debug("#DynamicOffenceSynthesisByGravity.setValues# brute = " + this.userParameters.get("BRUTE"));
        TimsLogger.debug("#DynamicOffenceSynthesisByGravity.setValues# out = " + this.userParameters.get("OUT"));
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getGeneric(LanguageTranslator.getString("report.soffence"));
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
        TimsLogger.debug("#DynamicOffenceSynthesisByGravity.setValues# out = " + this.userParameters.get("OUT"));
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    @Override
    public void process() throws Exception {
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicExpensesSynthesis.process# Build during process. (" + this.agencies.size() + " agencies to build)");
            needBuild = true;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.agencies.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.customReport.setColumn(CustomReportFactory.getOffenceSynthesisByGravityColumn("CONDUCTEUR".equals(this.userParameters.get("GROUPBY"))));
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        int x = 0;
        while (x < this.agencies.size()) {
            if (this.pb != null) {
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            Agence agency = (Agence)this.agencies.get(x);
            if (needBuild) {
                this.buildOneAgency(agency, null);
            }
            if (this.data.size() != 0) {
                this.userParameters.put("AGENCE", agency.getDescription());
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + agency.getDescription());
                }
            }
            ++x;
        }
        this.load(new JRMapCollectionDataSource((Collection)this.data), this.customReport.getName());
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        if (this.data.size() == 0) {
            TimsLogger.debug("#DynamicExpensesSynthesis.process# no data");
        }
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() throws JRException {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("missing parameters begin or end");
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.agencies.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        for (Agence agency : this.agencies) {
            try {
                this.buildOneAgency(agency, null);
            }
            catch (Exception ex) {
                TimsLogger.warn("build Error on ." + agency.getDescription());
                ex.printStackTrace();
            }
        }
    }

    public void buildOneAgency(Agence agency, Vector<Offence> offences) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        if (this.pb != null) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + " : " + agency.getDescription());
        }
        int agencyMinor = 0;
        int agencySerious = 0;
        int agencyVerySerious = 0;
        if (offences == null) {
            Transport.ps.startOperation();
            offences = Offence.loadList(agency.getCleAgence(), this.drivers.size() == 1 ? ((Conducteur)this.drivers.get(0)).getCleConducteur() : 0, ConversionTime.dateToString(this.begin, "yyyy-MM-dd"), ConversionTime.dateToString(this.end, "yyyy-MM-dd"), "1".equals(this.userParameters.get("BRUTE")), false);
            TimsLogger.debug("#DynamicExpensesSynthesis.buildOneAgency# brute = " + this.userParameters.get("BRUTE"));
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DynamicExpensesSynthesis.buildOneAgency# " + offences.size() + " infractions r\u00e9cup\u00e9r\u00e9s");
        }
        Transport.ps.startOperation();
        int x = 0;
        while (x < this.drivers.size()) {
            int driverMinor = 0;
            int driverSerious = 0;
            int driverVerySerious = 0;
            if (offences.size() == 0) {
                TimsLogger.debug("#DynamicExpensesSynthesis.process# no offences left...");
                break;
            }
            if (((Conducteur)this.drivers.get(x)).getCleAgence() == agency.getCleAgence()) {
                int driverTotal;
                Conducteur currentDriver = (Conducteur)this.drivers.get(x);
                TimsLogger.debug("#DynamicExpensesSynthesis.process# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                if (this.pb != null) {
                    this.pb.getBar().setString(agency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                }
                while (offences.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                    switch (offences.get(0).getType()) {
                        case 1: {
                            ++driverMinor;
                            break;
                        }
                        case 2: {
                            ++driverSerious;
                            break;
                        }
                        case 3: {
                            ++driverVerySerious;
                        }
                    }
                    offences.remove(0);
                    if (offences.size() == 0) break;
                }
                if ((driverTotal = driverMinor + driverSerious + driverVerySerious) != 0 && "CONDUCTEUR".equals(this.userParameters.get("GROUPBY"))) {
                    HashMap<String, Object> tmp = new HashMap<String, Object>();
                    tmp.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
                    tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                    tmp.put(LanguageTranslator.getString("offence.minor"), driverMinor);
                    tmp.put(LanguageTranslator.getString("offence.serious"), driverSerious);
                    tmp.put(LanguageTranslator.getString("offence.verySerious"), driverVerySerious);
                    tmp.put(LanguageTranslator.getString("generics.total"), driverMinor + driverSerious + driverVerySerious);
                    this.data.add(tmp);
                }
                agencyMinor += driverMinor;
                agencySerious += driverSerious;
                agencyVerySerious += driverVerySerious;
                TimsLogger.debug("#DynamicExpensesSynthesis.process# C'est la fin du conducteur " + currentDriver.getNom());
            }
            ++x;
        }
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
        tmp.put(LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("generics.total"));
        tmp.put(LanguageTranslator.getString("offence.minor"), agencyMinor);
        tmp.put(LanguageTranslator.getString("offence.serious"), agencySerious);
        tmp.put(LanguageTranslator.getString("offence.verySerious"), agencyVerySerious);
        tmp.put(LanguageTranslator.getString("generics.total"), agencyMinor + agencySerious + agencyVerySerious);
        this.data.add(tmp);
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DOSBG.buildOneAgency# build one agency");
    }

    public TreeMap<String, HashMap<String, Object>> getOffenceTypeMap() {
        TreeMap<String, HashMap<String, Object>> toReturn = new TreeMap<String, HashMap<String, Object>>();
        for (OffenceType tmp : OffenceType.getList()) {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (String month : this.getColumn()) {
                data.put(month, 0);
            }
            toReturn.put(tmp.getName(), data);
        }
        return toReturn;
    }

    public ArrayList<String> getColumn() {
        ArrayList<String> toReturn = new ArrayList<String>();
        GregorianCalendar tmp = new GregorianCalendar();
        tmp.setTime(this.begin);
        tmp.set(5, 1);
        String toAdd = ConversionTime.dateToString(tmp.getTime(), MONTH_FORMAT);
        while (tmp.getTime().compareTo(this.end) <= 0) {
            toReturn.add(toAdd);
            tmp.add(2, 1);
            toAdd = ConversionTime.dateToString(tmp.getTime(), MONTH_FORMAT);
        }
        return toReturn;
    }

    @Override
    public void showOverview(JTable table) {
        TimsLogger.debug("#DynamicOffenceSynthesisByGravity.showOverview# not yet implemented");
    }
}

