/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import java.util.HashMap;

public class HSCalculator {
    private TypeContrat contract = null;
    int hn = 0;
    int he = 0;
    int hs25 = 0;
    int hs50 = 0;
    private HashMap<Integer, Integer> weekTotal = null;
    private HashMap<Integer, Integer> monthTotal = null;
    private HashMap<Integer, Integer> weekHS = null;
    private HashMap<Integer, Integer> monthHS = null;

    public HSCalculator(TypeContrat contract) {
        this.contract = contract;
    }

    public void addService(Service service) {
        int week = ConversionTime.getWeek(service.getBeginDate(), "yyyy-MM-dd");
        int month = ConversionTime.getMonth(service.getBeginDate(), "yyyy-MM-dd");
        this.weekTotal.put(week, this.weekTotal.get(week) == null ? service.getService() : service.getService() + this.weekTotal.get(week));
        if (this.contract.getCalculationType() == 1) {
            Integer previousVal;
            int newVal = this.weekTotal.get(week) - this.contract.getSeuilHN(this.contract.getCalculationType());
            if (newVal < 0) {
                newVal = 0;
            }
            if ((previousVal = this.weekHS.put(week, newVal)) == null || previousVal != newVal) {
                this.monthHS.put(month, this.monthHS.get(month) == null ? newVal : this.monthHS.get(month) + newVal - previousVal);
            }
        }
    }
}

