/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Place;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transport.report.MasterReport;

public class NDDSServiceReport
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;

    @Override
    public void process() {
        Vector<Service> tmpS = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        Vector<Integer> orderedDriverId = Fonctions.reorder(tmpS, null);
        Conducteur currentDriver = null;
        this.pb.getBar().setMaximum(orderedDriverId.size());
        this.pb.getBar().setMinimum(0);
        if (this.data == null) {
            this.data = new ArrayList();
        }
        for (Integer driverId : orderedDriverId) {
            Vector<Place> places = Place.load(driverId, ConversionTime.dateToString(this.begin, "yyyy-MM-dd"), ConversionTime.dateToString(this.end, "yyyy-MM-dd"));
            Vector<VehicleUsed> vehicles = VehicleUsed.loadListDriver((int)driverId, 0, this.begin, this.end);
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            boolean serviceLeft = true;
            try {
                currentDriver = this.getDriver(this.drivers, driverId);
                this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                int x = 0;
                while (tmpS.size() != 0 && serviceLeft) {
                    Service s = null;
                    if (tmpS.get(x).getDriverId() != driverId.intValue()) {
                        serviceLeft = false;
                        System.out.print("#NDDSServiceReport.process# endOfService ");
                        tmpS.get(x).affiche();
                        break;
                    }
                    System.out.print("#NDDSServiceReport.process# found ");
                    tmpS.get(x).affiche();
                    s = tmpS.get(x);
                    Vector<VehicleUsed> toFill = new Vector<VehicleUsed>();
                    int nextRest = tmpS.get(x).getDailyRest();
                    Date beginService = ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd ");
                    beginService = ConversionTime.add(beginService, 12, s.getBeginTime());
                    Date beforeLimit = ConversionTime.add(beginService, 12, -s.getDailyRest());
                    Date endService = ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd");
                    endService = ConversionTime.add(endService, 12, s.getEndTime());
                    Date afterLimit = ConversionTime.add(endService, 12, nextRest);
                    TimsLogger.debug("\r\n\r\n#NDDSServiceReport.process# on cherche les v\u00e9hicules entre " + ConversionTime.dateToString(beforeLimit, "dd/MM HH:mm") + " et " + ConversionTime.dateToString(afterLimit, "dd/MM HH:mm") + " service du " + ConversionTime.dateToString(beginService, "dd/MM HH:mm") + " au " + ConversionTime.dateToString(endService, "dd/MM HH:mm"));
                    tmpS.remove(x);
                    int y = 0;
                    while (y < vehicles.size()) {
                        VehicleUsed tmpV = vehicles.get(y);
                        Date beginVehicle = ConversionTime.dateTruncate(tmpV.getDateDebut());
                        Date endVehicle = ConversionTime.dateTruncate(tmpV.getDateFin());
                        if (beginVehicle.after(beforeLimit) && endVehicle.before(afterLimit)) {
                            TimsLogger.verbose(String.valueOf(tmpV.getImmatriculation()) + " => " + tmpV.getDateDebut() + " " + tmpV.getDateFin() + " \u00e0 ajouter (" + tmpV.getKmDebut() + "-" + tmpV.getKmFin() + ")");
                            toFill.add(tmpV);
                        } else if (beforeLimit.after(beginVehicle) && endVehicle.after(beginService)) {
                            TimsLogger.verbose(" 1. ca se corse " + tmpV.getImmatriculation() + " " + tmpV.getDateDebut() + " " + tmpV.getDateFin() + " \u00e0 r\u00e9cuperer (" + tmpV.getKmDebut() + "-" + tmpV.getKmFin() + ") on cherche le lieux le " + ConversionTime.dateToString(beginService, "dd/MM HH:mm"));
                            for (Place tmp : places) {
                                long diffBegin = tmp.getDateTime().getTime() - beginService.getTime();
                                if (-300000L >= diffBegin || diffBegin >= 300000L) continue;
                                TimsLogger.verbose("On a trouv\u00e9 le km d\u00e9but: " + tmp.getKm());
                                tmpV.setKmDebut(tmp.getKm());
                                toFill.add(tmpV);
                                break;
                            }
                        } else if (beginVehicle.before(endService) && endVehicle.after(afterLimit)) {
                            TimsLogger.verbose(" 2. ca se corse " + tmpV.getImmatriculation() + " " + tmpV.getDateDebut() + " " + tmpV.getDateFin() + " \u00e0 r\u00e9cuperer (" + tmpV.getKmDebut() + "-" + tmpV.getKmFin() + ") on herche un lieux le " + ConversionTime.dateToString(endService, "dd/MM HH:mm"));
                            for (Place tmp : places) {
                                long diffEnd = tmp.getDateTime().getTime() - endService.getTime();
                                if (-300000L >= diffEnd || diffEnd >= 300000L) continue;
                                TimsLogger.verbose("On a trouv\u00e9 le km fin : " + tmp.getKm());
                                tmpV.setKmFin(tmp.getKm());
                                toFill.add(tmpV);
                                break;
                            }
                        } else {
                            TimsLogger.verbose(" 3. ?? " + tmpV.getImmatriculation() + " " + tmpV.getDateDebut() + " " + tmpV.getDateFin());
                        }
                        ++y;
                    }
                    this.fillMap(s, toFill);
                }
                this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
                this.data.clear();
                TimsLogger.debug("#NDDSServiceReport.process# C'est la fin du conducteur " + currentDriver.getNom());
            }
            catch (DriverNotFoundException ex) {
                TimsLogger.warn("Unable to find driver " + driverId);
            }
            catch (Exception ex) {
                TimsLogger.warn("Erreur sur conducteur " + driverId);
                ex.printStackTrace();
            }
        }
        this.generate();
    }

    public void fillMap(Service s, Vector<VehicleUsed> toFill) {
        System.out.print("#NDDSServiceReport.process()# on ajoute ");
        if (s == null) {
            return;
        }
        if (s != null) {
            s.affiche();
        }
        boolean first = true;
        for (VehicleUsed v : toFill) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            Date debut = ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd HH:mm");
            if (first) {
                tmp.put("DATE_DEBUT", debut);
                tmp.put("DATE_FIN", ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd HH:mm"));
                tmp.put("SEMAINE", ConversionTime.dateToString(debut, "w"));
                tmp.put("CONDUITE", s.getDriving());
                tmp.put("TRAVAIL", s.getWork());
                tmp.put("DISPO", s.getAvailability());
                tmp.put("DOUBLE_EQUIPAGE", s.getCrew());
                tmp.put("REPOS", s.getRest());
                tmp.put("REPOS_JOURNALIER", s.getDailyRest());
                tmp.put("AUTRE_SERVICE", s.getOther());
                tmp.put("INCONNU", s.getUnk());
                tmp.put("SERVICE", s.getService());
                tmp.put("AMPLITUDE", s.getAmplitude());
                tmp.put("HEURE_NUIT", s.getNight());
                first = false;
            }
            tmp.put("IMMATRICULATION", v.getImmatriculation());
            tmp.put("DISTANCE", v.getKmEffectue());
            this.data.add(tmp);
        }
    }

    public Conducteur getDriver(Vector<Conducteur> driverList, int driverId) throws DriverNotFoundException {
        for (Conducteur tmp : driverList) {
            if (tmp.getCleConducteur() != driverId) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }
}

