/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Place;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class NDDSServiceSynthese
extends MasterReport {
    private Collection<Map<String, ?>> data = null;
    private Date lastEndOfService = null;
    private long delta = 900000L;

    /*
     * Unable to fully structure code
     */
    @Override
    public void process() {
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.reportName());
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        if (this.data == null) {
            this.data = new ArrayList<Map<String, ?>>();
        }
        tmpS = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        tmpL = LienJourConducteur.loadList(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        TimsLogger.info("#ServiceSynthese.process()# " + tmpS.size() + " services, " + tmpL.size() + " jours");
        ljc = new Vector<LienJourConducteur>();
        x = 0;
        while (x < this.drivers.size()) {
            block22: {
                this.lastEndOfService = null;
                currentContract = null;
                defaultDayLength = 0;
                currentDriver = (Conducteur)this.drivers.get(x);
                requirements = true;
                try {
                    TimsLogger.debug("#serviceSynthese.process# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                    currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                    if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                        defaultDayLength = currentContract.getDailyValue();
                    }
                    this.getUserParameter().put("SEUIL_HN", currentContract.getSeuilHN(currentContract.getCalculationType()));
                    this.getUserParameter().put("SEUIL_HS25", currentContract.getSeuilHS25(currentContract.getCalculationType()));
                    this.getUserParameter().put("CALCULATION_TYPE", currentContract.getCalculationType());
                }
                catch (TypeContratNotFoundException ex) {
                    requirements = false;
                    this.warningList.add(currentDriver);
                    System.err.println("#serviceSynthese.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat() + " driver " + currentDriver.getNom());
                    if (Transport.debug < 1) break block22;
                    ex.printStackTrace();
                }
            }
            begin1 = ConversionTime.add(this.begin, 5, -1);
            end1 = ConversionTime.add(this.end, 5, 1);
            vehicles = VehicleUsed.loadListDriver(currentDriver.getCleConducteur(), 0, begin1, end1);
            places = Place.load(currentDriver.getCleConducteur(), ConversionTime.dateToString(begin1, "yyyy-MM-dd"), ConversionTime.dateToString(end1, "yyyy-MM-dd"));
            expenses = DriverExpenses.loadList(0, currentDriver.getCleConducteur(), this.begin, this.end);
            this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            tmpC = null;
            if (currentDriver.getCalendarId() != 0) {
                tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
            }
            serviceLeft = true;
            ljcLeft = true;
            day = this.begin;
            while (day.compareTo(this.end) <= 0) {
                block23: {
                    TimsLogger.debug("#serviceSynthese.process# (" + currentDriver.getCleConducteur() + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy"));
                    s = null;
                    toFill = null;
                    expensesAmount = 0.0f;
                    second = null;
                    toFillS = null;
                    ljc.clear();
                    if (serviceLeft && tmpS.size() != 0) {
                        if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                            serviceLeft = false;
                            TimsLogger.debug("#aac.process# endOfService (no more service)");
                            tmpS.get(0).affiche();
                        } else if (day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                            s = tmpS.get(0);
                            toFill = this.searchVehicles(s, tmpS.size() > 1 ? tmpS.get(1) : null, vehicles, places);
                            expensesAmount = this.searchExpenses(ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd"), expenses);
                            tmpS.remove(0);
                            if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                TimsLogger.debug("#aac.process# 2 services sur le m\u00eame jour ");
                                tmpS.get(0).affiche();
                                second = tmpS.get(0);
                                toFillS = this.searchVehicles(s, tmpS.size() > 1 ? tmpS.get(1) : null, vehicles, places);
                                tmpS.remove(0);
                            }
                        }
                    }
                    if (!ljcLeft || tmpL.size() == 0) break block23;
                    if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl91
                    ljcLeft = false;
                    TimsLogger.debug("#serviceSynthese.process# endOfLjc (" + tmpL.get(0).getCleConducteur() + ")");
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        ljc.add(tmpL.get(0));
                        tmpL.remove(0);
lbl91:
                        // 2 sources

                        ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                    }
                }
                if (tmpC != null) {
                    y = 0;
                    while (y < tmpC.size()) {
                        if (day.equals(tmpC.get(y).getDate())) {
                            toAdd = new LienJourConducteur();
                            toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                            TimsLogger.debug("from calendar : ");
                            toAdd.affiche();
                            ljc.add(toAdd);
                            tmpC.remove(y);
                            break;
                        }
                        ++y;
                    }
                }
                if (s == null && (ljc == null || ljc.size() == 0)) {
                    TimsLogger.debug("#serviceSynthese.process# aucune donn\u00e9es");
                } else if (requirements) {
                    this.fillMap(currentDriver, s, ljc, defaultDayLength, toFill, expensesAmount);
                    if (second != null) {
                        this.fillMap(currentDriver, second, null, defaultDayLength, toFillS, expensesAmount);
                    }
                }
                day = ConversionTime.addDay(day, 1);
            }
            try {
                this.afficheData();
                this.getUserParameter().put("NAME", this.report.getCustomizedName());
                this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
                this.data.clear();
            }
            catch (Exception ex) {
                TimsLogger.warn("#serviceSynthese.process# An error occured while generating aac report for " + currentDriver.getNom());
                ex.printStackTrace();
            }
            TimsLogger.debug("#serviceSynthese.process# C'est la fin du conducteur " + currentDriver.getNom());
            ++x;
        }
        this.generate();
    }

    private float searchExpenses(Date serviceDate, Vector<DriverExpenses> expenses) {
        float toReturn = 0.0f;
        int x = 0;
        while (x < expenses.size()) {
            if (expenses.get(x).getDate().equals(serviceDate)) {
                toReturn += expenses.get(x).getAmount();
                expenses.remove(x);
                --x;
            }
            ++x;
        }
        return toReturn;
    }

    private Vector<Object[]> searchVehicles(Service s, Service next, Vector<VehicleUsed> vehicles, Vector<Place> places) {
        if (next != null && s.getDriverId() != next.getDriverId()) {
            next = null;
        }
        Vector<Object[]> toFill = new Vector<Object[]>();
        Date beginService = ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd ");
        beginService = ConversionTime.add(beginService, 12, s.getBeginTime());
        Date beforeLimit = this.lastEndOfService == null ? ConversionTime.add(beginService, 12, -s.getDailyRest()) : this.lastEndOfService;
        this.lastEndOfService = ConversionTime.add(ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd"), 12, s.getEndTime());
        Date afterLimit = null;
        if (next == null) {
            afterLimit = ConversionTime.add(this.lastEndOfService, 12, 540);
        } else {
            afterLimit = ConversionTime.stringToDate(next.getBeginDate(), "yyyy-MM-dd ");
            afterLimit = ConversionTime.add(afterLimit, 12, next.getBeginTime());
        }
        TimsLogger.debug("\r\n\r\n#NDDSServiceReport.process# on cherche les v\u00e9hicules entre " + ConversionTime.dateToString(beforeLimit, "dd/MM HH:mm") + " et " + ConversionTime.dateToString(afterLimit, "dd/MM HH:mm") + " service du " + ConversionTime.dateToString(beginService, "dd/MM HH:mm") + " au " + ConversionTime.dateToString(this.lastEndOfService, "dd/MM HH:mm"));
        int y = 0;
        while (y < vehicles.size()) {
            VehicleUsed tmpV = vehicles.get(y);
            Date beginVehicle = ConversionTime.dateTruncate(tmpV.getDateDebut());
            Date endVehicle = tmpV.getDateFin();
            if (beginVehicle.after(beforeLimit) && endVehicle.before(afterLimit)) {
                TimsLogger.verbose(String.valueOf(tmpV.getImmatriculation()) + " => " + tmpV.getDateDebut() + " " + tmpV.getDateFin() + " \u00e0 ajouter (" + tmpV.getKmDebut() + "-" + tmpV.getKmFin() + ") " + ConversionTime.dateToString(beginVehicle, "dd/MM HH:mm") + " apr\u00e8s " + ConversionTime.dateToString(beforeLimit, "dd/MM HH:mm") + " et " + ConversionTime.dateToString(endVehicle, "dd/MM HH:mm") + " avant " + ConversionTime.dateToString(afterLimit, "dd/MM HH:mm"));
                if (toFill.size() != 0 && toFill.get(toFill.size() - 1)[0].equals(tmpV.getImmatriculation())) {
                    TimsLogger.verbose("On a trouv\u00e9 l'immatriculation");
                    toFill.get((int)(toFill.size() - 1))[1] = (Integer)toFill.get(toFill.size() - 1)[1] + tmpV.getKmEffectue();
                } else {
                    Object[] toAdd = new Object[]{tmpV.getImmatriculation(), tmpV.getKmEffectue()};
                    toFill.add(toAdd);
                }
            } else if (beforeLimit.after(beginVehicle) && endVehicle.after(beginService)) {
                TimsLogger.verbose(" 1. ca se corse " + tmpV.getImmatriculation() + " " + tmpV.getDateDebut() + " " + tmpV.getDateFin() + " \u00e0 r\u00e9cuperer (" + tmpV.getKmDebut() + "-" + tmpV.getKmFin() + ") on cherche le lieux le " + ConversionTime.dateToString(beginService, "dd/MM HH:mm"));
                for (Place tmp : places) {
                    long diffBegin = tmp.getDateTime().getTime() - beginService.getTime();
                    if (-this.delta >= diffBegin || diffBegin >= this.delta) continue;
                    Object[] toAdd = new Object[]{tmpV.getImmatriculation(), tmpV.getKmFin() - tmp.getKm()};
                    TimsLogger.verbose("On a trouv\u00e9 le km d\u00e9but: " + tmp.getKm());
                    toFill.add(toAdd);
                    break;
                }
            } else if (beginVehicle.before(this.lastEndOfService) && endVehicle.after(afterLimit)) {
                TimsLogger.verbose(" 2. ca se corse " + tmpV.getImmatriculation() + " " + tmpV.getDateDebut() + " " + tmpV.getDateFin() + " \u00e0 r\u00e9cuperer (" + tmpV.getKmDebut() + "-" + tmpV.getKmFin() + ") on herche un lieux le " + ConversionTime.dateToString(this.lastEndOfService, "dd/MM HH:mm"));
                boolean found = false;
                for (Place tmp : places) {
                    long diffEnd = tmp.getDateTime().getTime() - this.lastEndOfService.getTime();
                    if (-this.delta >= diffEnd || diffEnd >= this.delta) continue;
                    if (toFill.size() != 0 && toFill.get(toFill.size() - 1)[0].equals(tmpV.getImmatriculation())) {
                        TimsLogger.verbose("On a trouv\u00e9 le km fin : " + tmp.getKm() + " on ajoute au dernier enregistr\u00e9");
                        toFill.get((int)(toFill.size() - 1))[1] = (Integer)toFill.get(toFill.size() - 1)[1] + tmp.getKm() - tmpV.getKmDebut();
                    } else {
                        TimsLogger.verbose("On a trouv\u00e9 le km fin : " + tmp.getKm() + " on ajoute une nouvelle ligne");
                        Object[] toAdd = new Object[]{tmpV.getImmatriculation(), tmp.getKm() - tmpV.getKmDebut()};
                        toFill.add(toAdd);
                    }
                    found = true;
                    break;
                }
                if (!found && next == null && s.getBeginTime() > 120) {
                    TimsLogger.verbose("On a pas trouv\u00e9 mais c'est le dernier service et il commence apr\u00e8s 2h... on consid\u00e8re que le km est bon...");
                    Object[] toAdd = new Object[]{tmpV.getImmatriculation(), tmpV.getKmEffectue()};
                    toFill.add(toAdd);
                }
            }
            ++y;
        }
        return toFill;
    }

    public void fillMap(Conducteur driver, Service s, Vector<LienJourConducteur> l, int defaultDayLength, Vector<Object[]> toFill, float expensesAmount) {
        if (s != null) {
            s.affiche();
        }
        if (l != null && l.size() != 0) {
            l.get(0).affiche();
        }
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        int duree = 0;
        int genereHS = 0;
        int remuneration = 0;
        boolean serviceIncluded = false;
        boolean senority = true;
        String designation = "";
        try {
            if (l != null && l.size() != 0) {
                for (LienJourConducteur ljc : l) {
                    JourType dayType = JourType.getDayType(ljc.getCleJourType());
                    if (dayType.isPaid()) {
                        if (dayType.isServiceIncluded() && (ljc.getType() == 2 || System.getProperty("company", "PGH").equals("salvesen") && ljc.getDuree(defaultDayLength) >= 420)) {
                            serviceIncluded = true;
                        }
                        if (dayType.shouldPay(driver, ljc.getDateJour())) {
                            remuneration += ljc.getDuree(defaultDayLength);
                        } else {
                            senority = false;
                        }
                    }
                    if (dayType.isGenerateHS()) {
                        genereHS += ljc.getDuree(defaultDayLength);
                    }
                    if (System.getProperty("company", "PGH").equals("salvesen")) {
                        if (!dayType.isPaid()) continue;
                        designation = String.valueOf(designation) + ", " + JourType.getDayType(ljc.getCleJourType()).getCode();
                        duree += ljc.getDuree(defaultDayLength);
                        continue;
                    }
                    designation = String.valueOf(designation) + ", " + JourType.getDayType(ljc.getCleJourType()).getCode();
                    if ("1".equals(System.getProperty("hide.unpaid", "0"))) {
                        if (!dayType.isPaid()) continue;
                        duree += ljc.getDuree(defaultDayLength);
                        continue;
                    }
                    duree += ljc.getDuree(defaultDayLength);
                }
            }
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#ServiceSynthese.fillMap# DayType " + l.get(0).getCleJourType() + " not found");
        }
        if (!serviceIncluded) {
            remuneration += s != null ? s.getService() : 0;
        }
        Date debut = s != null ? ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd HH:mm") : ConversionTime.add(l.get(0).getDateJour(), 12, l.get(0).getHeureDebut());
        tmp.put(LanguageTranslator.getString("generics.begin"), debut);
        tmp.put(LanguageTranslator.getString("generics.end"), s != null ? ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd HH:mm") : null);
        tmp.put(LanguageTranslator.getString("generics.week"), Long.parseLong(ConversionTime.dateToString(debut, "w")));
        tmp.put(LanguageTranslator.getString("activity.driving"), s != null ? s.getDriving() : 0);
        tmp.put(LanguageTranslator.getString("activity.work"), s != null ? s.getWork() : 0);
        tmp.put(LanguageTranslator.getString("activity.availability"), s != null ? s.getAvailability() : 0);
        tmp.put(LanguageTranslator.getString("activity.crew"), s != null ? s.getCrew() : 0);
        tmp.put(LanguageTranslator.getString("activity.rest"), s != null ? s.getRest() : 0);
        tmp.put(LanguageTranslator.getString("offence.type.dailyRest"), s != null ? s.getDailyRest() : 0);
        tmp.put(LanguageTranslator.getString("activity.other"), s != null ? s.getOther() : 0);
        tmp.put(LanguageTranslator.getString("activity.unknown"), s != null ? s.getUnk() : 0);
        tmp.put(LanguageTranslator.getString("generics.serviceTotal"), s != null ? s.getService() : 0);
        tmp.put(LanguageTranslator.getString("activity.amplitude"), s != null ? s.getAmplitude() : 0);
        tmp.put(LanguageTranslator.getString("generics.nightTime"), s != null ? s.getNight() : 0);
        tmp.put("DATE_DEBUT", debut);
        tmp.put("DATE_FIN", s != null ? ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd HH:mm") : null);
        tmp.put("SEMAINE", Long.parseLong(ConversionTime.dateToString(debut, "w")));
        tmp.put("CONDUITE", s != null ? s.getDriving() : 0);
        tmp.put("TRAVAIL", s != null ? s.getWork() : 0);
        tmp.put("DISPO", s != null ? s.getAvailability() : 0);
        tmp.put("DOUBLE_EQUIPAGE", s != null ? s.getCrew() : 0);
        tmp.put("REPOS", s != null ? s.getRest() : 0);
        tmp.put("REPOS_JOURNALIER", s != null ? s.getDailyRest() : 0);
        tmp.put("AUTRE_SERVICE", s != null ? s.getOther() : 0);
        tmp.put("INCONNU", s != null ? s.getUnk() : 0);
        tmp.put("SERVICE", s != null ? s.getService() : 0);
        tmp.put("AMPLITUDE", s != null ? s.getAmplitude() : 0);
        tmp.put("HEURE_NUIT", s != null ? s.getNight() : 0);
        if (System.getProperty("company", "PGH").equals("salvesen") && remuneration == 0 && senority) {
            return;
        }
        tmp.put("REMUNERATION", remuneration);
        tmp.put("BASE_HS", (s != null ? s.getService() : 0) + genereHS);
        tmp.put("DESIGNATION", designation.length() != 0 ? designation.substring(2) : "");
        tmp.put("DUREE", duree);
        tmp.put("FRAIS", Float.valueOf(expensesAmount));
        if (toFill != null && toFill.size() != 0) {
            tmp.put("IMMATRICULATION", toFill.get(0)[0]);
            tmp.put("DISTANCE", toFill.get(0)[1]);
        }
        this.data.add(tmp);
        if (toFill != null) {
            int x = 1;
            while (x < toFill.size()) {
                tmp = new HashMap();
                tmp.put("SEMAINE", Long.parseLong(ConversionTime.dateToString(debut, "w")));
                tmp.put("IMMATRICULATION", toFill.get(x)[0]);
                tmp.put("DISTANCE", toFill.get(x)[1]);
                tmp.put("FRAIS", null);
                this.data.add(tmp);
                ++x;
            }
        }
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + (tmp.get(value) != null ? tmp.get(value).toString() : "null") + "   ");
            }
        }
    }
}

