/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.ContractNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class PayChecking
extends DynamicGeneric {
    private Collection<Map<String, ?>> data = null;
    int workday = 0;

    public PayChecking() {
        this.setGenerator(new DJGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicService.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getPayCheckingDefault();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
    }

    @Override
    public void process() {
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        this.workday = ConversionTime.getWorkday(this.begin, this.end);
        Vector<TypeContrat> contractList = TypeContrat.loadList();
        this.data = new ArrayList();
        boolean distribution = true;
        int workedTime = 0;
        int workedDay = 0;
        int firstRule = 0;
        int secondRule = 0;
        int thirdRule = 0;
        int fourstRule = 0;
        int driving = 0;
        int night = 0;
        int rest = 0;
        int coupure = 0;
        int satHour = 0;
        int satDayCount = 0;
        int altPaidHour = 0;
        int altGenerateHSHour = 0;
        int altDayCount = 0;
        this.pb.getBar().setMaximum(this.agencies.size() + this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            Vector<String> dayTypeOnly = new Vector<String>();
            this.pb.getBar().setString(currentAgency.getDescription());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            Vector<Service> tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Vector<LienJourConducteur> others = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Conducteur currentDriver = null;
            int defaultDayLength = 0;
            TimsLogger.debug("#PayChecking.process()# " + tmpS.size() + " services");
            if (tmpS.size() == 0) continue;
            for (Service s : tmpS) {
                if (currentDriver == null || s.getDriverId() != currentDriver.getCleConducteur()) {
                    if (currentDriver != null) {
                        try {
                            TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                            this.data.add(this.fillMap(currentDriver, contrat, workedDay, workedTime, driving, rest, coupure, night, firstRule, secondRule, thirdRule, fourstRule, altPaidHour, altGenerateHSHour, satHour, satDayCount, distribution, currentAgency));
                        }
                        catch (ContractNotFoundException ex) {
                            TimsLogger.warn("No contract for " + currentDriver.getCleTypeContrat() + " (" + currentDriver.getNom() + ")");
                        }
                    }
                    workedTime = 0;
                    workedDay = 0;
                    firstRule = 0;
                    secondRule = 0;
                    thirdRule = 0;
                    fourstRule = 0;
                    driving = 0;
                    night = 0;
                    rest = 0;
                    coupure = 0;
                    satHour = 0;
                    satDayCount = 0;
                    altPaidHour = 0;
                    altGenerateHSHour = 0;
                    altDayCount = 0;
                    dayTypeOnly.clear();
                    try {
                        currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, s.getDriverId());
                        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                            try {
                                TypeContrat driverContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                                defaultDayLength = driverContract.getDailyValue();
                            }
                            catch (TypeContratNotFoundException ex) {
                                TimsLogger.warn("Contrat " + currentDriver.getCleTypeContrat() + " introuvable pour " + currentDriver.getNom());
                            }
                        }
                    }
                    catch (DriverNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    TimsLogger.debug(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getNightDay());
                    this.pb.getBar().setString(String.valueOf(currentAgency.getDescription()) + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    for (LienJourConducteur tmp : others) {
                        int day;
                        JourType dayType = tmp.getDayType();
                        if (tmp.getCleConducteur() != currentDriver.getCleConducteur()) continue;
                        boolean shouldPay = dayType.shouldPay(currentDriver, tmp.getDateJour());
                        if (dayType.isPaid() && shouldPay && !dayType.isGenerateHS()) {
                            altPaidHour += tmp.getDuree(defaultDayLength);
                        }
                        if (dayType.isGenerateHS() && shouldPay) {
                            altGenerateHSHour += tmp.getDuree(defaultDayLength);
                        }
                        if (tmp.getType() == 2) {
                            day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false);
                            if (day != 7 && day != 1) {
                                ++altDayCount;
                            }
                        } else if (tmp.getType() == 1 && LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() > 1 && (day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false)) != 7 && day != 1) {
                            ++altDayCount;
                        }
                        if (!dayType.isServiceIncluded() || tmp.getType() != 2 && (!System.getProperty("company", "PGH").equals("salvesen") || tmp.getDuree(defaultDayLength) < 420)) continue;
                        TimsLogger.debug("#PayChecking.process# no service possible on " + tmp.getDateJour());
                        dayTypeOnly.add(ConversionTime.dateToString(tmp.getDateJour(), "yyyy-MM-dd"));
                    }
                }
                if (currentDriver.getNightDay() == 0 && ConversionTime.getNbJourBetween(s.getBeginDate().substring(0, 10), s.getEndDate().substring(0, 10), "yyyy-MM-dd") >= 1 || currentDriver.getNightDay() == 2) {
                    distribution = false;
                }
                if (dayTypeOnly.contains(s.getBeginDate().substring(0, 10))) {
                    TimsLogger.debug("#PayChecking.process# Unauthorized service on " + s.getBeginDate());
                    continue;
                }
                if (ConversionTime.getDayOfWeek(s.getBeginDate(), "yyyy-MM-dd HH:mm:ss", false) == 7) {
                    satHour += s.getService();
                    ++satDayCount;
                    night += s.getNight();
                    continue;
                }
                rest += s.getRest();
                driving += s.getDriving();
                night += s.getNight();
                coupure += s.getCut();
                workedTime += s.getService();
                ++workedDay;
                workedDay += ConversionTime.getNbJourBetween(s.getBeginDate(), s.getEndDate(), "yyyy-MM-dd HH:mm:ss");
                firstRule += s.getFirstWork();
                secondRule += s.getLastWork();
                thirdRule += s.getFirstWorkAfterRest();
                fourstRule += s.getSecondWorkAfterRest();
            }
            try {
                TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                this.data.add(this.fillMap(currentDriver, contrat, workedDay, workedTime, driving, rest, coupure, night, firstRule, secondRule, thirdRule, fourstRule, altPaidHour, altGenerateHSHour, satHour, satDayCount, distribution, currentAgency));
            }
            catch (ContractNotFoundException ex) {
                TimsLogger.warn("Contrat non trouv\u00e9");
            }
        }
        try {
            this.load(new JRMapCollectionDataSource(this.data), this.report.getCustomizedName());
            this.data.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Conducteur driver, TypeContrat contract, int workedDay, int workedTime, int driving, int rest, int coupure, int night, int firstRule, int secondRule, int thirdRule, int fourstRule, int altPaidHour, int altGenerateHSHour, int satHour, int satDayCount, boolean distribution, Agence agency) {
        TimsLogger.debug(String.valueOf(driver.getNom()) + " worked day = " + workedDay + ", workedTime=" + workedTime + ", altPaidHour=" + altPaidHour + ", altGenerateHSHour=" + altGenerateHSHour + ", satHour=" + satHour + ", satDayCount=" + satDayCount + ", firstRule=" + firstRule + ", secondRule=" + secondRule + ", thirdRule=" + thirdRule + ", fourstRule=" + fourstRule);
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(driver.getNom()) + " " + driver.getPrenom());
        tmp.put(LanguageTranslator.getString("user.registration"), driver.getMatricule());
        tmp.put(LanguageTranslator.getString("contract.hour"), contract.getContractHour());
        tmp.put(LanguageTranslator.getString("generics.workedDay"), workedDay + satDayCount);
        tmp.put(LanguageTranslator.getString("report.pp.service"), workedTime + satHour);
        tmp.put(LanguageTranslator.getString("report.pp.hs"), altGenerateHSHour);
        tmp.put(LanguageTranslator.getString("report.pp.total"), workedTime + altGenerateHSHour + satHour);
        tmp.put(LanguageTranslator.getString("report.pp.abs"), altPaidHour);
        tmp.put(LanguageTranslator.getString("report.pp.hsBase"), workedTime + altGenerateHSHour + altPaidHour);
        tmp.put(LanguageTranslator.getString("generics.nightTime"), night);
        return tmp;
    }
}

