/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.ContractNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transport.report.MasterReport;

public class Projection
extends MasterReport {
    private Collection<Map<String, ?>> data = null;
    int workday = 0;

    @Override
    public void process() {
        this.workday = ConversionTime.getWorkday(this.begin, this.end);
        Vector<TypeContrat> contractList = TypeContrat.loadList();
        this.data = new ArrayList();
        int workedTime = 0;
        int workedDay = 0;
        int hourProj = 0;
        int satHour = 0;
        int satDayCount = 0;
        int altPaidHour = 0;
        int altGenerateHSHour = 0;
        int altDayCount = 0;
        int altPaidHour2 = 0;
        int altGenerateHSHour2 = 0;
        this.pb.getBar().setMaximum(this.agencies.size() + this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            this.pb.getBar().setString(currentAgency.getDescription());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            Vector<Service> tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Vector<LienJourConducteur> others = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Conducteur currentDriver = null;
            int defaultDayLength = 0;
            TimsLogger.info("#ARProjection.process()# " + others.size() + " others");
            if (tmpS.size() == 0 && others.size() == 0) continue;
            for (Service s : tmpS) {
                if (currentDriver == null || s.getDriverId() != currentDriver.getCleConducteur()) {
                    try {
                        if (currentDriver != null) {
                            for (LienJourConducteur tmp : others) {
                                if (tmp.getCleConducteur() != currentDriver.getCleConducteur()) continue;
                                JourType jt = tmp.getDayType();
                                if (jt.isPaid()) {
                                    altPaidHour += tmp.getDuree(defaultDayLength);
                                }
                                if (jt.isWillBePaid()) {
                                    altPaidHour2 += tmp.getFutureDuree();
                                }
                                if (jt.isGenerateHS()) {
                                    altGenerateHSHour += tmp.getDuree(defaultDayLength);
                                }
                                if (jt.isWillGenerateHS()) {
                                    altGenerateHSHour2 += tmp.getFutureDuree();
                                }
                                if (tmp.getType() == 2) {
                                    ++altDayCount;
                                    continue;
                                }
                                if (tmp.getType() != 1 || LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() <= 1) continue;
                                ++altDayCount;
                            }
                            float moyenne = workedDay <= 0 ? 0.0f : (float)workedTime / (float)workedDay;
                            hourProj = (int)(moyenne * (float)(this.workday - altDayCount));
                            TimsLogger.debug("workedTime : " + workedTime + ", workedDay : " + workedDay + ", moyenne : " + moyenne + ", workday : " + this.workday + ", altDayCount : " + altDayCount);
                            TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                            this.data.add(this.fillMap(currentDriver, contrat, workedDay, workedTime, hourProj, altPaidHour, altGenerateHSHour, altPaidHour2, altGenerateHSHour2, satHour, satDayCount));
                        }
                        workedTime = 0;
                        workedDay = 0;
                        hourProj = 0;
                        satHour = 0;
                        satDayCount = 0;
                        altPaidHour = 0;
                        altGenerateHSHour = 0;
                        altDayCount = 0;
                        altPaidHour2 = 0;
                        altGenerateHSHour2 = 0;
                        currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, s.getDriverId());
                        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                            try {
                                TypeContrat driverContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                                defaultDayLength = driverContract.getDailyValue();
                            }
                            catch (TypeContratNotFoundException ex) {
                                TimsLogger.warn("Contrat " + currentDriver.getCleTypeContrat() + " introuvable pour " + currentDriver.getNom());
                            }
                        }
                        this.pb.getBar().setString(String.valueOf(currentAgency.getDescription()) + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                        this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    }
                    catch (DriverNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (ContractNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
                if (ConversionTime.getDayOfWeek(s.getBeginDate(), "yyyy-MM-dd HH:mm:ss", false) == 7) {
                    satHour += s.getService();
                    ++satDayCount;
                    continue;
                }
                workedTime += s.getService();
                ++workedDay;
                workedDay += ConversionTime.getNbJourBetween(s.getBeginDate(), s.getEndDate(), "yyyy-MM-dd HH:mm:ss");
            }
            for (LienJourConducteur tmp : others) {
                if (tmp.getCleConducteur() != currentDriver.getCleConducteur()) continue;
                JourType jt = tmp.getDayType();
                if (jt.isPaid()) {
                    altPaidHour += tmp.getDuree(defaultDayLength);
                }
                if (jt.isWillBePaid()) {
                    altPaidHour2 += tmp.getFutureDuree();
                }
                if (jt.isGenerateHS()) {
                    altGenerateHSHour += tmp.getDuree(defaultDayLength);
                }
                if (jt.isWillGenerateHS()) {
                    altGenerateHSHour2 += tmp.getFutureDuree();
                }
                if (tmp.getType() == 2) {
                    ++altDayCount;
                    continue;
                }
                if (tmp.getType() != 1 || LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() <= 1) continue;
                ++altDayCount;
            }
            float moyenne = workedDay <= 0 ? 0.0f : (float)workedTime / (float)workedDay;
            hourProj = (int)(moyenne * (float)(this.workday - altDayCount));
            try {
                TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                this.data.add(this.fillMap(currentDriver, contrat, workedDay, workedTime, hourProj, altPaidHour, altGenerateHSHour, altPaidHour2, altGenerateHSHour2, satHour, satDayCount));
            }
            catch (ContractNotFoundException ex) {
                ex.printStackTrace();
            }
            try {
                this.loadReport(currentAgency, new JRMapCollectionDataSource(this.data));
                this.data.clear();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Conducteur driver, TypeContrat contract, int workedDay, int workedTime, int projection, int altPaidHour, int altGenerateHSHour, int altPaidHour2, int altGenerateHSHour2, int satHour, int satDayCount) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        int baseHS = projection + altGenerateHSHour + satHour;
        int baseHS2 = projection + altGenerateHSHour2 + satHour;
        int hs25 = 0;
        int hs50 = 0;
        int hs252 = 0;
        int hs502 = 0;
        if (baseHS > contract.getSeuilHS25(2)) {
            hs50 = baseHS - contract.getSeuilHS25(2);
            hs25 = contract.getSeuilHS25(2) - contract.getSeuilHN(2);
        } else if (baseHS > contract.getSeuilHN(2)) {
            hs25 = baseHS - contract.getSeuilHN(2);
        }
        if (baseHS2 > contract.getSeuilHS25(2)) {
            hs502 = baseHS2 - contract.getSeuilHS25(2);
            hs252 = contract.getSeuilHS25(2) - contract.getSeuilHN(2);
        } else if (baseHS2 > contract.getSeuilHN(2)) {
            hs252 = baseHS2 - contract.getSeuilHN(2);
        }
        tmp.put("FIRST_NAME", driver.getPrenom());
        tmp.put("LAST_NAME", driver.getNom());
        tmp.put("MATRICULE", driver.getMatricule());
        tmp.put("WORKED_DAY", workedDay + satDayCount);
        tmp.put("DAY_PERIOD", this.workday);
        tmp.put("WORKED_TIME", workedTime + satHour);
        tmp.put("CONTRACT_TIME", contract.getContractHour());
        tmp.put("PROJECTION", projection + altPaidHour + satHour);
        tmp.put("HS25", hs25);
        tmp.put("HS50", hs50);
        tmp.put("MAXIMUM", projection + altPaidHour + satHour <= contract.getMaximumHour() ? "N" : "O");
        tmp.put("PROJECTION2", projection + altPaidHour2 + satHour);
        tmp.put("HS252", hs252);
        tmp.put("HS502", hs502);
        tmp.put("MAXIMUM2", projection + altPaidHour2 + satHour <= contract.getMaximumHour() ? "N" : "O");
        TimsLogger.debug(String.valueOf(driver.getPrenom()) + " PROJECTION : " + Integer.valueOf(projection + altPaidHour + satHour) + " PROJECTION2 : " + Integer.valueOf(projection + altPaidHour2 + satHour));
        return tmp;
    }
}

