/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.RoundType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJRoundAnalysisGenerator;

public class RoundAnalysis
extends DynamicGeneric {
    private Collection<Map<String, ?>> data = null;

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getRoundAnalysis();
        this.customReport.setName(this.report.getCustomizedName());
        this.setGenerator(new DJRoundAnalysisGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#" + this.getClass().getName() + ".process# error on compilation");
            ex.printStackTrace();
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setMaximum(this.agencies.size() + 1);
        }
        if (this.pb != null) {
            this.pb.getBar().setMinimum(0);
        }
        for (Agence agency : this.agencies) {
            if (this.pb != null) {
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            if (this.pb != null) {
                this.pb.getBar().setString(String.valueOf(agency.getDescription()) + " : " + LanguageTranslator.getString("round.loading"));
            }
            this.data = new ArrayList();
            Vector<RoundAffectation> list = RoundAffectation.loadList(agency.getCleAgence(), 0, 0, this.begin, this.end, null);
            if (this.pb != null) {
                this.pb.getBar().setString(String.valueOf(agency.getDescription()) + " : " + LanguageTranslator.getString("round.processing"));
            }
            for (RoundAffectation round : list) {
                RoundType rt = RoundType.getRoundType(null, round.getRoundId());
                if (!round.isDone()) continue;
                HashMap<String, Object> roundData = new HashMap<String, Object>();
                Conducteur driver = null;
                try {
                    driver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, round.getDriverId());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                roundData.put(LanguageTranslator.getString("generics.date"), round.getRoundDate());
                roundData.put(LanguageTranslator.getString("generics.driver"), driver == null ? "" : String.valueOf(driver.getNom()) + " " + driver.getPrenom());
                roundData.put(LanguageTranslator.getString("generics.round"), rt.getCode());
                roundData.put(LanguageTranslator.getString("round.beginTimeDiff"), round.getBeginTime() - rt.getBeginTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.beginTimeDiff")) + "_THRESHOLD1", 0);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.beginTimeDiff")) + "_THRESHOLD2", 5);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.beginTimeDiff")) + "_DONE", round.getBeginTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.beginTimeDiff")) + "_PREV", rt.getBeginTime());
                roundData.put(LanguageTranslator.getString("round.loadDurationDiff"), round.getLoadTime() - rt.getLoadTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.loadDurationDiff")) + "_THRESHOLD1", 0);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.loadDurationDiff")) + "_THRESHOLD2", 5);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.loadDurationDiff")) + "_DONE", round.getLoadTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.loadDurationDiff")) + "_PREV", rt.getLoadTime());
                roundData.put(LanguageTranslator.getString("round.unloadDurationDiff"), round.getUnloadTime() - rt.getUnloadTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.unloadDurationDiff")) + "_THRESHOLD1", 0);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.unloadDurationDiff")) + "_THRESHOLD2", 5);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.unloadDurationDiff")) + "_DONE", round.getUnloadTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.unloadDurationDiff")) + "_PREV", rt.getUnloadTime());
                roundData.put(LanguageTranslator.getString("round.totalTimeDiff"), round.getTotalTime() - rt.getTotalTime());
                int avgDone = round.getClientDelivered() == 0 ? -1 : round.getDeliveryTime() / round.getClientDelivered();
                roundData.put(LanguageTranslator.getString("round.avgDeliveryTimeDiff"), avgDone - rt.getAvgDeliveryTime());
                roundData.put(String.valueOf(LanguageTranslator.getString("round.avgDeliveryTimeDiff")) + "_THRESHOLD1", 0);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.avgDeliveryTimeDiff")) + "_THRESHOLD2", 5);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.avgDeliveryTimeDiff")) + "_DONE", avgDone);
                roundData.put(String.valueOf(LanguageTranslator.getString("round.avgDeliveryTimeDiff")) + "_PREV", rt.getAvgDeliveryTime());
                this.data.add(roundData);
            }
            try {
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(agency.getDescription()) + " : " + LanguageTranslator.getString("report.generation"));
                }
                this.loadReport(agency, new JRMapCollectionDataSource(this.data));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.pb != null) {
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("report.generation"));
        }
        this.generate();
    }
}

