/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transport.report.MasterReport;

public class ServiceSynthese
extends MasterReport {
    private Collection<Map<String, ?>> data = null;

    /*
     * Unable to fully structure code
     */
    @Override
    public void process() {
        if (Transport.apiMode == 0) {
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
        }
        this.userParameters.put("TITLE", this.report.getCustomizedName());
        if (this.data == null) {
            this.data = new ArrayList<Map<String, ?>>();
        }
        tmpS = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        tmpL = LienJourConducteur.loadList(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        tmpEx = DriverExpenses.loadList(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        TimsLogger.info("#ServiceSynthese.process()# " + tmpS.size() + " services, " + tmpL.size() + " jours");
        ljc = new Vector<LienJourConducteur>();
        x = 0;
        while (x < this.drivers.size()) {
            block26: {
                currentContract = null;
                defaultDayLength = 0;
                currentDriver = (Conducteur)this.drivers.get(x);
                requirements = true;
                try {
                    TimsLogger.debug("#serviceSynthese.process# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                    currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                    if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                        defaultDayLength = currentContract.getDailyValue();
                    }
                }
                catch (TypeContratNotFoundException ex) {
                    requirements = false;
                    this.warningList.add(currentDriver);
                    System.err.println("#serviceSynthese.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat() + " driver " + currentDriver.getNom());
                    if (Transport.debug < 1) break block26;
                    ex.printStackTrace();
                }
            }
            if (Transport.apiMode == 0) {
                this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            tmpC = null;
            if (currentDriver.getCalendarId() != 0) {
                tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
            }
            driverExp = this.getDriverExpenses(tmpEx, currentDriver.getCleConducteur());
            serviceLeft = true;
            ljcLeft = true;
            expLeft = true;
            day = this.begin;
            while (day.compareTo(this.end) <= 0) {
                block27: {
                    TimsLogger.debug("#serviceSynthese.process# (" + currentDriver.getCleConducteur() + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy"));
                    s = null;
                    second = null;
                    ljc.clear();
                    if (serviceLeft && tmpS.size() != 0) {
                        if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                            serviceLeft = false;
                        } else if (day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                            s = tmpS.get(0);
                            tmpS.remove(0);
                            if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                second = tmpS.get(0);
                                tmpS.remove(0);
                            }
                        }
                    }
                    if (!ljcLeft || tmpL.size() == 0) break block27;
                    if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl70
                    ljcLeft = false;
                    TimsLogger.debug("#serviceSynthese.process# endOfLjc (" + tmpL.get(0).getCleConducteur() + ")");
                    break block27;
lbl-1000:
                    // 1 sources

                    {
                        ljc.add(tmpL.get(0));
                        tmpL.remove(0);
lbl70:
                        // 2 sources

                        ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                    }
                }
                if (tmpC != null) {
                    y = 0;
                    while (y < tmpC.size()) {
                        if (day.equals(tmpC.get(y).getDate())) {
                            toAdd = new LienJourConducteur();
                            toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                            ljc.add((LienJourConducteur)toAdd);
                            tmpC.remove(y);
                            break;
                        }
                        ++y;
                    }
                }
                expensesAmount = this.findDriverExpenses(driverExp, day);
                if (s == null && (ljc == null || ljc.size() == 0) && expensesAmount == 0.0f) {
                    TimsLogger.debug("#serviceSynthese.process# aucune donn\u00e9es");
                } else if (requirements) {
                    toAdd = this.fillMap(currentDriver, day, s, ljc, defaultDayLength, expensesAmount);
                    if (toAdd != null) {
                        this.data.add(toAdd);
                    }
                    if (second != null) {
                        this.data.add(this.fillMap(currentDriver, day, second, null, defaultDayLength, 0.0f));
                    }
                }
                day = ConversionTime.addDay(day, 1);
            }
            try {
                this.afficheData();
                this.getUserParameter().put("CALCULATION_TYPE", currentContract.getCalculationType());
                this.getUserParameter().put("SEUIL_HN", currentContract.getSeuilHN(-1));
                this.getUserParameter().put("SEUIL_HS25", currentContract.getSeuilHS25(-1));
                this.getUserParameter().put("MATRICULE_CONDUCTEUR", currentDriver.getMatricule());
                this.getUserParameter().put("NAME", this.report.getCustomizedName());
                this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
                if (this.userParameters.get("separate") != null) {
                    this.generate();
                }
                this.data.clear();
            }
            catch (Exception ex) {
                TimsLogger.warn("#serviceSynthese.process# An error occured while generating aac report for " + currentDriver.getNom());
                ex.printStackTrace();
            }
            TimsLogger.debug("#serviceSynthese.process# C'est la fin du conducteur " + currentDriver.getNom());
            ++x;
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Conducteur driver, Date debut, Service s, Vector<LienJourConducteur> l, int defaultDayLength, float expensesAmount) {
        if (s != null) {
            s.affiche();
        }
        if (l != null && l.size() != 0) {
            l.get(0).affiche();
        }
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        int duree = 0;
        int genereHS = 0;
        int remuneration = 0;
        boolean serviceIncluded = false;
        boolean senority = true;
        String designation = "";
        try {
            if (l != null && l.size() != 0) {
                for (LienJourConducteur ljc : l) {
                    JourType dayType = JourType.getDayType(ljc.getCleJourType());
                    if (dayType.isPaid()) {
                        if (dayType.isServiceIncluded() && (ljc.getType() == 2 || System.getProperty("company", "PGH").equals("salvesen") && ljc.getDuree(defaultDayLength) >= 420)) {
                            serviceIncluded = true;
                        }
                        if (dayType.shouldPay(driver, ljc.getDateJour())) {
                            remuneration += ljc.getDuree(defaultDayLength);
                        } else {
                            senority = false;
                        }
                    }
                    if (dayType.isGenerateHS() && dayType.shouldPay(driver, ljc.getDateJour())) {
                        genereHS += ljc.getDuree(defaultDayLength);
                    }
                    if (System.getProperty("company", "PGH").equals("salvsesen")) {
                        if (!dayType.isPaid()) continue;
                        designation = String.valueOf(designation) + ", " + JourType.getDayType(ljc.getCleJourType()).getCode();
                        duree += ljc.getDuree(defaultDayLength);
                        continue;
                    }
                    designation = String.valueOf(designation) + ", " + JourType.getDayType(ljc.getCleJourType()).getCode();
                    if ("1".equals(System.getProperty("hide.unpaid", "0"))) {
                        if (!dayType.isPaid()) continue;
                        duree += ljc.getDuree(defaultDayLength);
                        continue;
                    }
                    duree += ljc.getDuree(defaultDayLength);
                }
            }
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#ServiceSynthese.fillMap# DayType " + l.get(0).getCleJourType() + " not found");
        }
        if (!serviceIncluded) {
            remuneration += s != null ? s.getService() : 0;
        }
        if (s != null) {
            debut = ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd HH:mm");
        }
        tmp.put("DATE_DEBUT", debut);
        tmp.put("DATE_FIN", s != null ? ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd HH:mm") : debut);
        Long week = Long.parseLong(ConversionTime.dateToString(debut, "w"));
        if (ConversionTime.getDayOfWeek(debut, false) == 1) {
            week = week + 1L;
        }
        tmp.put("SEMAINE", week);
        tmp.put("CONDUITE", s != null && !serviceIncluded ? s.getDriving() : 0);
        tmp.put("TRAVAIL", s != null && !serviceIncluded ? s.getWork() : 0);
        tmp.put("DISPO", s != null && !serviceIncluded ? s.getAvailability() : 0);
        tmp.put("DOUBLE_EQUIPAGE", s != null && !serviceIncluded ? s.getCrew() : 0);
        tmp.put("REPOS", s != null && !serviceIncluded ? s.getRest() : 0);
        tmp.put("AUTRE_SERVICE", s != null && !serviceIncluded ? s.getOther() : 0);
        tmp.put("INCONNU", s != null && !serviceIncluded ? s.getUnk() : 0);
        tmp.put("SERVICE", s != null && !serviceIncluded ? s.getService() : 0);
        tmp.put("AMPLITUDE", s != null && !serviceIncluded ? s.getAmplitude() : 0);
        tmp.put("DISTANCE", s != null ? s.getDistance() : 0);
        tmp.put("HEURE_NUIT", s != null && !serviceIncluded ? s.getNight() : 0);
        if (System.getProperty("company", "PGH").equals("salvesen") && (remuneration == 0 || !senority)) {
            TimsLogger.debug("Sp\u00e9cifique salvesen, on saute la ligne");
            return null;
        }
        tmp.put("BASE_HS", (s != null ? s.getService() : 0) + genereHS);
        tmp.put("REMUNERATION", remuneration);
        tmp.put("DESIGNATION", designation.length() != 0 ? designation.substring(2) : "");
        tmp.put("DUREE", duree);
        tmp.put("FRAIS", Float.valueOf(expensesAmount));
        return tmp;
    }

    private float findDriverExpenses(Vector<DriverExpenses> driverExp, Date day) {
        float amount = 0.0f;
        int y = 0;
        while (y < driverExp.size()) {
            DriverExpenses tmp = driverExp.get(y);
            if (tmp.getDate().equals(day)) {
                amount += tmp.getAmount();
                driverExp.remove(y);
                --y;
            }
            ++y;
        }
        return amount;
    }

    private Vector<DriverExpenses> getDriverExpenses(Vector<DriverExpenses> fullList, int driverId) {
        Vector<DriverExpenses> toReturn = new Vector<DriverExpenses>();
        boolean driverFound = false;
        int y = 0;
        while (y < fullList.size()) {
            DriverExpenses tmp = fullList.get(y);
            if (tmp.getDriverId() == driverId) {
                driverFound = true;
                toReturn.add(tmp);
                fullList.remove(y);
                --y;
            } else if (driverFound) break;
            ++y;
        }
        return toReturn;
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

