/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class UnfilledAccident
extends DynamicGeneric {
    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
    }

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getUnfilledAccident();
        this.customReport.setName(this.report.getCustomizedName());
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        this.data = new ArrayList();
        Vector<Accident> tmp = Accident.loadList(this.agencies.size() == 1 ? (Agence)this.agencies.get(0) : null, this.begin, this.end);
        String unk = LanguageTranslator.getString("generics.unknown");
        for (Accident toAdd : tmp) {
            if (ConversionTime.getDaysBetween(toAdd.getDay(), new Date()) > 10 && toAdd.getInsuranceNumber() != null && !toAdd.getInsuranceNumber().equals("") && (!toAdd.isInTraffic() || toAdd.getIdentificationNumber() != null && !toAdd.getIdentificationNumber().equals(""))) continue;
            Agence agency = null;
            Vehicule vehicle = null;
            Conducteur driver = null;
            try {
                vehicle = Vehicule.getVehicule((Vector<Vehicule>)this.vehicles, toAdd.getVehicleId());
                agency = Agence.find(this.agencies, toAdd.getAgencyId());
            }
            catch (DBObjectNotFoundException e) {
                TimsLogger.warn("#UnfilledAccident.process()# Vehicle or VehicleAnalyticCode has not been found ");
            }
            try {
                driver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, toAdd.getDriverId());
            }
            catch (DriverNotFoundException e) {
                TimsLogger.warn("#UnfilledAccident.process()# Vehicle or Driver has not been found ");
            }
            HashMap<String, Object> acc = new HashMap<String, Object>();
            acc.put(LanguageTranslator.getString("generics.agency"), agency == null ? unk : agency.getDescription());
            acc.put(LanguageTranslator.getString("generics.driver"), driver == null ? unk : String.valueOf(driver.getNom()) + " " + driver.getPrenom());
            acc.put(LanguageTranslator.getString("vehicle.registrationNumber"), vehicle == null ? unk : vehicle.getRegistrationNumber());
            acc.put(LanguageTranslator.getString("accident.identification"), toAdd.getIdentificationNumber());
            acc.put(LanguageTranslator.getString("accident.insuranceNumber"), toAdd.getInsuranceNumber());
            acc.put(LanguageTranslator.getString("generics.date"), toAdd.getDay());
            this.data.add(acc);
        }
        try {
            this.load(new JRMapCollectionDataSource((Collection)this.data), LanguageTranslator.getString("report.accident"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }
}

