/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.Utilisateur;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.VerticalAlignment;
import jxl.write.Boolean;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class UserDetail {
    public void generate() {
        JFileChooser choix = new JFileChooser();
        choix.setDialogTitle(LanguageTranslator.getString("file.savePath"));
        choix.setApproveButtonText(LanguageTranslator.getString("button.save"));
        choix.setFileSelectionMode(1);
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            File destination = new File(String.valueOf(choix.getSelectedFile().getAbsolutePath()) + "//" + LanguageTranslator.getString("user") + ".xls");
            if (destination.exists()) {
                destination.delete();
                destination = new File(String.valueOf(choix.getSelectedFile().getAbsolutePath()) + "//" + LanguageTranslator.getString("user") + ".xls");
            }
            try {
                WritableWorkbook workbook = Workbook.createWorkbook((File)destination);
                Vector<Utilisateur> list = Utilisateur.list("");
                Vector<Profil> plist = Profil.list();
                WritableSheet sheet = workbook.createSheet("feuille", 0);
                WritableCellFormat center = new WritableCellFormat();
                center.setAlignment(Alignment.CENTRE);
                center.setVerticalAlignment(VerticalAlignment.CENTRE);
                Label f = new Label(0, 0, "NOM");
                sheet.addCell((WritableCell)f);
                Label c = new Label(1, 0, "PRENOM");
                c.setCellFormat((CellFormat)center);
                sheet.addCell((WritableCell)c);
                Label v = new Label(2, 0, "LOGIN");
                v.setCellFormat((CellFormat)center);
                sheet.addCell((WritableCell)v);
                Label m = new Label(3, 0, "SOCIETE");
                m.setCellFormat((CellFormat)center);
                sheet.addCell((WritableCell)m);
                Label s = new Label(4, 0, "PROFIL");
                s.setCellFormat((CellFormat)center);
                sheet.addCell((WritableCell)s);
                Label lrs = new Label(5, 0, "RES. SOC.");
                sheet.addCell((WritableCell)lrs);
                Label lra = new Label(6, 0, "RES. AGENCE");
                sheet.addCell((WritableCell)lra);
                Label lrc = new Label(7, 0, "RES. COND.");
                sheet.addCell((WritableCell)lrc);
                int x = 0;
                while (x < list.size()) {
                    Utilisateur toWrite = list.get(x);
                    Label nomdroit = new Label(0, x + 1, toWrite.getNom());
                    sheet.addCell((WritableCell)nomdroit);
                    Label cd = new Label(1, x + 1, toWrite.getPrenom());
                    sheet.addCell((WritableCell)cd);
                    Label vd = new Label(2, x + 1, toWrite.getLogin());
                    sheet.addCell((WritableCell)vd);
                    Label md = new Label(3, x + 1, toWrite.getSociete());
                    sheet.addCell((WritableCell)md);
                    Label sd = new Label(4, x + 1, String.valueOf(this.getNom(plist, toWrite.getCleProfil())));
                    sheet.addCell((WritableCell)sd);
                    Boolean rs = new Boolean(5, x + 1, toWrite.isRestreintSociete());
                    sheet.addCell((WritableCell)rs);
                    Boolean ra = new Boolean(6, x + 1, toWrite.isRestreintAgence());
                    sheet.addCell((WritableCell)ra);
                    Boolean rc = new Boolean(7, x + 1, toWrite.isRestreintConducteur());
                    sheet.addCell((WritableCell)rc);
                    ++x;
                }
                workbook.write();
                workbook.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.done"));
        }
    }

    private String getNom(Vector<Profil> list, int cle) {
        for (Profil tmp : list) {
            if (tmp.getCle() != cle) continue;
            return tmp.getNomProfil();
        }
        return "";
    }
}

