/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class VehicleOffence
extends DynamicGeneric {
    private Collection<Map<String, ?>> data = null;

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getVehicleOffence();
        this.customReport.setName(this.report.getCustomizedName());
        this.customReport.getProperties().putAll(this.userParameters);
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#VehicleOffence.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setMaximum(this.vehicles.size());
        }
        if (this.pb != null) {
            this.pb.getBar().setMinimum(0);
        }
        String sBegin = ConversionTime.dateToString(this.begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(this.end, "yyyy-MM-dd");
        ArrayList<UevOffence> offenceUev = UevOffence.load(null, this.vehicles, sBegin, sEnd);
        TimsLogger.info("#VehicleOffence.process()# " + offenceUev.size() + " event");
        this.data = new ArrayList();
        for (UevOffence offence : offenceUev) {
            if (offence.getOffenceTypeId() == 1) {
                if (offence.getLength() <= Integer.parseInt(System.getProperty("cardless.threshold", "0"))) continue;
                this.fillMap(offence);
                continue;
            }
            this.fillMap(offence);
        }
        try {
            this.load(new JRMapCollectionDataSource(this.data), "infraction v\u00e9hicule");
            this.data.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.generate();
    }

    public Map<String, Object> fillMap(UevOffence off) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        try {
            Vehicule currentVehicle = Vehicule.getVehicule((Vector<Vehicule>)this.vehicles, off.getVehicleId());
            Agence currentAgency = Agence.find(this.agencies, currentVehicle.getAgencyId());
            Conducteur driver = null;
            try {
                driver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, off.getDriverId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            tmp.put(LanguageTranslator.getString("generics.agency"), currentAgency.getDescription());
            tmp.put(LanguageTranslator.getString("vehicle.registrationNumber"), currentVehicle.getRegistrationNumber());
            tmp.put(LanguageTranslator.getString("generics.driver"), driver != null ? String.valueOf(driver.getNom()) + " " + driver.getPrenom() : LanguageTranslator.getString("generics.unknown"));
            tmp.put(LanguageTranslator.getString("offence.type"), UevOffence.LIBELLE[off.getOffenceTypeId()]);
            tmp.put(LanguageTranslator.getString("generics.begin"), off.getBegin());
            tmp.put(LanguageTranslator.getString("generics.end"), off.getEnd());
            tmp.put(LanguageTranslator.getString("generics.length"), 1 + (int)((off.getEnd().getTime() - off.getBegin().getTime()) / 60000L));
            tmp.put(LanguageTranslator.getString("generics.threshold"), off.getThreshold());
            tmp.put(LanguageTranslator.getString("generics.gravity"), Fonctions.getTypeWording(off.getGravity()));
            this.data.add(tmp);
        }
        catch (DBObjectNotFoundException e) {
            TimsLogger.warn("#Offence.process()# vehicle not found " + off.getVehicleId());
        }
        return tmp;
    }
}

