/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.util.Map;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.generator.DJGenerator;
import transport.report.generator.TimeConverter;
import transport.report.generator.TimeConverterFactory;

public class DJAgencySynthesis
extends DJGenerator {
    private Vector<Color> conditionalColors = new Vector();
    private Vector<Integer> conditionalThresholds = new Vector();

    public DJAgencySynthesis() {
        this.conditionalColors.add(new Color(0x99CCFF));
        this.conditionalThresholds.add(1);
        this.conditionalColors.add(new Color(0x66CC66));
        this.conditionalThresholds.add(360);
        this.conditionalColors.add(new Color(0xCC3333));
        this.conditionalThresholds.add(720);
        this.conditionalThresholds.add(120000);
    }

    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            detailed.setDetailHeight(23);
            for (CustomReportColumn column : this.report.getColumn()) {
                if (column.getType().equals("java.lang.Integer")) {
                    TimsLogger.debug("Creating summ and abs for " + column.getName());
                    detailed.addField(column.getName(), Integer.class.getName());
                    detailed.addGlobalVariable(String.valueOf(column.getName()) + "_SUM", String.valueOf(column.getName()) + "_COUNT", Integer.class.getName(), DJCalculation.SUM);
                    detailed.addField(String.valueOf(column.getName()) + "_ABS", String.class.getName());
                }
                CustomExpression ce = null;
                if (column.getType().equals("java.lang.Integer")) {
                    ce = this.getColumnContent(column.getName());
                }
                ColumnBuilder cb = this.prebuildColumn(column, ce, null);
                if (column.getType().equals("java.lang.Integer") && !"xls".equals(this.report.getProperties().get("OUT"))) {
                    if (column.getName().equals(LanguageTranslator.getString("generics.total"))) {
                        int dayCount = this.report.getColumn().size() - 2;
                        Vector<Integer> totalThresholds = new Vector<Integer>();
                        totalThresholds.add(1);
                        totalThresholds.add(360 * dayCount);
                        totalThresholds.add(720 * dayCount);
                        totalThresholds.add(120000);
                        cb.addConditionalStyles(this.coloredTimeStyle(this.getContentStyle(), totalThresholds, this.conditionalColors));
                    } else {
                        cb.addConditionalStyles(this.coloredTimeStyle(this.getContentStyle(), this.conditionalThresholds, this.conditionalColors));
                    }
                }
                AbstractColumn col = cb.build();
                if (column.getType().equals("java.lang.Integer")) {
                    detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTotalContent(column.getName()));
                }
                detailed.addColumn(col);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected CustomExpression getColumnContent(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                String sCount;
                int resolution = parameters.get("RESOLUTION") == null ? 0 : Integer.valueOf(parameters.get("RESOLUTION").toString());
                TimeConverter convert = TimeConverterFactory.getTimeConverter(resolution);
                int count = fields.get(fieldName) == null ? 0 : (Integer)fields.get(fieldName);
                String abs = (String)fields.get(String.valueOf(fieldName) + "_ABS");
                if (count == 0 && abs == null) {
                    return null;
                }
                String string = sCount = count != 0 ? convert.format(count) : null;
                String toReturn = abs == null ? sCount : (sCount == null ? abs : String.valueOf(sCount) + "\n" + abs);
                return toReturn;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected DJValueFormatter getTotalContent(final String fieldName) {
        return new DJValueFormatter(){

            public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
                int resolution = parameters.get("RESOLUTION") == null ? 0 : Integer.valueOf(parameters.get("RESOLUTION").toString());
                TimeConverter convert = TimeConverterFactory.getTimeConverter(resolution);
                int count = variables.get(String.valueOf(fieldName) + "_SUM") == null ? 0 : (Integer)variables.get(String.valueOf(fieldName) + "_SUM");
                return count != 0 ? convert.format(count) : null;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }
}

