/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import java.text.DecimalFormat;
import java.util.Map;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.generator.DJGenerator;

public class DJExpensesCondensedGenerator
extends DJGenerator {
    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = new DynamicReportBuilder();
            detailed.setTopMargin(10);
            detailed.setDetailHeight(15);
            detailed.setMargins(30, 20, 30, 15);
            detailed.setHeaderHeight(20);
            detailed.setGrandTotalLegend(LanguageTranslator.getString("generics.total"));
            detailed.setGrandTotalLegendStyle(this.getFooterStyle());
            detailed.setUseFullPageWidth(true);
            detailed.setPrintColumnNames(true);
            if (this.report != null && !"xls".equals(this.report.getProperties().get("OUT"))) {
                detailed.setTemplateFile(PORTRAIT_TEMPLATE, true, true, true, false);
            }
            for (CustomReportColumn column : this.report.getColumn()) {
                if (column.getType().equals("java.lang.Integer")) {
                    detailed.addField(String.valueOf(column.getName()) + "_COUNT", Integer.class.getName());
                    detailed.addGlobalVariable(String.valueOf(column.getName()) + "_COUNT_SUM", String.valueOf(column.getName()) + "_COUNT", Integer.class.getName(), DJCalculation.SUM);
                    detailed.addField(String.valueOf(column.getName()) + "_AMOUNT", Float.class.getName());
                    detailed.addGlobalVariable(String.valueOf(column.getName()) + "_AMOUNT_SUM", String.valueOf(column.getName()) + "_AMOUNT", Float.class.getName(), DJCalculation.SUM);
                } else {
                    detailed.addField(column.getName(), Float.class.getName());
                }
                ColumnBuilder columnBuilder = ColumnBuilder.getNew();
                columnBuilder.setHeaderStyle(this.getHeaderStyle());
                columnBuilder.setStyle(this.getContentStyle());
                columnBuilder.setTitle(column.getVisibleName());
                if (column.getType().equals("java.lang.Integer")) {
                    columnBuilder.setCustomExpression(this.getExpensesDetail(column.getName()));
                } else {
                    columnBuilder.setColumnProperty(column.getName(), column.getType());
                }
                if (column.getExpression() != null && !column.getExpression().equals("")) {
                    columnBuilder.setPattern(column.getExpression());
                }
                AbstractColumn col = columnBuilder.build();
                detailed.addColumn(col);
                if (!column.getType().equals("java.lang.Integer")) continue;
                detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTotalExpensesDetail(column.getName()));
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected CustomExpression getExpensesDetail(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                String sCount;
                int count;
                boolean showAmount;
                boolean bl = parameters.get("SHOW_AMOUNT") == null ? false : (showAmount = Integer.valueOf(parameters.get("SHOW_AMOUNT").toString()) == 1);
                boolean showCount = parameters.get("SHOW_COUNT") == null ? false : Integer.valueOf(parameters.get("SHOW_COUNT").toString()) == 1;
                float amount = fields.get(String.valueOf(fieldName) + "_AMOUNT") == null ? 0.0f : ((Float)fields.get(String.valueOf(fieldName) + "_AMOUNT")).floatValue();
                int n = count = fields.get(String.valueOf(fieldName) + "_COUNT") == null ? 0 : (Integer)fields.get(String.valueOf(fieldName) + "_COUNT");
                if (count == 0 && amount == 0.0f) {
                    return null;
                }
                String string = sCount = showCount ? String.valueOf(count) : "";
                String sAmount = showAmount ? (showCount ? "(" + new DecimalFormat("#,###,###,##0.00").format(amount) + ")" : new DecimalFormat("#,###,###,##0.00").format(amount)) : "";
                return String.valueOf(sCount) + sAmount;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected DJValueFormatter getTotalExpensesDetail(final String fieldName) {
        return new DJValueFormatter(){

            public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
                String sCount;
                int count;
                boolean showAmount;
                boolean bl = parameters.get("SHOW_AMOUNT") == null ? false : (showAmount = Integer.valueOf(parameters.get("SHOW_AMOUNT").toString()) == 1);
                boolean showCount = parameters.get("SHOW_COUNT") == null ? false : Integer.valueOf(parameters.get("SHOW_COUNT").toString()) == 1;
                float amount = variables.get(String.valueOf(fieldName) + "_AMOUNT_SUM") == null ? 0.0f : ((Float)variables.get(String.valueOf(fieldName) + "_AMOUNT_SUM")).floatValue();
                int n = count = variables.get(String.valueOf(fieldName) + "_COUNT_SUM") == null ? 0 : (Integer)variables.get(String.valueOf(fieldName) + "_COUNT_SUM");
                if (count == 0 && amount == 0.0f) {
                    return null;
                }
                String string = sCount = showCount ? String.valueOf(count) : "";
                String sAmount = showAmount ? (showCount ? "(" + new DecimalFormat("#,###,###,##0.00").format(amount) + ")" : new DecimalFormat("#,###,###,##0.00").format(amount)) : "";
                return String.valueOf(sCount) + sAmount;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }
}

