/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import java.text.DecimalFormat;
import java.util.Map;
import transpo.system.TimsLogger;
import transport.report.generator.DJGenerator;

public class DJExpensesGenerator
extends DJGenerator {
    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            if (this.report.getColumn().size() >= 8 && "1".equals(this.report.getProperties().get("SHOW_COUNT")) && "1".equals(this.report.getProperties().get("SHOW_AMOUNT")) && !"xls".equals(this.report.getProperties().get("OUT"))) {
                this.report.getProperties().put("TEMPLATE", LANDSCAPE_TEMPLATE);
                detailed.setDetailHeight(14);
                detailed.setTemplateFile(LANDSCAPE_TEMPLATE, true, true, true, false);
            }
            for (CustomReportColumn column : this.report.getColumn()) {
                if (column.getType().equals("java.lang.Integer")) {
                    detailed.addField(String.valueOf(column.getName()) + "_COUNT", Integer.class.getName());
                    detailed.addGlobalVariable(String.valueOf(column.getName()) + "_COUNT_SUM", String.valueOf(column.getName()) + "_COUNT", Integer.class.getName(), DJCalculation.SUM);
                    detailed.addField(String.valueOf(column.getName()) + "_AMOUNT", Float.class.getName());
                    detailed.addGlobalVariable(String.valueOf(column.getName()) + "_AMOUNT_SUM", String.valueOf(column.getName()) + "_AMOUNT", Float.class.getName(), DJCalculation.SUM);
                }
                CustomExpression ce = null;
                if (column.getType().equals("java.lang.Integer")) {
                    ce = this.getExpensesDetail(column.getName(), column.getExpression());
                }
                AbstractColumn col = this.prebuildColumn(column, ce, null).build();
                detailed.addColumn(col);
                if (!column.getType().equals("java.lang.Integer")) continue;
                detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTotalExpensesDetail(column.getName()));
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected CustomExpression getExpensesDetail(final String fieldName, final String columnPattern) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                String sCount;
                int count;
                boolean showAmount;
                String pattern;
                String string = pattern = columnPattern == null || columnPattern.equals("") ? "# ##0.000" : columnPattern;
                boolean bl = parameters.get("SHOW_AMOUNT") == null ? false : (showAmount = Integer.valueOf(parameters.get("SHOW_AMOUNT").toString()) == 1);
                boolean showCount = parameters.get("SHOW_COUNT") == null ? false : Integer.valueOf(parameters.get("SHOW_COUNT").toString()) == 1;
                float amount = fields.get(String.valueOf(fieldName) + "_AMOUNT") == null ? 0.0f : ((Float)fields.get(String.valueOf(fieldName) + "_AMOUNT")).floatValue();
                int n = count = fields.get(String.valueOf(fieldName) + "_COUNT") == null ? 0 : (Integer)fields.get(String.valueOf(fieldName) + "_COUNT");
                if (count == 0 && amount == 0.0f) {
                    return null;
                }
                String string2 = sCount = showCount ? String.valueOf(count) : "";
                String sAmount = showAmount ? (showCount ? " (" + new DecimalFormat(pattern).format(amount) + ")" : new DecimalFormat(pattern).format(amount)) : "";
                TimsLogger.debug("#getExpensesDetail.evaluate# returns " + sCount + sAmount);
                return String.valueOf(sCount) + sAmount;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected DJValueFormatter getTotalExpensesDetail(final String fieldName) {
        return new DJValueFormatter(){

            public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
                String sCount;
                int count;
                boolean showAmount;
                boolean bl = parameters.get("SHOW_AMOUNT") == null ? false : (showAmount = Integer.valueOf(parameters.get("SHOW_AMOUNT").toString()) == 1);
                boolean showCount = parameters.get("SHOW_COUNT") == null ? false : Integer.valueOf(parameters.get("SHOW_COUNT").toString()) == 1;
                float amount = variables.get(String.valueOf(fieldName) + "_AMOUNT_SUM") == null ? 0.0f : ((Float)variables.get(String.valueOf(fieldName) + "_AMOUNT_SUM")).floatValue();
                int n = count = variables.get(String.valueOf(fieldName) + "_COUNT_SUM") == null ? 0 : (Integer)variables.get(String.valueOf(fieldName) + "_COUNT_SUM");
                if (count == 0 && amount == 0.0f) {
                    return null;
                }
                String string = sCount = showCount ? String.valueOf(count) : "";
                String sAmount = showAmount ? (showCount ? " (" + new DecimalFormat("#,###,###,##0.00").format(amount) + ")" : new DecimalFormat("#,###,###,##0.00").format(amount)) : "";
                return String.valueOf(sCount) + sAmount;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }
}

