/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.util.Vector;
import transport.report.generator.DJGenerator;

public class DJGeneratorWithDateStyle
extends DJGenerator {
    private Vector<Color> conditionalColors = null;
    private Vector<Integer> conditionalThresholds = null;

    public DJGeneratorWithDateStyle(Vector<Color> conditionalColors, Vector<Integer> conditionalThresholds) {
        this.conditionalColors = conditionalColors;
        this.conditionalThresholds = conditionalThresholds;
    }

    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            for (CustomReportColumn column : this.report.getColumn()) {
                ColumnBuilder cb = this.prebuildColumn(column, null, null);
                if (column.getType().equals("java.util.Date") && !"xls".equals(this.report.getProperties().get("OUT"))) {
                    cb.setPattern(column.getExpression());
                    cb.addConditionalStyles(this.coloredDateStyle(this.getContentStyle(), this.conditionalThresholds, this.conditionalColors));
                }
                AbstractColumn col = cb.build();
                if (column.getType().equals("java.lang.Integer") && this.withTotal) {
                    if ("time".equals(column.getExpression())) {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTimeFormatter());
                    } else {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
                    }
                }
                detailed.addColumn(col);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

