/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.generator.DJGenerator;

public class DJOffenceSynthesisGenerator
extends DJGenerator {
    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            detailed.setHeaderHeight(0);
            GroupBuilder driverGB = new GroupBuilder();
            this.getHeaderStyle().getFont().setFontSize(this.getHeaderStyle().getFont().getFontSize() - 2.0f);
            for (CustomReportColumn column : this.report.getColumn()) {
                ColumnBuilder columnBuilder = ColumnBuilder.getNew();
                columnBuilder.setColumnProperty(column.getName(), column.getType());
                columnBuilder.setHeaderStyle(this.getHeaderStyle());
                columnBuilder.setTruncateSuffix("...");
                columnBuilder.setTitle(column.getVisibleName());
                if (column.getType().equals("java.util.Date")) {
                    columnBuilder.setWidth(40);
                }
                if (column.getWidth() != 0) {
                    columnBuilder.setWidth(column.getWidth());
                }
                if (column.getExpression() != null && !column.getExpression().equals("")) {
                    columnBuilder.setPattern(column.getExpression());
                }
                if (column.getType().equals("java.lang.Integer") && "time".equals(column.getExpression())) {
                    columnBuilder.setColumnProperty(column.getName(), "java.lang.Integer");
                    columnBuilder.setCustomExpression(this.getTimeExpression(column.getName()));
                    columnBuilder.setCustomExpressionForCalculation(this.getTimeSumExpression(column.getName()));
                }
                if (column.getName().equals(LanguageTranslator.getString("generics.driver"))) {
                    columnBuilder.setPrintRepeatedValues(false);
                } else {
                    columnBuilder.setStyle(this.getContentStyle());
                }
                AbstractColumn col = columnBuilder.build();
                detailed.addColumn(col);
                if (column.getName().equals(LanguageTranslator.getString("generics.driver"))) {
                    driverGB.setCriteriaColumn((PropertyColumn)col).setGroupLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS);
                }
                if (column.getType().equals("java.lang.Integer")) {
                    TimsLogger.debug("on ajoute la somme pour la colonne " + column.getVisibleName());
                    driverGB.addFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
                }
                if (!column.getType().equals("java.lang.Integer")) continue;
                detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
            }
            DJGroup driverG = driverGB.build();
            detailed.addGroup(driverG);
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

