/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import fr.pgh.conversion.ConversionTime;
import java.text.DecimalFormat;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transport.report.generator.TimeConverter;

public class TimeConverterFactory {
    private static HashMap<String, TimeConverter> list = new HashMap();
    public static final int MINUT = 1;
    public static final int HUNDREED = 0;

    public static TimeConverter getTimeConverter(int type) {
        TimsLogger.debug("#TimeConverterFactory.getTimeConverter# asking for " + type + " converter.");
        switch (type) {
            case 0: {
                return TimeConverterFactory.hundreedConverter();
            }
        }
        return TimeConverterFactory.minutConverter();
    }

    public static TimeConverter minutConverter() {
        TimeConverter minutConverter = list.get("minutConverter");
        if (minutConverter != null) {
            return minutConverter;
        }
        TimsLogger.debug("#TimeConverterFactory.minutConverter# creating minutConverter");
        minutConverter = new TimeConverter(){

            @Override
            public int parse(String value) throws Exception {
                if (!value.matches(".?\\d*[h\\,]{1}\\d{0,2}")) {
                    throw new Exception("Bad Pattern");
                }
                return ConversionTime.heureStringToInt(value, "h");
            }

            @Override
            public String format(int value) {
                return ConversionTime.heureIntToString(value, "h");
            }
        };
        list.put("minutConverter", minutConverter);
        return minutConverter;
    }

    public static TimeConverter hundreedConverter() {
        TimeConverter hundreedConverter = list.get("hundreedConverter");
        if (hundreedConverter != null) {
            return hundreedConverter;
        }
        TimsLogger.debug("#TimeConverterFactory.hundreedConverter# creating hundreddConverter");
        hundreedConverter = new TimeConverter(){

            @Override
            public int parse(String value) throws Exception {
                if (!value.matches(".?\\d*[h\\,]{1}\\d{0,2}")) {
                    throw new Exception("Bad Pattern " + value);
                }
                return ConversionTime.heureStringToInt(value, ",");
            }

            @Override
            public String format(int value) {
                return new DecimalFormat("#,###,###,##0.00").format(Integer.valueOf(value).floatValue() / 60.0f);
            }
        };
        list.put("hundreedConverter", hundreedConverter);
        return hundreedConverter;
    }
}

